/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.binary;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.util.CollectionUtils;
import org.gridgain.internal.dr.binary.BinaryMetadata;
import org.gridgain.internal.dr.binary.BinarySchema;
import org.jetbrains.annotations.Nullable;

public class BinaryContext {
    private static final IgniteLogger LOG = Loggers.forClass(BinaryContext.class);
    private final Int2ObjectMap<BinaryMetadata> binaryMeta = new Int2ObjectOpenHashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BinarySchema schema(int typeId, int schemaId) {
        this.lock.readLock().lock();
        try {
            BinaryMetadata metadata = (BinaryMetadata)this.binaryMeta.get(typeId);
            BinarySchema binarySchema = metadata == null ? null : metadata.schema(schemaId);
            return binarySchema;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int typeId(String clsName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Nullable
    public BinaryMetadata binaryMetadata(int typeId) {
        this.lock.readLock().lock();
        try {
            BinaryMetadata binaryMetadata = (BinaryMetadata)this.binaryMeta.get(typeId);
            return binaryMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Integer> binarySchemas(int typeId) {
        this.lock.readLock().lock();
        try {
            BinaryMetadata metadata = (BinaryMetadata)this.binaryMeta.get(typeId);
            IntSet intSet = metadata == null ? List.of() : metadata.schemasIds();
            return intSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBinaryMetadata(BinaryMetadata metadata) {
        this.lock.writeLock().lock();
        try {
            int typeId = metadata.typeId();
            BinaryMetadata currentMeta = (BinaryMetadata)this.binaryMeta.get(typeId);
            if (currentMeta == null) {
                LOG.debug("Register binary metadata: {}", new Object[]{metadata});
                this.binaryMeta.put(typeId, (Object)metadata);
            } else {
                if (!currentMeta.typeName().equals(metadata.typeName())) {
                    throw new IllegalArgumentException(IgniteStringFormatter.format((String)"Duplicate metadata registration: typeId={}, typeName={}, newName={}", (Object[])new Object[]{typeId, currentMeta.typeName(), metadata.typeName()}));
                }
                IntSet currentSchemaIds = currentMeta.schemasIds();
                int[] newSchemaIds = metadata.schemasIds().intStream().filter(id -> !currentSchemaIds.contains(id)).toArray();
                if (newSchemaIds.length > 0) {
                    LOG.debug("Register schema for binary metadata: typeId={}, schemaIds={}", new Object[]{typeId, newSchemaIds});
                    this.binaryMeta.put(typeId, (Object)BinaryContext.mergeSchemas(currentMeta, metadata.schemas()));
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBinarySchema(int typeId, BinarySchema schema) {
        this.lock.writeLock().lock();
        try {
            BinaryMetadata meta = this.binaryMetadata(typeId);
            int schemaId = schema.schemaId();
            if (meta == null) {
                throw new IllegalArgumentException(IgniteStringFormatter.format((String)"BinarySchema wasn't registered. Unknown binary type id: typeId=", (Object[])new Object[]{typeId}));
            }
            BinarySchema schema0 = meta.schema(schemaId);
            if (schema0 != null) {
                if (!Arrays.equals(schema0.fieldIds(), schema.fieldIds())) {
                    throw new IllegalArgumentException(IgniteStringFormatter.format((String)"Duplicate schema for type: schemaId={} typeId={}", (Object[])new Object[]{schemaId, typeId}));
                }
                return;
            }
            meta = BinaryContext.mergeSchemas(meta, List.of(schema));
            this.binaryMeta.put(typeId, (Object)meta);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static BinaryMetadata mergeSchemas(BinaryMetadata meta, Collection<BinarySchema> newSchemas) {
        Int2ObjectMap schemas = (Int2ObjectMap)Stream.concat(meta.schemas().stream(), newSchemas.stream()).collect(CollectionUtils.toIntMapCollector(BinarySchema::schemaId, Function.identity()));
        return new BinaryMetadata(meta.typeId(), meta.typeName(), meta.fieldsMap(), (Int2ObjectMap<BinarySchema>)schemas);
    }
}

