/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.lang.ErrorGroups;
import org.gridgain.internal.dr.binary.BinaryContext;
import org.gridgain.internal.dr.binary.BinaryMetadata;
import org.jetbrains.annotations.Nullable;

public class DrReceiverMetadataManager {
    private final BinaryContext ctx;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final ConcurrentHashMap<Integer, CompletableFuture<BinaryMetadata>> waiters = new ConcurrentHashMap();

    public DrReceiverMetadataManager(BinaryContext ctx) {
        this.ctx = ctx;
    }

    public void registerMetadata(BinaryMetadata meta) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            this.ctx.registerBinaryMetadata(meta);
            CompletableFuture<BinaryMetadata> waiter = this.waiters.remove(meta.typeId());
            if (waiter != null) {
                waiter.complete(meta);
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Nullable
    public BinaryMetadata metadata(int typeId) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            BinaryMetadata binaryMetadata = this.ctx.binaryMetadata(typeId);
            return binaryMetadata;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<BinaryMetadata> metadataAsync(int typeId) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            CompletableFuture future;
            BinaryMetadata meta = this.ctx.binaryMetadata(typeId);
            if (meta != null) {
                future = CompletableFuture.completedFuture(meta);
                this.waiters.remove(typeId);
            } else {
                future = this.waiters.computeIfAbsent(typeId, id -> new CompletableFuture());
                if (!future.isDone() && (meta = this.ctx.binaryMetadata(typeId)) != null) {
                    future.complete(meta);
                    this.waiters.remove(typeId);
                }
            }
            CompletableFuture completableFuture = future;
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void stop() {
        this.busyLock.block();
    }
}

