/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.internal.configuration.ConfigurationChanger;
import org.apache.ignite.internal.configuration.ConfigurationTreeGenerator;
import org.apache.ignite.internal.configuration.storage.LocalFileConfigurationStorage;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.validation.ConfigurationValidatorImpl;
import org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.dr.configuration.DrReceiverConfiguration;

public class DrReceiverConfigDefaultsGenerator {
    public static void main(String[] args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("Please provide the path to the config file as an argument");
        }
        Path configPath = Paths.get(args[0], new String[0]);
        ConfigurationChanger changer = null;
        try {
            changer = DrReceiverConfigDefaultsGenerator.createConfigurationChanger(configPath);
            changer.start();
            changer.onDefaultsPersisted().get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot generate default configuration.", e);
        }
        finally {
            if (changer != null) {
                changer.stop();
            }
        }
    }

    private static ConfigurationChanger createConfigurationChanger(Path configPath) {
        final ConfigurationTreeGenerator localConfigurationGenerator = new ConfigurationTreeGenerator(List.of(DrReceiverConfiguration.KEY), Set.of(), Set.of());
        LocalFileConfigurationStorage storage = new LocalFileConfigurationStorage(configPath, localConfigurationGenerator, null);
        ConfigurationValidatorImpl configurationValidator = ConfigurationValidatorImpl.withDefaultValidators(localConfigurationGenerator, Set.of());
        ConfigurationChanger.ConfigurationUpdateListener empty = (oldRoot, newRoot, storageRevision, notificationNumber) -> CompletableFutures.nullCompletedFuture();
        return new ConfigurationChanger(empty, List.of(DrReceiverConfiguration.KEY), storage, configurationValidator, x -> {}, c -> false){

            @Override
            public InnerNode createRootNode(RootKey<?, ?, ?> rootKey) {
                return localConfigurationGenerator.instantiateNode(rootKey.schemaClass());
            }
        };
    }
}

