/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.nio;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;

public class IdleChannelHandler
extends ChannelDuplexHandler {
    private static final IgniteLogger LOG = Loggers.forClass(IdleChannelHandler.class);
    private final long idleTimeout;

    public IdleChannelHandler(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            LOG.warn("Closing idle channel: [remoteAddress={}, idleTimeout={}]", ctx.channel().remoteAddress(), this.idleTimeout);
            ctx.close();
        }
    }
}

