/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.table;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.apache.ignite.table.ContinuousQueryWatermark;
import org.apache.ignite.table.TableRowEventType;
import org.apache.ignite.table.partition.Partition;
import org.jetbrains.annotations.Nullable;

public class ContinuousQueryOptions {
    public static final ContinuousQueryOptions DEFAULT = ContinuousQueryOptions.builder().build();
    private final int pageSize;
    private final int pollIntervalMs;
    private final EnumSet<TableRowEventType> eventTypes;
    @Nullable
    private final Set<String> columnNames;
    @Nullable
    private final Set<Partition> partitions;
    @Nullable
    private final ContinuousQueryWatermark watermark;
    private final boolean enableEmptyBatches;
    private final Executor executor;
    private final boolean skipOldEntries;

    private ContinuousQueryOptions(int pageSize, int pollIntervalMs, EnumSet<TableRowEventType> eventTypes, @Nullable Set<String> columnNames, @Nullable Set<Partition> partitions, @Nullable ContinuousQueryWatermark watermark, boolean enableEmptyBatches, Executor executor, boolean skipOldEntries) {
        this.pageSize = pageSize;
        this.pollIntervalMs = pollIntervalMs;
        this.eventTypes = eventTypes;
        this.columnNames = columnNames == null ? null : Set.copyOf(columnNames);
        this.partitions = partitions == null ? null : Set.copyOf(partitions);
        this.watermark = watermark;
        this.enableEmptyBatches = enableEmptyBatches;
        this.executor = executor;
        this.skipOldEntries = skipOldEntries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int pollIntervalMs() {
        return this.pollIntervalMs;
    }

    public EnumSet<TableRowEventType> eventTypes() {
        return this.eventTypes;
    }

    @Nullable
    public Set<String> columnNames() {
        return this.columnNames;
    }

    @Nullable
    public Set<Partition> partitions() {
        return this.partitions;
    }

    @Nullable
    public ContinuousQueryWatermark watermark() {
        return this.watermark;
    }

    public boolean enableEmptyBatches() {
        return this.enableEmptyBatches;
    }

    public Executor executor() {
        return this.executor;
    }

    public boolean skipOldEntries() {
        return this.skipOldEntries;
    }

    public static class Builder {
        private int pageSize = 1000;
        private int pollIntervalMs = 1000;
        private EnumSet<TableRowEventType> eventTypes = EnumSet.allOf(TableRowEventType.class);
        @Nullable
        private Set<String> columnNames = null;
        @Nullable
        private Set<Partition> partitions = null;
        @Nullable
        private ContinuousQueryWatermark watermark = null;
        private boolean enableEmptyBatches;
        private Executor executor = ForkJoinPool.commonPool();
        private boolean skipOldEntries;

        public Builder pageSize(int pageSize) {
            if (pageSize <= 0) {
                throw new IllegalArgumentException("Page size must be positive: " + pageSize);
            }
            this.pageSize = pageSize;
            return this;
        }

        public Builder pollIntervalMs(int pollIntervalMs) {
            if (pollIntervalMs <= 0) {
                throw new IllegalArgumentException("Poll interval must be positive: " + pollIntervalMs);
            }
            this.pollIntervalMs = pollIntervalMs;
            return this;
        }

        public Builder eventTypes(EnumSet<TableRowEventType> eventTypes) {
            Objects.requireNonNull(eventTypes, "Event types must not be null");
            if (eventTypes.isEmpty()) {
                throw new IllegalArgumentException("Event types must not be empty");
            }
            this.eventTypes = eventTypes;
            return this;
        }

        public Builder eventTypes(TableRowEventType ... eventTypes) {
            Objects.requireNonNull(eventTypes, "Event types must not be null");
            if (eventTypes.length == 0) {
                throw new IllegalArgumentException("Event types must not be empty");
            }
            this.eventTypes = EnumSet.of(eventTypes[0], eventTypes);
            return this;
        }

        public Builder columnNames(@Nullable Set<String> columnNames) {
            if (columnNames != null && columnNames.isEmpty()) {
                throw new IllegalArgumentException("Column names must not be empty");
            }
            this.columnNames = columnNames;
            return this;
        }

        public Builder partitions(@Nullable Set<Partition> partitions) {
            if (partitions != null && partitions.isEmpty()) {
                throw new IllegalArgumentException("Partitions must not be empty");
            }
            this.partitions = partitions;
            return this;
        }

        public Builder partitions(Partition ... partitions) {
            return this.partitions(Set.of(partitions));
        }

        public Builder watermark(@Nullable ContinuousQueryWatermark watermark) {
            this.watermark = watermark;
            return this;
        }

        public Builder enableEmptyBatches(boolean enableEmptyBatches) {
            this.enableEmptyBatches = enableEmptyBatches;
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder skipOldEntries(boolean skipOldEntries) {
            this.skipOldEntries = skipOldEntries;
            return this;
        }

        public ContinuousQueryOptions build() {
            return new ContinuousQueryOptions(this.pageSize, this.pollIntervalMs, this.eventTypes, this.columnNames, this.partitions, this.watermark, this.enableEmptyBatches, this.executor, this.skipOldEntries);
        }
    }
}

