/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.ssl;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.ignite.internal.network.configuration.SslView;
import org.apache.ignite.internal.network.ssl.KeystoreLoader;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;

public final class SslContextProvider {
    private SslContextProvider() {
    }

    public static SslContext createClientSslContext(SslView ssl) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(KeystoreLoader.load(ssl.trustStore()));
            SslContextBuilder builder = SslContextBuilder.forClient().trustManager(trustManagerFactory);
            builder.endpointIdentificationAlgorithm(null);
            SslContextProvider.setCiphers(builder, ssl);
            ClientAuth clientAuth = ClientAuth.valueOf(ssl.clientAuth().toUpperCase());
            if (ClientAuth.NONE == clientAuth) {
                return builder.build();
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(KeystoreLoader.load(ssl.keyStore()), ssl.keyStore().password().toCharArray());
            builder.keyManager(keyManagerFactory);
            return builder.build();
        }
        catch (NoSuchFileException e) {
            throw new IgniteException(ErrorGroups.Common.SSL_CONFIGURATION_ERR, String.format("File %s not found", e.getMessage()), (Throwable)e);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new IgniteException(ErrorGroups.Common.SSL_CONFIGURATION_ERR, (Throwable)e);
        }
    }

    public static SslContext createServerSslContext(SslView ssl) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(KeystoreLoader.load(ssl.keyStore()), ssl.keyStore().password().toCharArray());
            SslContextBuilder builder = SslContextBuilder.forServer(keyManagerFactory);
            SslContextProvider.setCiphers(builder, ssl);
            ClientAuth clientAuth = ClientAuth.valueOf(ssl.clientAuth().toUpperCase());
            if (ClientAuth.NONE == clientAuth) {
                return builder.build();
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(KeystoreLoader.load(ssl.trustStore()));
            builder.clientAuth(clientAuth).trustManager(trustManagerFactory);
            return builder.build();
        }
        catch (NoSuchFileException e) {
            throw new IgniteException(ErrorGroups.Common.SSL_CONFIGURATION_ERR, String.format("File %s not found", e.getMessage()), (Throwable)e);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new IgniteException(ErrorGroups.Common.SSL_CONFIGURATION_ERR, (Throwable)e);
        }
    }

    private static void setCiphers(SslContextBuilder builder, SslView ssl) {
        if (!ssl.ciphers().isBlank()) {
            List<String> ciphers = Arrays.stream(ssl.ciphers().split(",")).map(String::strip).collect(Collectors.toList());
            builder.ciphers(ciphers);
        }
    }
}

