/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.network.serialization.BrokenSerializationMethods;
import org.apache.ignite.internal.network.serialization.BuiltInType;
import org.apache.ignite.internal.network.serialization.ClassDescriptorMerger;
import org.apache.ignite.internal.network.serialization.Classes;
import org.apache.ignite.internal.network.serialization.DeclaredType;
import org.apache.ignite.internal.network.serialization.FieldDescriptor;
import org.apache.ignite.internal.network.serialization.MergedField;
import org.apache.ignite.internal.network.serialization.MergedLayer;
import org.apache.ignite.internal.network.serialization.Serialization;
import org.apache.ignite.internal.network.serialization.SerializationType;
import org.apache.ignite.internal.network.serialization.SpecialSerializationMethods;
import org.apache.ignite.internal.network.serialization.SpecialSerializationMethodsImpl;
import org.jetbrains.annotations.Nullable;

public class ClassDescriptor
implements DeclaredType {
    private final String className;
    @Nullable
    private final Class<?> localClass;
    private final int descriptorId;
    @Nullable
    private final ClassDescriptor superClassDescriptor;
    @Nullable
    private final ClassDescriptor componentTypeDescriptor;
    private final boolean isPrimitive;
    private final boolean isArray;
    private final boolean isRuntimeEnum;
    private final boolean isSerializationTypeKnownUpfront;
    private final List<FieldDescriptor> fields;
    private final Serialization serialization;
    private final ClassDescriptor localDescriptor;
    private final List<MergedField> mergedFields;
    private final int primitiveFieldsDataSize;
    private final int objectFieldsCount;
    private final int fieldNullsBitmapSize;
    private final Object2IntMap<String> fieldNullsBitmapIndices;
    private Map<String, FieldDescriptor> fieldsByName;
    private Object2IntMap<String> primitiveFieldDataOffsets;
    private Object2IntMap<String> objectFieldIndices;
    private final List<ClassDescriptor> lineage;
    private final List<MergedLayer> mergedLineage;
    private final SpecialSerializationMethods serializationMethods;

    public static ClassDescriptor forLocal(Class<?> localClass, int descriptorId, @Nullable ClassDescriptor superClassDescriptor, @Nullable ClassDescriptor componentTypeDescriptor, List<FieldDescriptor> fields, Serialization serialization) {
        return new ClassDescriptor(localClass, descriptorId, superClassDescriptor, componentTypeDescriptor, fields, serialization);
    }

    public static ClassDescriptor forRemote(Class<?> localClass, int descriptorId, @Nullable ClassDescriptor superClassDescriptor, @Nullable ClassDescriptor componentTypeDescriptor, boolean isPrimitive, boolean isArray, boolean isRuntimeEnum, boolean isSerializationTypeKnownUpfront, List<FieldDescriptor> fields, Serialization serialization, ClassDescriptor localDescriptor) {
        Objects.requireNonNull(localDescriptor);
        return new ClassDescriptor(localClass.getName(), localClass, descriptorId, superClassDescriptor, componentTypeDescriptor, isPrimitive, isArray, isRuntimeEnum, isSerializationTypeKnownUpfront, fields, serialization, ClassDescriptorMerger.mergeFields(localDescriptor.fields(), fields), false, localDescriptor);
    }

    public static ClassDescriptor forRemote(String className, int descriptorId, @Nullable ClassDescriptor superClassDescriptor, @Nullable ClassDescriptor componentTypeDescriptor, boolean isPrimitive, boolean isArray, boolean isRuntimeEnum, boolean isSerializationTypeKnownUpfront, List<FieldDescriptor> fields, Serialization serialization) {
        return new ClassDescriptor(className, null, descriptorId, superClassDescriptor, componentTypeDescriptor, isPrimitive, isArray, isRuntimeEnum, isSerializationTypeKnownUpfront, fields, serialization, fields.stream().map(MergedField::remoteOnly).collect(Collectors.toList()), false, null);
    }

    private ClassDescriptor(Class<?> localClass, int descriptorId, @Nullable ClassDescriptor superClassDescriptor, @Nullable ClassDescriptor componentTypeDescriptor, List<FieldDescriptor> fields, Serialization serialization) {
        this(localClass.getName(), localClass, descriptorId, superClassDescriptor, componentTypeDescriptor, localClass.isPrimitive(), localClass.isArray(), Classes.isRuntimeEnum(localClass), Classes.isSerializationTypeKnownUpfront(localClass), fields, serialization, fields.stream().map(field -> new MergedField((FieldDescriptor)field, (FieldDescriptor)field)).collect(Collectors.toList()), true, null);
    }

    private ClassDescriptor(String className, @Nullable Class<?> localClass, int descriptorId, @Nullable ClassDescriptor superClassDescriptor, @Nullable ClassDescriptor componentTypeDescriptor, boolean isPrimitive, boolean isArray, boolean isRuntimeEnum, boolean isSerializationTypeKnownUpfront, List<FieldDescriptor> fields, Serialization serialization, List<MergedField> mergedFields, boolean thisIsLocal, @Nullable ClassDescriptor localDescriptor) {
        assert (localClass != null && (thisIsLocal || localDescriptor != null) || localClass == null && !thisIsLocal && localDescriptor == null);
        this.className = className;
        this.localClass = localClass;
        this.descriptorId = descriptorId;
        this.superClassDescriptor = superClassDescriptor;
        this.componentTypeDescriptor = componentTypeDescriptor;
        this.isPrimitive = isPrimitive;
        this.isArray = isArray;
        this.isRuntimeEnum = isRuntimeEnum;
        this.isSerializationTypeKnownUpfront = isSerializationTypeKnownUpfront;
        this.fields = List.copyOf(fields);
        this.serialization = serialization;
        this.localDescriptor = thisIsLocal ? this : localDescriptor;
        this.mergedFields = List.copyOf(mergedFields);
        this.primitiveFieldsDataSize = ClassDescriptor.computePrimitiveFieldsDataSize(fields);
        this.objectFieldsCount = ClassDescriptor.computeObjectFieldsCount(fields);
        this.fieldNullsBitmapSize = ClassDescriptor.computeFieldNullsBitmapSize(fields);
        this.fieldNullsBitmapIndices = ClassDescriptor.computeFieldNullsBitmapIndices(fields);
        this.lineage = ClassDescriptor.computeLineage(this);
        this.mergedLineage = thisIsLocal ? this.lineage.stream().map(layer -> new MergedLayer((ClassDescriptor)layer, (ClassDescriptor)layer)).collect(Collectors.toList()) : (localDescriptor == null ? this.lineage.stream().map(MergedLayer::remoteOnly).collect(Collectors.toList()) : ClassDescriptorMerger.mergeLineages(localDescriptor.lineage(), this.lineage));
        this.serializationMethods = localClass != null ? new SpecialSerializationMethodsImpl(this) : new BrokenSerializationMethods(className);
    }

    private static int computePrimitiveFieldsDataSize(List<FieldDescriptor> fields) {
        int accumulatedBytes = 0;
        for (FieldDescriptor fieldDesc : fields) {
            if (!fieldDesc.isPrimitive()) continue;
            accumulatedBytes += fieldDesc.primitiveWidthInBytes();
        }
        return accumulatedBytes;
    }

    private static int computeObjectFieldsCount(List<FieldDescriptor> fields) {
        return (int)fields.stream().filter(fieldDesc -> !fieldDesc.isPrimitive()).count();
    }

    private static int computeFieldNullsBitmapSize(List<FieldDescriptor> fields) {
        int count = 0;
        for (FieldDescriptor fieldDescriptor : fields) {
            if (!ClassDescriptor.isIncludedInNullsBitmap(fieldDescriptor)) continue;
            ++count;
        }
        return count;
    }

    private static boolean isIncludedInNullsBitmap(FieldDescriptor fieldDescriptor) {
        return !fieldDescriptor.isPrimitive() && fieldDescriptor.isSerializationTypeKnownUpfront();
    }

    private static Object2IntMap<String> computeFieldNullsBitmapIndices(List<FieldDescriptor> fields) {
        Object2IntOpenHashMap<String> map = new Object2IntOpenHashMap<String>();
        int index = 0;
        for (FieldDescriptor fieldDescriptor : fields) {
            int indexToPut = ClassDescriptor.isIncludedInNullsBitmap(fieldDescriptor) ? index++ : -1;
            map.put(fieldDescriptor.name(), indexToPut);
        }
        return Object2IntMaps.unmodifiable(map);
    }

    private static List<ClassDescriptor> computeLineage(ClassDescriptor descriptor) {
        ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>();
        for (ClassDescriptor currentDesc = descriptor; currentDesc != null; currentDesc = currentDesc.superClassDescriptor()) {
            descriptors.add(currentDesc);
        }
        Collections.reverse(descriptors);
        return List.copyOf(descriptors);
    }

    public int descriptorId() {
        return this.descriptorId;
    }

    @Nullable
    public ClassDescriptor superClassDescriptor() {
        return this.superClassDescriptor;
    }

    @Nullable
    public Integer superClassDescriptorId() {
        return this.superClassDescriptor == null ? null : Integer.valueOf(this.superClassDescriptor.descriptorId());
    }

    @Nullable
    public String superClassName() {
        return this.superClassDescriptor == null ? null : this.superClassDescriptor.className();
    }

    @Nullable
    public ClassDescriptor componentTypeDescriptor() {
        return this.componentTypeDescriptor;
    }

    @Nullable
    public Integer componentTypeDescriptorId() {
        return this.componentTypeDescriptor == null ? null : Integer.valueOf(this.componentTypeDescriptor.descriptorId());
    }

    @Nullable
    public String componentTypeName() {
        return this.componentTypeDescriptor == null ? null : this.componentTypeDescriptor.className();
    }

    public boolean isComponentSerializationTypeKnownUpfront() {
        return this.componentTypeDescriptor != null && this.componentTypeDescriptor.isSerializationTypeKnownUpfront();
    }

    public List<FieldDescriptor> fields() {
        return this.fields;
    }

    public String className() {
        return this.className;
    }

    public Class<?> localClass() {
        if (this.localClass == null) {
            throw new IllegalStateException("No local class exists for '" + this.className + "'");
        }
        return this.localClass;
    }

    public Serialization serialization() {
        return this.serialization;
    }

    public SerializationType serializationType() {
        return this.serialization.type();
    }

    public List<MergedField> mergedFields() {
        return this.mergedFields;
    }

    public boolean isSerializable() {
        return this.serialization.type() == SerializationType.SERIALIZABLE;
    }

    public boolean isExternalizable() {
        return this.serialization.type() == SerializationType.EXTERNALIZABLE;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isRuntimeEnum() {
        return this.isRuntimeEnum;
    }

    public boolean hasWriteObject() {
        return this.serialization.hasWriteObject();
    }

    public boolean hasReadObject() {
        return this.serialization.hasReadObject();
    }

    public boolean hasReadObjectNoData() {
        return this.serialization.hasReadObjectNoData();
    }

    public boolean hasWriteReplace() {
        return this.serialization.hasWriteReplace();
    }

    public boolean hasReadResolve() {
        return this.serialization.hasReadResolve();
    }

    public boolean isNull() {
        return this.descriptorId == BuiltInType.NULL.descriptorId();
    }

    public boolean isSingletonList() {
        return this.descriptorId == BuiltInType.SINGLETON_LIST.descriptorId();
    }

    public boolean supportsWriteReplace() {
        return (this.isSerializable() || this.isExternalizable()) && this.hasWriteReplace();
    }

    public boolean isProxy() {
        return this.descriptorId == BuiltInType.PROXY.descriptorId();
    }

    public boolean hasLocal() {
        return this.localDescriptor != null;
    }

    public ClassDescriptor local() {
        if (this.localDescriptor == null) {
            throw new IllegalStateException("No local descriptor exists for '" + this.className + "'");
        }
        return this.localDescriptor;
    }

    public SpecialSerializationMethods serializationMethods() {
        return this.serializationMethods;
    }

    public boolean describesSameClass(ClassDescriptor other) {
        return Objects.equals(this.className, other.className);
    }

    public int primitiveFieldsDataSize() {
        return this.primitiveFieldsDataSize;
    }

    public int objectFieldsCount() {
        return this.objectFieldsCount;
    }

    public int fieldIndexInNullsBitmapSize() {
        return this.fieldNullsBitmapSize;
    }

    public int fieldIndexInNullsBitmap(String fieldName) {
        if (!this.fieldNullsBitmapIndices.containsKey(fieldName)) {
            throw new IllegalStateException("Unknown field " + fieldName);
        }
        return this.fieldNullsBitmapIndices.getInt(fieldName);
    }

    public int primitiveFieldDataOffset(String fieldName, String requiredTypeName) {
        FieldDescriptor fieldDesc = this.requiredFieldByName(fieldName);
        if (!Objects.equals(fieldDesc.typeName(), requiredTypeName)) {
            throw new IllegalStateException("Field " + fieldName + " has type " + fieldDesc.typeName() + ", but it was used as " + requiredTypeName);
        }
        this.ensurePrimitiveDataOffsetsMapComputed();
        assert (this.primitiveFieldDataOffsets.containsKey(fieldName));
        return this.primitiveFieldDataOffsets.getInt(fieldName);
    }

    private void ensurePrimitiveDataOffsetsMapComputed() {
        if (this.primitiveFieldDataOffsets == null) {
            this.primitiveFieldDataOffsets = ClassDescriptor.primitiveFieldDataOffsetsMap(this.fields);
        }
    }

    private FieldDescriptor requiredFieldByName(String fieldName) {
        FieldDescriptor fieldDesc = this.fieldByName(fieldName);
        if (fieldDesc == null) {
            throw new IllegalStateException("Did not find a field with name " + fieldName);
        }
        return fieldDesc;
    }

    @Nullable
    private FieldDescriptor fieldByName(String fieldName) {
        if (this.fieldsByName == null) {
            this.fieldsByName = ClassDescriptor.fieldsByNameMap(this.fields);
        }
        return this.fieldsByName.get(fieldName);
    }

    private static Map<String, FieldDescriptor> fieldsByNameMap(List<FieldDescriptor> fields) {
        return fields.stream().collect(Collectors.toUnmodifiableMap(FieldDescriptor::name, Function.identity()));
    }

    private static Object2IntMap<String> primitiveFieldDataOffsetsMap(List<FieldDescriptor> fields) {
        Object2IntOpenHashMap<String> map = new Object2IntOpenHashMap<String>();
        int accumulatedOffset = 0;
        for (FieldDescriptor fieldDesc : fields) {
            if (!fieldDesc.isPrimitive()) continue;
            map.put(fieldDesc.name(), accumulatedOffset);
            accumulatedOffset += fieldDesc.primitiveWidthInBytes();
        }
        return Object2IntMaps.unmodifiable(map);
    }

    private boolean hasPrimitiveField(String fieldName) {
        FieldDescriptor fieldDesc = this.fieldByName(fieldName);
        if (fieldDesc == null) {
            return false;
        }
        this.ensurePrimitiveDataOffsetsMapComputed();
        return this.primitiveFieldDataOffsets.containsKey(fieldName);
    }

    public boolean isPrimitiveFieldAddedLocally(String fieldName) {
        return !this.hasPrimitiveField(fieldName) && this.local().hasPrimitiveField(fieldName);
    }

    public int objectFieldIndex(String fieldName) {
        this.ensureObjectFieldIndicesComputed();
        if (!this.objectFieldIndices.containsKey(fieldName)) {
            throw new IllegalStateException("Did not find an object field with name " + fieldName);
        }
        return this.objectFieldIndices.getInt(fieldName);
    }

    private void ensureObjectFieldIndicesComputed() {
        if (this.objectFieldIndices == null) {
            this.objectFieldIndices = this.computeObjectFieldIndices(this.fields);
        }
    }

    private Object2IntMap<String> computeObjectFieldIndices(List<FieldDescriptor> fields) {
        Object2IntOpenHashMap<String> map = new Object2IntOpenHashMap<String>();
        int currentIndex = 0;
        for (FieldDescriptor fieldDesc : fields) {
            if (fieldDesc.isPrimitive()) continue;
            map.put(fieldDesc.name(), currentIndex);
            ++currentIndex;
        }
        return Object2IntMaps.unmodifiable(map);
    }

    private boolean hasObjectField(String fieldName) {
        this.ensureObjectFieldIndicesComputed();
        return this.objectFieldIndices.containsKey(fieldName);
    }

    public boolean isObjectFieldAddedLocally(String fieldName) {
        return !this.hasObjectField(fieldName) && this.local().hasObjectField(fieldName);
    }

    public List<ClassDescriptor> lineage() {
        return this.lineage;
    }

    public List<MergedLayer> mergedLineage() {
        return this.mergedLineage;
    }

    public boolean isLatin1String() {
        return this.descriptorId == BuiltInType.STRING_LATIN1.descriptorId();
    }

    @Override
    public int typeDescriptorId() {
        return this.descriptorId;
    }

    @Override
    public boolean isSerializationTypeKnownUpfront() {
        return this.isSerializationTypeKnownUpfront;
    }

    public String toString() {
        return "ClassDescriptor{className='" + this.className() + "', descriptorId=" + this.descriptorId + "}";
    }
}

