/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Collectors;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessageHandler;
import org.apache.ignite.internal.network.TrackableNetworkMessageHandler;
import org.apache.ignite.internal.network.annotations.MessageGroup;
import org.apache.ignite.internal.thread.ExecutorChooser;

public abstract class AbstractMessagingService
implements MessagingService {
    protected static final ExecutorChooser<NetworkMessage> IN_INBOUND_POOL = new InInboundPool();
    private final AtomicReferenceArray<Handlers> handlersByGroupType = new AtomicReferenceArray(32768);

    @Override
    public void addMessageHandler(Class<?> messageGroup, NetworkMessageHandler handler) {
        this.doAddMessageHandler(messageGroup, IN_INBOUND_POOL, handler);
    }

    @Override
    public void addMessageHandler(Class<?> messageGroup, ExecutorChooser<NetworkMessage> executorChooser, NetworkMessageHandler handler) {
        this.doAddMessageHandler(messageGroup, executorChooser, handler);
    }

    private void doAddMessageHandler(Class<?> messageGroup, ExecutorChooser<NetworkMessage> executorChooser, NetworkMessageHandler handler) {
        NetworkMessageHandler handlerToAdd = AbstractMessagingService.wantsInboundPool(executorChooser) ? new TrackableNetworkMessageHandler(handler) : handler;
        HandlerContext newHandlerContext = new HandlerContext(handlerToAdd, executorChooser);
        this.handlersByGroupType.getAndUpdate(AbstractMessagingService.getMessageGroupType(messageGroup), oldHandlers -> {
            if (oldHandlers == null) {
                return new Handlers(messageGroup, List.of(newHandlerContext));
            }
            if (oldHandlers.messageGroup != messageGroup) {
                throw new IllegalArgumentException(String.format("Handlers are already registered for a message group with the same group ID but different class. Group ID: %d, given message group: %s, existing message group: %s", AbstractMessagingService.getMessageGroupType(messageGroup), messageGroup, oldHandlers.messageGroup));
            }
            ArrayList<HandlerContext> handlerContexts = new ArrayList<HandlerContext>(oldHandlers.handlerContexts.size() + 1);
            handlerContexts.addAll(oldHandlers.handlerContexts);
            handlerContexts.add(newHandlerContext);
            return new Handlers(messageGroup, handlerContexts);
        });
    }

    protected static boolean wantsInboundPool(ExecutorChooser<NetworkMessage> executorChooser) {
        return executorChooser == IN_INBOUND_POOL;
    }

    private static short getMessageGroupType(Class<?> messageGroup) {
        MessageGroup annotation = messageGroup.getAnnotation(MessageGroup.class);
        assert (annotation != null) : "No MessageGroup annotation present on " + messageGroup;
        short groupType = annotation.groupType();
        assert (groupType >= 0) : "Group type must not be negative";
        return groupType;
    }

    protected final Collection<NetworkMessageHandler> getMessageHandlers(short groupType) {
        assert (groupType >= 0) : "Group type must not be negative";
        Handlers result = this.handlersByGroupType.get(groupType);
        return result == null ? List.of() : (Collection)result.handlerContexts.stream().map(HandlerContext::handler).collect(Collectors.toList());
    }

    protected final List<HandlerContext> getHandlerContexts(short groupType) {
        assert (groupType >= 0) : "Group type must not be negative";
        Handlers result = this.handlersByGroupType.get(groupType);
        return result == null ? List.of() : result.handlerContexts;
    }

    protected static class HandlerContext {
        private final NetworkMessageHandler handler;
        private final ExecutorChooser<NetworkMessage> executorChooser;

        private HandlerContext(NetworkMessageHandler handler, ExecutorChooser<NetworkMessage> executorChooser) {
            this.handler = handler;
            this.executorChooser = executorChooser;
        }

        public NetworkMessageHandler handler() {
            return this.handler;
        }

        public ExecutorChooser<NetworkMessage> executorChooser() {
            return this.executorChooser;
        }
    }

    private static class Handlers {
        final Class<?> messageGroup;
        final List<HandlerContext> handlerContexts;

        Handlers(Class<?> messageGroup, List<HandlerContext> handlerContexts) {
            this.messageGroup = messageGroup;
            this.handlerContexts = handlerContexts;
        }
    }

    private static class InInboundPool
    implements ExecutorChooser<NetworkMessage> {
        private InInboundPool() {
        }

        @Override
        public Executor choose(NetworkMessage argument) {
            throw new UnsupportedOperationException("This should never be called");
        }
    }
}

