/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.error.code.processor;

import com.google.auto.service.AutoService;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import org.apache.ignite.error.code.annotations.ErrorCodeGroup;
import org.apache.ignite.internal.error.code.generators.AbstractCodeGenerator;
import org.apache.ignite.internal.error.code.generators.CppGenerator;
import org.apache.ignite.internal.error.code.generators.CsharpGenerator;
import org.apache.ignite.internal.error.code.processor.ErrorCodeGroupDescriptor;
import org.apache.ignite.internal.error.code.processor.ErrorCodeGroupProcessorException;

@AutoService(value={Processor.class})
public class ErrorCodeGroupProcessor
extends AbstractProcessor {
    private static final short GRIDGAIN_ERROR_GROUP_OFFSET = 1000;
    private Trees trees;

    @Override
    public void init(ProcessingEnvironment pe) {
        super.init(pe);
        this.trees = Trees.instance(pe);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ErrorCodeGroup.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set errorGroups = annotations.stream().map(roundEnv::getElementsAnnotatedWith).flatMap(Collection::stream).map(TypeElement.class::cast).collect(Collectors.toSet());
        if (errorGroups.isEmpty()) {
            return true;
        }
        ArrayList<ErrorCodeGroupDescriptor> descriptors = new ArrayList<ErrorCodeGroupDescriptor>();
        for (TypeElement clazz : errorGroups) {
            ErrorCodeTreeScanner codeScanner = new ErrorCodeTreeScanner();
            codeScanner.scan(this.trees.getPath(clazz), this.trees);
            ErrorCodeGroupDescriptor descriptor = codeScanner.getDescriptor();
            descriptor.className = clazz.getSimpleName().toString();
            descriptors.add(descriptor);
        }
        this.generate(descriptors);
        return true;
    }

    private void generate(List<ErrorCodeGroupDescriptor> groups) {
        groups.sort(Comparator.comparing(g -> g.groupCode));
        for (ErrorCodeGroupDescriptor group : groups) {
            group.errorCodes.sort(Comparator.comparing(d -> d.code));
        }
        List<CsharpGenerator> generators = List.of(new CppGenerator(this.processingEnv, "cpp/ignite/common/error_codes.h"), new CsharpGenerator(this.processingEnv, "dotnet/Apache.Ignite/ErrorCodes.g.cs"));
        for (AbstractCodeGenerator abstractCodeGenerator : generators) {
            abstractCodeGenerator.generate(groups);
        }
    }

    static class ErrorCodeTreeScanner
    extends TreePathScanner<Object, Trees> {
        private final ErrorCodeGroupDescriptor descriptor = new ErrorCodeGroupDescriptor();
        private ErrorCodeGroupProcessorException ex;

        ErrorCodeTreeScanner() {
        }

        ErrorCodeGroupDescriptor getDescriptor() {
            if (this.ex != null) {
                throw this.ex;
            }
            return this.descriptor;
        }

        private Object visitErrorCodeField(VariableTree variableTree, Trees trees) {
            ExpressionTree initializer = variableTree.getInitializer();
            String name = variableTree.getName().toString();
            try {
                if (MethodInvocationTree.class.isAssignableFrom(initializer.getClass())) {
                    ExpressionTree expr;
                    List<? extends ExpressionTree> args = ((MethodInvocationTree)initializer).getArguments();
                    if (args.get(0) instanceof TypeCastTree) {
                        expr = ((TypeCastTree)args.get(0)).getExpression();
                        if (expr instanceof ParenthesizedTree) {
                            expr = ((ParenthesizedTree)expr).getExpression();
                        }
                    } else {
                        expr = args.get(0);
                    }
                    this.descriptor.errorCodes.add(new ErrorCodeGroupDescriptor.ErrorCode((Integer)((LiteralTree)expr).getValue(), name));
                } else if (IdentifierTree.class.isAssignableFrom(initializer.getClass())) {
                    boolean hasDeprecated = variableTree.getModifiers().getAnnotations().stream().anyMatch(annotation -> "Deprecated".contentEquals(annotation.getAnnotationType().toString()));
                    if (!hasDeprecated) {
                        this.ex = new ErrorCodeGroupProcessorException(String.format("Alias %s must be marked as @Deprecated", name));
                    } else {
                        String identifier = ((IdentifierTree)initializer).getName().toString();
                        this.descriptor.deprecatedAliases.add(new ErrorCodeGroupDescriptor.DeprecatedAlias(name, identifier));
                    }
                } else {
                    this.ex = new ErrorCodeGroupProcessorException(String.format("AST parsing error: Expected MethodInvocationTree or IdentifierTree in initializer, but got %s", initializer.getClass().getSimpleName()));
                }
            }
            catch (Exception e) {
                this.ex = new ErrorCodeGroupProcessorException("AST parsing error", e);
            }
            return super.visitVariable(variableTree, trees);
        }

        private Object visitErrorCodeGroupField(VariableTree variableTree, Trees trees) {
            ExpressionTree initializer = variableTree.getInitializer();
            try {
                List<? extends ExpressionTree> args = ((MethodInvocationTree)initializer).getArguments();
                if (((IdentifierTree)((MethodInvocationTree)initializer).getMethodSelect()).getName().contentEquals("registerGgErrorGroup")) {
                    String errorPrefix = "GG";
                    LiteralTree groupNameExpr = (LiteralTree)args.get(0);
                    ExpressionTree groupCodeExpr = args.get(1);
                    this.descriptor.errorPrefix = errorPrefix;
                    this.descriptor.groupName = (String)groupNameExpr.getValue();
                    this.descriptor.groupCode = (Integer)((LiteralTree)groupCodeExpr).getValue() + 1000;
                } else {
                    ExpressionTree groupCodeExpr;
                    LiteralTree groupNameExpr;
                    String errorPrefix;
                    switch (args.size()) {
                        case 2: {
                            errorPrefix = "IGN";
                            groupNameExpr = (LiteralTree)args.get(0);
                            groupCodeExpr = ((TypeCastTree)args.get(1)).getExpression();
                            break;
                        }
                        case 3: {
                            errorPrefix = ((LiteralTree)args.get(0)).getValue().toString();
                            groupNameExpr = (LiteralTree)args.get(1);
                            groupCodeExpr = ((TypeCastTree)args.get(2)).getExpression();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected arguments count " + args.size());
                        }
                    }
                    if (groupCodeExpr instanceof ParenthesizedTree) {
                        groupCodeExpr = ((ParenthesizedTree)groupCodeExpr).getExpression();
                    }
                    this.descriptor.errorPrefix = errorPrefix;
                    this.descriptor.groupName = (String)groupNameExpr.getValue();
                    this.descriptor.groupCode = (Integer)((LiteralTree)groupCodeExpr).getValue();
                }
            }
            catch (Exception e) {
                this.ex = new ErrorCodeGroupProcessorException("AST parsing error: " + e, e);
            }
            return super.visitVariable(variableTree, trees);
        }

        @Override
        public Object visitVariable(VariableTree variableTree, Trees trees) {
            if (variableTree.getType().toString().equals("int")) {
                return this.visitErrorCodeField(variableTree, trees);
            }
            if (variableTree.getType().toString().equals("ErrorGroup")) {
                return this.visitErrorCodeGroupField(variableTree, trees);
            }
            return super.visitVariable(variableTree, trees);
        }
    }
}

