/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.TableNotFoundException;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.tx.Transaction;
import org.gridgain.internal.dr.DrUpdate;
import org.gridgain.internal.dr.DrUpdateHandler;
import org.gridgain.internal.dr.DrUtils;
import org.gridgain.internal.dr.common.GridCacheVersion;
import org.jetbrains.annotations.Nullable;

public class DrUpdateHandlerImpl
implements DrUpdateHandler {
    private static final IgniteLogger LOG = Loggers.forClass(DrUpdateHandlerImpl.class);
    private final Ignite client;
    private final KeyValueView<Tuple, Tuple> tombstonesTable;
    private final long tombstoneTtl;

    public DrUpdateHandlerImpl(Ignite client, Duration tombstoneTtl) {
        assert (!tombstoneTtl.isNegative());
        this.client = client;
        this.tombstoneTtl = DrUtils.getOrDefaultTtlInSeconds(tombstoneTtl);
        this.tombstonesTable = DrUtils.initTombstonesTable(client).keyValueView();
    }

    @Override
    public CompletableFuture<Void> applyUpdates(QualifiedName tableName, List<DrUpdate> rowUpdates) {
        return this.client.tables().tableAsync(tableName).thenCompose(table -> table == null ? CompletableFuture.failedFuture((Throwable)new TableNotFoundException(tableName)) : this.applyUpdates((Table)table, rowUpdates));
    }

    private CompletableFuture<Void> applyUpdates(Table table, List<DrUpdate> rowUpdates) {
        KeyValueView kvView = table.keyValueView();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(rowUpdates.size());
        for (DrUpdate row : rowUpdates) {
            CompletableFuture<Void> opFuture = new CompletableFuture<Void>();
            futures.add(opFuture);
            try {
                if (row.isTombstone()) {
                    this.remove(table.name(), (KeyValueView<Tuple, Tuple>)kvView, row).whenComplete(DrUpdateHandlerImpl.complete(opFuture));
                    continue;
                }
                this.put(table.name(), (KeyValueView<Tuple, Tuple>)kvView, row).whenComplete(DrUpdateHandlerImpl.complete(opFuture));
            }
            catch (Throwable err) {
                opFuture.completeExceptionally(err);
            }
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private CompletableFuture<Void> put(String tableName, KeyValueView<Tuple, Tuple> table, DrUpdate row) {
        Tuple tombstoneKey = DrUtils.createTombstoneKey(tableName, row);
        Transaction tx = this.client.transactions().begin();
        return ((CompletableFuture)((CompletableFuture)this.findOutOfOrderRemove(tx, tombstoneKey, row.version()).thenCompose(outOfOrderRemoveFound -> outOfOrderRemoveFound != false ? CompletableFutures.nullCompletedFuture() : DrUpdateHandlerImpl.applyUpdate(table, tx, row))).thenCompose(unused -> tx.commitAsync())).whenComplete((unused, err) -> {
            if (err != null) {
                tx.rollbackAsync();
            }
        });
    }

    private CompletableFuture<Void> remove(String tableName, KeyValueView<Tuple, Tuple> table, DrUpdate newTombstone) {
        Tuple tombstoneKey = DrUtils.createTombstoneKey(tableName, newTombstone);
        Transaction tx = this.client.transactions().begin();
        return ((CompletableFuture)((CompletableFuture)this.putOrRenewTombstone(tx, tombstoneKey, newTombstone).thenCompose(tombstoneRenewed -> tombstoneRenewed != false ? DrUpdateHandlerImpl.applyRemove(table, tx, newTombstone.key(), newTombstone.version()) : CompletableFutures.nullCompletedFuture())).thenCompose(unused -> tx.commitAsync())).whenComplete((unused, err) -> {
            if (err != null) {
                tx.rollbackAsync();
            }
        });
    }

    private CompletableFuture<Boolean> findOutOfOrderRemove(Transaction tx, Tuple tombstoneKey, GridCacheVersion rowVersion) {
        return ((CompletableFuture)this.tombstonesTable.getAsync(tx, (Object)tombstoneKey).thenCompose(tombstone -> {
            if (tombstone == null) {
                return CompletableFutures.falseCompletedFuture();
            }
            GridCacheVersion tombstoneVersion = DrUtils.unmarshalVersion((byte[])tombstone.value("version"));
            assert (tombstoneVersion != null) : "tombstone must have a version";
            if (tombstoneVersion.compareTo(rowVersion) > 0) {
                return CompletableFutures.trueCompletedFuture();
            }
            return this.tombstonesTable.removeAsync(tx, (Object)tombstoneKey).thenApply(ignore -> false);
        })).whenComplete((res, err) -> {
            if (ExceptionUtils.isOrCausedBy(TableNotFoundException.class, (Throwable)err)) {
                LOG.error("System table for DR tombstones wasn't found: tableName={}", new Object[]{DrUtils.DR_TOMBSTONES_TABLE_NAME.toCanonicalForm()});
            }
        });
    }

    private static CompletableFuture<Void> applyUpdate(KeyValueView<Tuple, Tuple> table, Transaction tx, DrUpdate row) {
        assert (!row.isTombstone());
        return table.getAsync(tx, (Object)row.key()).thenCompose(value -> value != null && DrUpdateHandlerImpl.keepExistingVersion(DrUpdateHandlerImpl.extractVersion(value), row.version()) ? CompletableFutures.nullCompletedFuture() : table.putAsync(tx, (Object)row.key(), (Object)row.value()).thenApply(unused -> null));
    }

    private CompletableFuture<Boolean> putOrRenewTombstone(Transaction tx, Tuple tombstoneKey, DrUpdate newTombstone) {
        assert (newTombstone.isTombstone());
        return ((CompletableFuture)this.tombstonesTable.getAsync(tx, (Object)tombstoneKey).thenCompose(oldTombstone -> {
            if (oldTombstone != null && DrUpdateHandlerImpl.keepExistingVersion(DrUpdateHandlerImpl.extractVersion(oldTombstone), newTombstone.version())) {
                return CompletableFutures.falseCompletedFuture();
            }
            Tuple tombstoneValue = DrUtils.createTombstoneValue(newTombstone.version(), this.tombstoneTtl);
            return this.tombstonesTable.putAsync(tx, (Object)tombstoneKey, (Object)tombstoneValue).thenApply(ignore -> true);
        })).whenComplete((res, err) -> {
            if (ExceptionUtils.isOrCausedBy(TableNotFoundException.class, (Throwable)err)) {
                LOG.error("System table for DR tombstones wasn't found: tableName={}", new Object[]{DrUtils.DR_TOMBSTONES_TABLE_NAME.toCanonicalForm()});
            }
        });
    }

    private static CompletableFuture<Boolean> applyRemove(KeyValueView<Tuple, Tuple> table, Transaction tx, Tuple key, GridCacheVersion version) {
        return table.getAsync(tx, (Object)key).thenCompose(oldRow -> {
            if (oldRow == null) {
                return CompletableFutures.trueCompletedFuture();
            }
            if (DrUpdateHandlerImpl.keepExistingVersion(DrUpdateHandlerImpl.extractVersion(oldRow), version)) {
                return CompletableFutures.falseCompletedFuture();
            }
            return table.removeAsync(tx, (Object)key).thenApply(ignore -> true);
        });
    }

    @Nullable
    private static GridCacheVersion extractVersion(Tuple row) {
        byte[] version = (byte[])row.value("DrVersion");
        return DrUtils.unmarshalVersion(version);
    }

    private static <T> BiConsumer<T, Throwable> complete(CompletableFuture<Void> opFut) {
        return (res, err) -> {
            if (err == null) {
                opFut.complete(null);
            } else {
                opFut.completeExceptionally((Throwable)err);
            }
        };
    }

    private static boolean keepExistingVersion(@Nullable GridCacheVersion existingVersion, GridCacheVersion newVersion) {
        return existingVersion == null || existingVersion.dataCenterId() == newVersion.dataCenterId() && existingVersion.compareTo(newVersion) > 0;
    }
}

