/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.dr.configuration;

import java.time.DateTimeException;
import java.time.ZoneId;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.gridgain.dr.configuration.TimeZoneValidator;

public class TimeZoneValidatorImpl
implements Validator<TimeZoneValidator, String> {
    public static final TimeZoneValidatorImpl INSTANCE = new TimeZoneValidatorImpl();

    public void validate(TimeZoneValidator annotation, ValidationContext<String> ctx) {
        String timeZone = (String)ctx.getNewValue();
        try {
            ZoneId.of(timeZone);
        }
        catch (DateTimeException ex) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Invalid value of time zone. " + ex.getMessage()));
        }
    }
}

