/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.optimized;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import org.gridgain.internal.dr.common.MarshallerException;
import org.gridgain.internal.dr.optimized.GridUnsafeDataInput;
import org.gridgain.internal.dr.optimized.OptimizedContext;
import org.gridgain.internal.dr.optimized.OptimizedObjectInputStream;
import org.jetbrains.annotations.Nullable;

public class OptimizedMarshaller {
    public final OptimizedContext ctx;

    public OptimizedMarshaller(OptimizedContext ctx) {
        this.ctx = ctx;
    }

    public Object readOptimized(byte[] arr, int start, int len) {
        Object object;
        GridUnsafeDataInput in = new GridUnsafeDataInput();
        in.bytes(arr, start, arr.length);
        OptimizedObjectInputStream stream = new OptimizedObjectInputStream(this.ctx, in);
        try {
            object = stream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new MarshallerException("Failed to unmarshal object by OptimizedMarshaller.", (Throwable)e);
            }
        }
        stream.close();
        return object;
    }

    public static void writeUuid(DataOutput out, UUID uid) throws IOException {
        out.writeBoolean(uid == null);
        if (uid != null) {
            out.writeLong(uid.getMostSignificantBits());
            out.writeLong(uid.getLeastSignificantBits());
        }
    }

    @Nullable
    public static UUID readUuid(DataInput in) throws IOException {
        if (!in.readBoolean()) {
            long most = in.readLong();
            long least = in.readLong();
            return new UUID(most, least);
        }
        return null;
    }
}

