/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.BytecodeUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class ParameterizedType {
    private final String type;
    private final String className;
    private final String simpleName;
    private final List<String> parameters;
    private final boolean isInterface;
    @Nullable
    private final Class<?> primitiveType;
    @Nullable
    private final ParameterizedType arrayComponentType;

    public static ParameterizedType typeFromJavaClassName(String className) {
        Objects.requireNonNull(className, "type is null");
        return new ParameterizedType(className.replace('.', '/'));
    }

    public static ParameterizedType typeFromPathName(String className) {
        Objects.requireNonNull(className, "type is null");
        return new ParameterizedType(className);
    }

    public static ParameterizedType type(Type type) {
        Objects.requireNonNull(type, "type is null");
        return new ParameterizedType(type.getInternalName());
    }

    public static ParameterizedType type(Class<?> type) {
        Objects.requireNonNull(type, "type is null");
        return new ParameterizedType(type);
    }

    public static ParameterizedType type(Class<?> type, Class<?> ... parameters) {
        Objects.requireNonNull(type, "type is null");
        return new ParameterizedType(type, parameters);
    }

    public static ParameterizedType type(Class<?> type, ParameterizedType ... parameters) {
        Objects.requireNonNull(type, "type is null");
        return new ParameterizedType(type, parameters);
    }

    public ParameterizedType(String className) {
        Objects.requireNonNull(className, "className is null");
        BytecodeUtils.checkArgument(!className.contains("."), "Invalid class name %s", className);
        BytecodeUtils.checkArgument(!className.endsWith(";"), "Invalid class name %s", className);
        this.className = className;
        this.simpleName = className.substring(className.lastIndexOf("/") + 1);
        this.type = "L" + className + ";";
        this.parameters = List.of();
        this.isInterface = false;
        this.primitiveType = null;
        this.arrayComponentType = null;
    }

    private ParameterizedType(Class<?> type) {
        Objects.requireNonNull(type, "type is null");
        this.type = ParameterizedType.toInternalIdentifier(type);
        this.className = ParameterizedType.getPathName(type);
        this.simpleName = type.getSimpleName();
        this.parameters = List.of();
        this.isInterface = type.isInterface();
        this.primitiveType = type.isPrimitive() ? type : null;
        this.arrayComponentType = type.isArray() ? ParameterizedType.type(type.getComponentType()) : null;
    }

    private ParameterizedType(Class<?> type, Class<?> ... parameters) {
        Objects.requireNonNull(type, "type is null");
        this.type = ParameterizedType.toInternalIdentifier(type);
        this.className = ParameterizedType.getPathName(type);
        this.simpleName = type.getSimpleName();
        this.parameters = Arrays.stream(parameters).map(ParameterizedType::toInternalIdentifier).collect(Collectors.toList());
        this.isInterface = type.isInterface();
        this.primitiveType = type.isPrimitive() ? type : null;
        this.arrayComponentType = type.isArray() ? ParameterizedType.type(type.getComponentType()) : null;
    }

    private ParameterizedType(Class<?> type, ParameterizedType ... parameters) {
        Objects.requireNonNull(type, "type is null");
        this.type = ParameterizedType.toInternalIdentifier(type);
        this.className = ParameterizedType.getPathName(type);
        this.simpleName = type.getSimpleName();
        this.parameters = Arrays.stream(parameters).map(ParameterizedType::toString).collect(Collectors.toList());
        this.isInterface = type.isInterface();
        this.primitiveType = type.isPrimitive() ? type : null;
        this.arrayComponentType = type.isArray() ? ParameterizedType.type(type.getComponentType()) : null;
    }

    public String getClassName() {
        return this.className;
    }

    public String getJavaClassName() {
        return this.className.replace('/', '.');
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getType() {
        return this.type;
    }

    public Type getAsmType() {
        return Type.getObjectType(this.className);
    }

    public String getGenericSignature() {
        StringBuilder sb = new StringBuilder();
        if (this.primitiveType != null || this.arrayComponentType != null) {
            return this.type;
        }
        sb.append('L').append(this.className);
        if (!this.parameters.isEmpty()) {
            sb.append("<");
            for (String parameterType : this.parameters) {
                sb.append(parameterType);
            }
            sb.append(">");
        }
        sb.append(";");
        return sb.toString();
    }

    public boolean isGeneric() {
        return !this.parameters.isEmpty();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    @Nullable
    public Class<?> getPrimitiveType() {
        return this.primitiveType;
    }

    public boolean isPrimitive() {
        return this.primitiveType != null;
    }

    @Nullable
    public ParameterizedType getArrayComponentType() {
        return this.arrayComponentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterizedType that = (ParameterizedType)o;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return this.getGenericSignature();
    }

    public static String getPathName(Class<?> n) {
        return n.getName().replace('.', '/');
    }

    private static String toInternalIdentifier(Class<?> n) {
        if (n.isArray()) {
            if ((n = n.getComponentType()).isPrimitive()) {
                if (n == Byte.TYPE) {
                    return "[B";
                }
                if (n == Boolean.TYPE) {
                    return "[Z";
                }
                if (n == Short.TYPE) {
                    return "[S";
                }
                if (n == Character.TYPE) {
                    return "[C";
                }
                if (n == Integer.TYPE) {
                    return "[I";
                }
                if (n == Float.TYPE) {
                    return "[F";
                }
                if (n == Double.TYPE) {
                    return "[D";
                }
                if (n == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
            }
            return "[" + ParameterizedType.toInternalIdentifier(n);
        }
        if (n.isPrimitive()) {
            if (n == Byte.TYPE) {
                return "B";
            }
            if (n == Boolean.TYPE) {
                return "Z";
            }
            if (n == Short.TYPE) {
                return "S";
            }
            if (n == Character.TYPE) {
                return "C";
            }
            if (n == Integer.TYPE) {
                return "I";
            }
            if (n == Float.TYPE) {
                return "F";
            }
            if (n == Double.TYPE) {
                return "D";
            }
            if (n == Long.TYPE) {
                return "J";
            }
            if (n == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
        }
        return "L" + ParameterizedType.getPathName(n) + ";";
    }
}

