/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.AddFakeLineNumberClassVisitor;
import com.facebook.presto.bytecode.ByteCodeTooLargeException;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.ClassInfoLoader;
import com.facebook.presto.bytecode.CompilationException;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.SmartClassWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassTooLargeException;
import org.objectweb.asm.MethodTooLargeException;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;

public class ClassGenerator {
    private final DynamicClassLoader classLoader;
    private final boolean fakeLineNumbers;
    private final boolean runAsmVerifier;
    private final boolean dumpRawBytecode;
    private final Writer output;
    private final Optional<Path> dumpClassPath;

    public static ClassGenerator classGenerator(ClassLoader parentClassLoader) {
        if (parentClassLoader instanceof DynamicClassLoader) {
            return ClassGenerator.classGenerator((DynamicClassLoader)parentClassLoader);
        }
        return ClassGenerator.classGenerator(parentClassLoader, Map.of());
    }

    public static ClassGenerator classGenerator(ClassLoader parentClassLoader, Map<Long, MethodHandle> callSiteBindings) {
        return ClassGenerator.classGenerator(new DynamicClassLoader(parentClassLoader, callSiteBindings));
    }

    public static ClassGenerator classGenerator(DynamicClassLoader classLoader) {
        return new ClassGenerator(classLoader, false, false, false, Writer.nullWriter(), Optional.empty());
    }

    private ClassGenerator(DynamicClassLoader classLoader, boolean fakeLineNumbers, boolean runAsmVerifier, boolean dumpRawBytecode, Writer output, Optional<Path> dumpClassPath) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
        this.fakeLineNumbers = fakeLineNumbers;
        this.runAsmVerifier = runAsmVerifier;
        this.dumpRawBytecode = dumpRawBytecode;
        this.output = Objects.requireNonNull(output, "output is null");
        this.dumpClassPath = Objects.requireNonNull(dumpClassPath, "dumpClassPath is null");
    }

    public ClassGenerator fakeLineNumbers(boolean fakeLineNumbers) {
        return new ClassGenerator(this.classLoader, fakeLineNumbers, this.runAsmVerifier, this.dumpRawBytecode, this.output, this.dumpClassPath);
    }

    public ClassGenerator runAsmVerifier(boolean runAsmVerifier) {
        return new ClassGenerator(this.classLoader, this.fakeLineNumbers, runAsmVerifier, this.dumpRawBytecode, this.output, this.dumpClassPath);
    }

    public ClassGenerator dumpRawBytecode(boolean dumpRawBytecode) {
        return new ClassGenerator(this.classLoader, this.fakeLineNumbers, this.runAsmVerifier, dumpRawBytecode, this.output, this.dumpClassPath);
    }

    public ClassGenerator outputTo(Writer output) {
        return new ClassGenerator(this.classLoader, this.fakeLineNumbers, this.runAsmVerifier, this.dumpRawBytecode, output, this.dumpClassPath);
    }

    public ClassGenerator dumpClassFilesTo(Path dumpClassPath) {
        return this.dumpClassFilesTo(Optional.of(dumpClassPath));
    }

    public ClassGenerator dumpClassFilesTo(Optional<Path> dumpClassPath) {
        return new ClassGenerator(this.classLoader, this.fakeLineNumbers, this.runAsmVerifier, this.dumpRawBytecode, this.output, dumpClassPath);
    }

    public <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType) {
        Map<String, Class<?>> classes = this.defineClasses(List.of(classDefinition));
        return classes.values().stream().findFirst().get().asSubclass(superType);
    }

    public Map<String, Class<?>> defineClasses(List<ClassDefinition> classDefinitions) {
        ClassInfoLoader classInfoLoader = ClassInfoLoader.createClassInfoLoader(classDefinitions, this.classLoader);
        LinkedHashMap<String, byte[]> bytecodes = new LinkedHashMap<String, byte[]>();
        for (ClassDefinition classDefinition : classDefinitions) {
            byte[] bytecode;
            SmartClassWriter smartClassWriter = new SmartClassWriter(classInfoLoader);
            try {
                classDefinition.visit(this.fakeLineNumbers ? new AddFakeLineNumberClassVisitor(smartClassWriter) : smartClassWriter);
            }
            catch (IndexOutOfBoundsException | NegativeArraySizeException e) {
                StringWriter out = new StringWriter();
                classDefinition.visit(new TraceClassVisitor(null, new Textifier(), new PrintWriter(out)));
                throw new IllegalArgumentException("Error processing class definition:\n" + out, e);
            }
            try {
                bytecode = smartClassWriter.toByteArray();
            }
            catch (ClassTooLargeException | MethodTooLargeException largeCodeException) {
                throw new ByteCodeTooLargeException(largeCodeException);
            }
            catch (RuntimeException e) {
                throw new CompilationException("Error compiling class: " + classDefinition.getName(), e);
            }
            bytecodes.put(classDefinition.getType().getJavaClassName(), bytecode);
            if (!this.runAsmVerifier) continue;
            ClassReader reader = new ClassReader(bytecode);
            CheckClassAdapter.verify(reader, this.classLoader, true, new PrintWriter(this.output));
        }
        this.dumpClassPath.ifPresent(path -> bytecodes.forEach((className, bytecode) -> {
            String name = ParameterizedType.typeFromJavaClassName(className).getClassName() + ".class";
            Path file = path.resolve(name).toAbsolutePath();
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.write(file, bytecode, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to write generated class file: " + file, e);
            }
        }));
        if (this.dumpRawBytecode) {
            Iterator<ClassDefinition> iterator = bytecodes.values().iterator();
            while (iterator.hasNext()) {
                Object bytecode = (byte[])iterator.next();
                ClassReader classReader = new ClassReader((byte[])bytecode);
                classReader.accept(new TraceClassVisitor(new PrintWriter(this.output)), 8);
            }
        }
        Map<String, Class<?>> classes = this.classLoader.defineClasses(bytecodes);
        try {
            for (Class clazz : classes.values()) {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
        }
        catch (ClassNotFoundException | VerifyError e) {
            throw new RuntimeException(e);
        }
        return classes;
    }
}

