/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.optimized;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.ignite.internal.util.GridUnsafe;
import org.gridgain.internal.dr.optimized.OptimizedFieldType;
import org.gridgain.internal.dr.optimized.OptimizedMarshallerUtils;
import org.gridgain.internal.dr.optimized.OptimizedObjectInputStream;
import org.jetbrains.annotations.Nullable;

class OptimizedClassDescriptor {
    private final Class<?> cls;
    private final String name;
    private final int typeId;
    private final short checksum;
    private final int type;
    private boolean isPrimitive;
    private boolean isEnum;
    private boolean isSerial;
    private boolean isCls;
    private Object[] enumVals;
    private Constructor<?> constructor;
    private Fields fields;
    private List<Method> writeObjMtds;
    @Nullable
    private Method writeReplaceMtd;
    private List<Method> readObjMtds;
    @Nullable
    private Method readResolveMtd;
    private long dfltsFieldOff;
    private long loadFactorFieldOff;
    private long accessOrderFieldOff;
    private Class<?>[] proxyIntfs;

    OptimizedClassDescriptor(Class<?> cls, int typeId, String name) throws IOException {
        this.cls = cls;
        this.typeId = typeId;
        this.name = name;
        if (cls == Byte.TYPE || cls == Byte.class) {
            this.type = 1;
            this.isPrimitive = true;
        } else if (cls == Short.TYPE || cls == Short.class) {
            this.type = 2;
            this.isPrimitive = true;
        } else if (cls == Integer.TYPE || cls == Integer.class) {
            this.type = 3;
            this.isPrimitive = true;
        } else if (cls == Long.TYPE || cls == Long.class) {
            this.type = 4;
            this.isPrimitive = true;
        } else if (cls == Float.TYPE || cls == Float.class) {
            this.type = 5;
            this.isPrimitive = true;
        } else if (cls == Double.TYPE || cls == Double.class) {
            this.type = 6;
            this.isPrimitive = true;
        } else if (cls == Character.TYPE || cls == Character.class) {
            this.type = 7;
            this.isPrimitive = true;
        } else if (cls == Boolean.TYPE || cls == Boolean.class) {
            this.type = 8;
            this.isPrimitive = true;
        } else if (cls == byte[].class) {
            this.type = 9;
        } else if (cls == short[].class) {
            this.type = 10;
        } else if (cls == int[].class) {
            this.type = 11;
        } else if (cls == long[].class) {
            this.type = 12;
        } else if (cls == float[].class) {
            this.type = 13;
        } else if (cls == double[].class) {
            this.type = 14;
        } else if (cls == char[].class) {
            this.type = 15;
        } else if (cls == boolean[].class) {
            this.type = 16;
        } else if (cls.isArray()) {
            this.type = 17;
        } else if (cls == String.class) {
            this.type = 18;
        } else if (cls.isEnum()) {
            this.type = 100;
            this.isEnum = true;
            this.enumVals = cls.getEnumConstants();
        } else {
            Class<?> parent = cls.getSuperclass();
            if (parent != null && parent.isEnum()) {
                this.type = 100;
                this.isEnum = true;
                this.enumVals = parent.getEnumConstants();
            } else if (cls == UUID.class) {
                this.type = 19;
            } else {
                if (cls == Properties.class) {
                    this.type = 20;
                    try {
                        this.dfltsFieldOff = GridUnsafe.objectFieldOffset((Field)Properties.class.getDeclaredField("defaults"));
                    }
                    catch (NoSuchFieldException e) {
                        throw new IOException(e);
                    }
                }
                if (cls == ArrayList.class) {
                    this.type = 21;
                } else {
                    if (cls == HashMap.class) {
                        this.type = 22;
                        try {
                            this.loadFactorFieldOff = GridUnsafe.objectFieldOffset((Field)HashMap.class.getDeclaredField("loadFactor"));
                        }
                        catch (NoSuchFieldException e) {
                            throw new IOException(e);
                        }
                    }
                    if (cls == HashSet.class) {
                        this.type = 23;
                        try {
                            this.loadFactorFieldOff = GridUnsafe.objectFieldOffset((Field)HashMap.class.getDeclaredField("loadFactor"));
                        }
                        catch (NoSuchFieldException e) {
                            throw new IOException(e);
                        }
                    }
                    if (cls == LinkedList.class) {
                        this.type = 24;
                    } else {
                        if (cls == LinkedHashMap.class) {
                            this.type = 25;
                            try {
                                this.loadFactorFieldOff = GridUnsafe.objectFieldOffset((Field)HashMap.class.getDeclaredField("loadFactor"));
                                this.accessOrderFieldOff = GridUnsafe.objectFieldOffset((Field)LinkedHashMap.class.getDeclaredField("accessOrder"));
                            }
                            catch (NoSuchFieldException e) {
                                throw new IOException(e);
                            }
                        }
                        if (cls == LinkedHashSet.class) {
                            this.type = 26;
                            try {
                                this.loadFactorFieldOff = GridUnsafe.objectFieldOffset((Field)HashMap.class.getDeclaredField("loadFactor"));
                            }
                            catch (NoSuchFieldException e) {
                                throw new IOException(e);
                            }
                        }
                        if (cls == Date.class) {
                            this.type = 27;
                        } else if (cls == Class.class) {
                            this.type = 28;
                            this.isCls = true;
                        } else if (Proxy.class.isAssignableFrom(cls)) {
                            this.type = 29;
                            this.proxyIntfs = cls.getInterfaces();
                        } else {
                            Class<?> c;
                            for (c = cls; !(this.writeReplaceMtd != null && this.readResolveMtd != null || c == null || c.equals(Object.class)); c = c.getSuperclass()) {
                                if (this.writeReplaceMtd == null) {
                                    try {
                                        this.writeReplaceMtd = c.getDeclaredMethod("writeReplace", new Class[0]);
                                        if (!(Modifier.isStatic(this.writeReplaceMtd.getModifiers()) || Modifier.isPrivate(this.writeReplaceMtd.getModifiers()) && c != cls || !this.writeReplaceMtd.getReturnType().equals(Object.class))) {
                                            this.writeReplaceMtd.setAccessible(true);
                                        } else {
                                            this.writeReplaceMtd = null;
                                        }
                                    }
                                    catch (NoSuchMethodException noSuchMethodException) {
                                        // empty catch block
                                    }
                                }
                                if (this.readResolveMtd != null) continue;
                                try {
                                    this.readResolveMtd = c.getDeclaredMethod("readResolve", new Class[0]);
                                    if (!(Modifier.isStatic(this.readResolveMtd.getModifiers()) || Modifier.isPrivate(this.readResolveMtd.getModifiers()) && c != cls || !this.readResolveMtd.getReturnType().equals(Object.class))) {
                                        this.readResolveMtd.setAccessible(true);
                                        continue;
                                    }
                                    this.readResolveMtd = null;
                                    continue;
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    // empty catch block
                                }
                            }
                            if (Externalizable.class.isAssignableFrom(cls)) {
                                this.type = 101;
                                try {
                                    this.constructor = !Modifier.isStatic(cls.getModifiers()) && cls.getDeclaringClass() != null ? cls.getDeclaredConstructor(cls.getDeclaringClass()) : cls.getDeclaredConstructor(new Class[0]);
                                    this.constructor.setAccessible(true);
                                }
                                catch (NoSuchMethodException e) {
                                    throw new IOException("Externalizable class doesn't have default constructor: " + String.valueOf(cls), e);
                                }
                            }
                            this.type = 102;
                            this.isSerial = Serializable.class.isAssignableFrom(cls);
                            this.writeObjMtds = new ArrayList<Method>();
                            this.readObjMtds = new ArrayList<Method>();
                            ArrayList<ClassFields> fields = new ArrayList<ClassFields>();
                            if (OptimizedMarshallerUtils.isLambda(cls)) {
                                if (!this.isSerial) {
                                    throw new NotSerializableException("Lambda is not serializable: " + String.valueOf(cls));
                                }
                            } else {
                                for (c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
                                    int mod;
                                    Method mtd;
                                    try {
                                        mtd = c.getDeclaredMethod("writeObject", ObjectOutputStream.class);
                                        mod = mtd.getModifiers();
                                        if (!Modifier.isStatic(mod) && Modifier.isPrivate(mod) && mtd.getReturnType() == Void.TYPE) {
                                            mtd.setAccessible(true);
                                        } else {
                                            mtd = null;
                                        }
                                    }
                                    catch (NoSuchMethodException ignored) {
                                        mtd = null;
                                    }
                                    this.writeObjMtds.add(mtd);
                                    try {
                                        mtd = c.getDeclaredMethod("readObject", ObjectInputStream.class);
                                        mod = mtd.getModifiers();
                                        if (!Modifier.isStatic(mod) && Modifier.isPrivate(mod) && mtd.getReturnType() == Void.TYPE) {
                                            mtd.setAccessible(true);
                                        } else {
                                            mtd = null;
                                        }
                                    }
                                    catch (NoSuchMethodException ignored) {
                                        mtd = null;
                                    }
                                    this.readObjMtds.add(mtd);
                                    Field[] clsFields0 = c.getDeclaredFields();
                                    HashMap<String, Field> fieldNames = new HashMap<String, Field>();
                                    for (Field f : clsFields0) {
                                        fieldNames.put(f.getName(), f);
                                    }
                                    ArrayList<FieldInfo> clsFields = new ArrayList<FieldInfo>(clsFields0.length);
                                    boolean hasSerialPersistentFields = false;
                                    try {
                                        Field serFieldsDesc = c.getDeclaredField("serialPersistentFields");
                                        int mod2 = serFieldsDesc.getModifiers();
                                        if (serFieldsDesc.getType() == ObjectStreamField[].class && Modifier.isPrivate(mod2) && Modifier.isStatic(mod2) && Modifier.isFinal(mod2)) {
                                            hasSerialPersistentFields = true;
                                            serFieldsDesc.setAccessible(true);
                                            ObjectStreamField[] serFields = (ObjectStreamField[])serFieldsDesc.get(null);
                                            for (int i = 0; i < serFields.length; ++i) {
                                                FieldInfo fieldInfo;
                                                ObjectStreamField serField = serFields[i];
                                                if (!fieldNames.containsKey(serField.getName())) {
                                                    fieldInfo = new FieldInfo(null, serField.getName(), -1L, OptimizedMarshallerUtils.fieldType(serField.getType()));
                                                } else {
                                                    Field f = (Field)fieldNames.get(serField.getName());
                                                    fieldInfo = new FieldInfo(f, serField.getName(), GridUnsafe.objectFieldOffset((Field)f), OptimizedMarshallerUtils.fieldType(serField.getType()));
                                                }
                                                clsFields.add(fieldInfo);
                                            }
                                        }
                                    }
                                    catch (NoSuchFieldException serFieldsDesc) {
                                    }
                                    catch (IllegalAccessException e) {
                                        throw new IOException("Failed to get value of 'serialPersistentFields' field in class: " + cls.getName(), e);
                                    }
                                    if (!hasSerialPersistentFields) {
                                        for (int i = 0; i < clsFields0.length; ++i) {
                                            Field f = clsFields0[i];
                                            int mod3 = f.getModifiers();
                                            if (Modifier.isStatic(mod3) || Modifier.isTransient(mod3)) continue;
                                            FieldInfo fieldInfo = new FieldInfo(f, f.getName(), GridUnsafe.objectFieldOffset((Field)f), OptimizedMarshallerUtils.fieldType(f.getType()));
                                            clsFields.add(fieldInfo);
                                        }
                                    }
                                    clsFields.sort(Comparator.comparing(FieldInfo::name));
                                    fields.add(new ClassFields(clsFields));
                                }
                            }
                            Collections.reverse(this.writeObjMtds);
                            Collections.reverse(this.readObjMtds);
                            Collections.reverse(fields);
                            this.fields = new Fields(fields);
                        }
                    }
                }
            }
        }
        this.checksum = OptimizedMarshallerUtils.computeSerialVersionUid(cls, this.fields != null ? this.fields.ownFields() : List.of());
    }

    Class<?> describedClass() {
        return this.cls;
    }

    boolean isPrimitive() {
        return this.isPrimitive;
    }

    boolean isEnum() {
        return this.isEnum;
    }

    boolean isClass() {
        return this.isCls;
    }

    boolean isProxy() {
        return this.type == 29;
    }

    Object replace(Object obj) throws IOException {
        if (this.writeReplaceMtd != null) {
            try {
                return this.writeReplaceMtd.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }
        return obj;
    }

    @Nullable
    Object read(OptimizedObjectInputStream in) throws ClassNotFoundException, IOException {
        switch (this.type) {
            case 101: {
                this.verifyChecksum(in.readShort());
                return in.readExternalizable(this.constructor, this.readResolveMtd);
            }
            case 102: {
                this.verifyChecksum(in.readShort());
                return in.readSerializable(this.cls, this.readObjMtds, this.readResolveMtd, this.fields);
            }
        }
        assert (false) : "Unexpected type: " + this.type;
        return null;
    }

    private void verifyChecksum(short checksum) throws ClassNotFoundException {
        if (checksum != this.checksum) {
            throw new ClassNotFoundException("Optimized stream class checksum mismatch (is same version of marshalled class present on all nodes?) [expected=" + this.checksum + ", actual=" + checksum + ", cls=" + String.valueOf(this.cls) + "]");
        }
    }

    public String getName() {
        return this.name;
    }

    static class FieldInfo {
        private final Field field;
        private final long fieldOffs;
        private final OptimizedFieldType fieldType;
        private final String fieldName;

        FieldInfo(@Nullable Field field, String name, long offset, OptimizedFieldType type) {
            this.field = field;
            this.fieldOffs = offset;
            this.fieldType = type;
            this.fieldName = name;
        }

        Field field() {
            return this.field;
        }

        long offset() {
            return this.fieldOffs;
        }

        OptimizedFieldType type() {
            return this.fieldType;
        }

        String name() {
            return this.fieldName;
        }
    }

    static class ClassFields {
        private final List<FieldInfo> fields;
        private final Object2IntMap<String> nameToIndex;

        ClassFields(List<FieldInfo> fields) {
            this.fields = fields;
            this.nameToIndex = new Object2IntOpenHashMap(fields.size());
            for (int i = 0; i < fields.size(); ++i) {
                this.nameToIndex.put((Object)fields.get(i).name(), i);
            }
        }

        List<FieldInfo> fields() {
            return this.fields;
        }

        int size() {
            return this.fields.size();
        }

        FieldInfo get(int i) {
            return this.fields.get(i);
        }

        int getIndex(String name) {
            assert (this.nameToIndex.containsKey((Object)name));
            return this.nameToIndex.getInt((Object)name);
        }
    }

    static class Fields {
        private final List<ClassFields> fields;
        private final List<Field> ownFields;

        Fields(List<ClassFields> fields) {
            this.fields = fields;
            if (fields.isEmpty()) {
                this.ownFields = List.of();
            } else {
                this.ownFields = new ArrayList<Field>(fields.size());
                for (FieldInfo f : fields.get(fields.size() - 1).fields()) {
                    if (f.field() == null) continue;
                    this.ownFields.add(f.field);
                }
            }
        }

        List<Field> ownFields() {
            return this.ownFields;
        }

        ClassFields fields(int i) {
            return this.fields.get(i);
        }
    }
}

