/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.optimized;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.BitSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.tostring.IgniteToStringBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.util.FastTimestamps;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.VarIntUtils;
import org.apache.ignite.internal.util.io.IgniteDataInput;

public class GridUnsafeDataInput
extends InputStream
implements IgniteDataInput {
    private static final int MAX_BLOCK_SIZE = 1024;
    private static final int CHAR_BUF_SIZE = 256;
    private static final long NO_AUTO_SHRINK = -1L;
    private final long shrinkCheckFrequencyMs;
    @IgniteToStringExclude
    private final byte[] utfBuf = new byte[1024];
    @IgniteToStringExclude
    private final char[] utfCharBuf = new char[256];
    private int pos;
    private int end = -1;
    @IgniteToStringExclude
    private byte[] buf;
    private int off;
    private int max;
    @IgniteToStringExclude
    private InputStream in;
    @IgniteToStringExclude
    private byte[] inBuf = new byte[1024];
    private int maxOff;
    private int mark;
    private long lastAutoShrinkCheckTimestamp;

    public GridUnsafeDataInput() {
        this(-1L);
    }

    public GridUnsafeDataInput(long shrinkCheckFrequencyMs) {
        this.shrinkCheckFrequencyMs = shrinkCheckFrequencyMs;
    }

    public GridUnsafeDataInput(byte[] bytes) {
        this(bytes, -1L);
    }

    public GridUnsafeDataInput(byte[] bytes, long shrinkCheckFrequencyMs) {
        this(shrinkCheckFrequencyMs);
        this.bytes(bytes, bytes.length);
    }

    public void bytes(byte[] bytes, int len) {
        this.bytes(bytes, 0, len);
    }

    public void bytes(byte[] bytes, int off, int len) {
        this.buf = bytes;
        this.max = len;
        this.off = off;
    }

    public void inputStream(InputStream in) throws IOException {
        this.in = in;
        this.buf = this.inBuf;
    }

    private void fromStream(int size) throws IOException {
        long now;
        if (this.in == null) {
            return;
        }
        this.maxOff = Math.max(this.maxOff, size);
        if (size > this.inBuf.length) {
            this.inBuf = new byte[Math.max(this.inBuf.length << 1, size)];
            this.buf = this.inBuf;
        } else if (this.isAutoShrinkEnabled() && (now = FastTimestamps.coarseCurrentTimeMillis()) - this.lastAutoShrinkCheckTimestamp > this.shrinkCheckFrequencyMs) {
            int halfSize = this.inBuf.length >> 1;
            if (this.maxOff < halfSize) {
                byte[] newInBuf = new byte[halfSize];
                System.arraycopy(this.inBuf, 0, newInBuf, 0, this.off);
                this.inBuf = newInBuf;
                this.buf = newInBuf;
            }
            this.maxOff = 0;
            this.lastAutoShrinkCheckTimestamp = now;
        }
        this.off = 0;
        this.max = 0;
        while (this.max != size) {
            int read = this.in.read(this.inBuf, this.max, size - this.max);
            if (read == -1) {
                throw new EOFException("End of stream reached: " + String.valueOf(this.in));
            }
            this.max += read;
        }
    }

    private boolean isAutoShrinkEnabled() {
        return this.shrinkCheckFrequencyMs != -1L;
    }

    private int advanceOffset(int more) throws IOException {
        int old = this.off;
        this.off += more;
        if (this.off > this.max) {
            throw new EOFException("Attempt to read beyond the end of the stream [pos=" + this.off + ", more=" + more + ", max=" + this.max + "]");
        }
        return old;
    }

    @Override
    public void reset() throws IOException {
        if (this.in != null) {
            this.in.reset();
        } else {
            this.off = this.mark;
        }
    }

    public void cleanup() throws IOException {
        this.in = null;
        this.off = 0;
        this.max = 0;
        this.mark = 0;
    }

    public byte[] readByteArray(int arrSize) throws IOException {
        this.fromStream(arrSize);
        byte[] arr = new byte[arrSize];
        System.arraycopy(this.buf, this.advanceOffset(arrSize), arr, 0, arrSize);
        return arr;
    }

    public short[] readShortArray(int arrSize) throws IOException {
        int bytesToCp = arrSize << 1;
        this.fromStream(bytesToCp);
        short[] arr = new short[arrSize];
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.advanceOffset(bytesToCp);
        if (GridUnsafe.IS_BIG_ENDIAN) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = GridUnsafe.getShortLittleEndian((byte[])this.buf, (long)off);
                off += 2L;
            }
        } else {
            GridUnsafe.copyMemory((Object)this.buf, (long)off, (Object)arr, (long)GridUnsafe.SHORT_ARR_OFF, (long)bytesToCp);
        }
        return arr;
    }

    public int[] readIntArray(int arrSize) throws IOException {
        int bytesToCp = arrSize << 2;
        this.fromStream(bytesToCp);
        int[] arr = new int[arrSize];
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.advanceOffset(bytesToCp);
        if (GridUnsafe.IS_BIG_ENDIAN) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = GridUnsafe.getIntLittleEndian((byte[])this.buf, (long)off);
                off += 4L;
            }
        } else {
            GridUnsafe.copyMemory((Object)this.buf, (long)off, (Object)arr, (long)GridUnsafe.INT_ARR_OFF, (long)bytesToCp);
        }
        return arr;
    }

    public double[] readDoubleArray(int arrSize) throws IOException {
        int bytesToCp = arrSize << 3;
        this.fromStream(bytesToCp);
        double[] arr = new double[arrSize];
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.advanceOffset(bytesToCp);
        if (GridUnsafe.IS_BIG_ENDIAN) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = GridUnsafe.getDoubleLittleEndian((byte[])this.buf, (long)off);
                off += 8L;
            }
        } else {
            GridUnsafe.copyMemory((Object)this.buf, (long)off, (Object)arr, (long)GridUnsafe.DOUBLE_ARR_OFF, (long)bytesToCp);
        }
        return arr;
    }

    public boolean[] readBooleanArray(int arrSize) throws IOException {
        boolean[] vals = new boolean[arrSize];
        for (int i = 0; i < arrSize; ++i) {
            vals[i] = this.readBoolean();
        }
        return vals;
    }

    public char[] readCharArray(int arrSize) throws IOException {
        int bytesToCp = arrSize << 1;
        this.fromStream(bytesToCp);
        char[] arr = new char[arrSize];
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.advanceOffset(bytesToCp);
        if (GridUnsafe.IS_BIG_ENDIAN) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = GridUnsafe.getCharLittleEndian((byte[])this.buf, (long)off);
                off += 2L;
            }
        } else {
            GridUnsafe.copyMemory((Object)this.buf, (long)off, (Object)arr, (long)GridUnsafe.CHAR_ARR_OFF, (long)bytesToCp);
        }
        return arr;
    }

    public BigInteger readBigInteger() throws IOException {
        int length = this.readInt();
        byte[] bytes = this.readByteArray(length);
        return new BigInteger(bytes);
    }

    public BigDecimal readBigDecimal() throws IOException {
        short scale = this.readShort();
        BigInteger bigInteger = this.readBigInteger();
        return new BigDecimal(bigInteger, scale);
    }

    public LocalTime readLocalTime() throws IOException {
        byte hour = this.readByte();
        byte minute = this.readByte();
        byte second = this.readByte();
        int nano = this.readInt();
        return LocalTime.of(hour, minute, second, nano);
    }

    public LocalDate readLocalDate() throws IOException {
        int year = this.readInt();
        short month = this.readShort();
        short day = this.readShort();
        return LocalDate.of(year, month, (int)day);
    }

    public LocalDateTime readLocalDateTime() throws IOException {
        int year = this.readInt();
        short month = this.readShort();
        short day = this.readShort();
        byte hour = this.readByte();
        byte minute = this.readByte();
        byte second = this.readByte();
        int nano = this.readInt();
        return LocalDateTime.of(year, month, (int)day, (int)hour, (int)minute, (int)second, nano);
    }

    public Instant readInstant() throws IOException {
        long epochSecond = this.readLong();
        int nano = this.readInt();
        return Instant.ofEpochSecond(epochSecond, nano);
    }

    public Duration readDuration() throws IOException {
        long seconds = this.readLong();
        int nano = this.readInt();
        return Duration.ofSeconds(seconds, nano);
    }

    public Period readPeriod() throws IOException {
        int years = this.readInt();
        int months = this.readInt();
        int days = this.readInt();
        return Period.of(years, months, days);
    }

    public UUID readUuid() throws IOException {
        byte length = this.readByte();
        byte[] bytes = this.readByteArray(length);
        return UUID.fromString(new String(bytes, StandardCharsets.UTF_8));
    }

    public BitSet readBitSet() throws IOException {
        int length = this.readInt();
        byte[] bytes = this.readByteArray(length);
        return BitSet.valueOf(bytes);
    }

    public long[] readLongArray(int arrSize) throws IOException {
        int bytesToCp = arrSize << 3;
        this.fromStream(bytesToCp);
        long[] arr = new long[arrSize];
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.advanceOffset(bytesToCp);
        if (GridUnsafe.IS_BIG_ENDIAN) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = GridUnsafe.getLongLittleEndian((byte[])this.buf, (long)off);
                off += 8L;
            }
        } else {
            GridUnsafe.copyMemory((Object)this.buf, (long)off, (Object)arr, (long)GridUnsafe.LONG_ARR_OFF, (long)bytesToCp);
        }
        return arr;
    }

    public float[] readFloatArray(int arrSize) throws IOException {
        int bytesToCp = arrSize << 2;
        this.fromStream(bytesToCp);
        float[] arr = new float[arrSize];
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.advanceOffset(bytesToCp);
        if (GridUnsafe.IS_BIG_ENDIAN) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = GridUnsafe.getFloatLittleEndian((byte[])this.buf, (long)off);
                off += 4L;
            }
        } else {
            GridUnsafe.copyMemory((Object)this.buf, (long)off, (Object)arr, (long)GridUnsafe.FLOAT_ARR_OFF, (long)bytesToCp);
        }
        return arr;
    }

    public int readFewBytes(byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        Objects.checkFromIndexSize(off, len, b.length);
        for (n = 0; n < len && (count = this.read(b, off + n, len - n)) >= 0; n += count) {
        }
        return n;
    }

    public void readFully(byte[] b) throws IOException {
        int len = b.length;
        this.fromStream(len);
        System.arraycopy(this.buf, this.advanceOffset(len), b, 0, len);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.fromStream(len);
        System.arraycopy(this.buf, this.advanceOffset(len), b, off, len);
    }

    public int skipBytes(int n) {
        if (this.off + n > this.max) {
            n = this.max - this.off;
        }
        this.off += n;
        return n;
    }

    public boolean readBoolean() throws IOException {
        this.fromStream(1);
        return GridUnsafe.getBoolean((byte[])this.buf, (long)(GridUnsafe.BYTE_ARR_OFF + (long)this.advanceOffset(1)));
    }

    public byte readByte() throws IOException {
        this.fromStream(1);
        return GridUnsafe.getByte((byte[])this.buf, (long)(GridUnsafe.BYTE_ARR_OFF + (long)this.advanceOffset(1)));
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public short readShort() throws IOException {
        this.fromStream(2);
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.advanceOffset(2);
        return GridUnsafe.IS_BIG_ENDIAN ? GridUnsafe.getShortLittleEndian((byte[])this.buf, (long)off) : GridUnsafe.getShort((byte[])this.buf, (long)off);
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public char readChar() throws IOException {
        this.fromStream(2);
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
        char v = GridUnsafe.IS_BIG_ENDIAN ? GridUnsafe.getCharLittleEndian((byte[])this.buf, (long)off) : GridUnsafe.getChar((byte[])this.buf, (long)off);
        this.advanceOffset(2);
        return v;
    }

    public int readInt() throws IOException {
        this.fromStream(4);
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.advanceOffset(4);
        return GridUnsafe.IS_BIG_ENDIAN ? GridUnsafe.getIntLittleEndian((byte[])this.buf, (long)off) : GridUnsafe.getInt((byte[])this.buf, (long)off);
    }

    public long readLong() throws IOException {
        this.fromStream(8);
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.advanceOffset(8);
        return GridUnsafe.IS_BIG_ENDIAN ? GridUnsafe.getLongLittleEndian((byte[])this.buf, (long)off) : GridUnsafe.getLong((byte[])this.buf, (long)off);
    }

    public float readFloat() throws IOException {
        int v = this.readInt();
        return Float.intBitsToFloat(v);
    }

    public double readDouble() throws IOException {
        long v = this.readLong();
        return Double.longBitsToDouble(v);
    }

    @Override
    public int read() throws IOException {
        try {
            return this.readUnsignedByte();
        }
        catch (EOFException ignored) {
            return -1;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.in != null) {
            return this.in.read(b, off, len);
        }
        int toRead = Math.min(len, this.max - this.off);
        if (toRead <= 0) {
            return -1;
        }
        System.arraycopy(this.buf, this.advanceOffset(toRead), b, off, toRead);
        return toRead;
    }

    public long readVarInt() throws IOException {
        return VarIntUtils.readVarInt((DataInput)((Object)this));
    }

    public String readLine() throws IOException {
        int b;
        StringBuilder sb = new StringBuilder();
        block4: while ((b = this.read()) >= 0) {
            char c = (char)b;
            switch (c) {
                case '\n': {
                    return sb.toString();
                }
                case '\r': {
                    b = this.read();
                    if (b < 0 || b == 10) {
                        return sb.toString();
                    }
                    sb.append((char)b);
                    continue block4;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String readUTF() throws IOException {
        return this.readUtfBody(this.readInt());
    }

    protected String readUtfBody(long utfLen) throws IOException {
        StringBuilder sbuf = new StringBuilder();
        this.pos = 0;
        this.end = 0;
        while (utfLen > 0L) {
            int avail = this.end - this.pos;
            if (avail >= 3 || (long)avail == utfLen) {
                utfLen -= this.readUtfSpan(sbuf, utfLen);
                continue;
            }
            if (avail > 0) {
                System.arraycopy(this.utfBuf, this.pos, this.utfBuf, 0, avail);
            }
            this.pos = 0;
            this.end = (int)Math.min(1024L, utfLen);
            this.readFully(this.utfBuf, avail, this.end - avail);
        }
        return sbuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long readUtfSpan(StringBuilder sbuf, long utfLen) throws IOException {
        int start;
        int cpos;
        block13: {
            cpos = 0;
            start = this.pos;
            int avail = Math.min(this.end - this.pos, 256);
            int stop = this.pos + (utfLen > (long)avail ? avail - 2 : (int)utfLen);
            boolean outOfBounds = false;
            try {
                block10: while (this.pos < stop) {
                    int b1 = this.utfBuf[this.pos++] & 0xFF;
                    switch (b1 >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            this.utfCharBuf[cpos++] = (char)b1;
                            continue block10;
                        }
                        case 12: 
                        case 13: {
                            byte b2 = this.utfBuf[this.pos++];
                            if ((b2 & 0xC0) != 128) {
                                throw new UTFDataFormatException();
                            }
                            this.utfCharBuf[cpos++] = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
                            continue block10;
                        }
                        case 14: {
                            byte b3 = this.utfBuf[this.pos + 1];
                            byte b2 = this.utfBuf[this.pos];
                            this.pos += 2;
                            if ((b2 & 0xC0) != 128) throw new UTFDataFormatException();
                            if ((b3 & 0xC0) != 128) {
                                throw new UTFDataFormatException();
                            }
                            this.utfCharBuf[cpos++] = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                            continue block10;
                        }
                    }
                    throw new UTFDataFormatException();
                }
            }
            catch (ArrayIndexOutOfBoundsException ignored) {
                outOfBounds = true;
                return (long)outOfBounds;
            }
            finally {
                if (!outOfBounds && (long)(this.pos - start) <= utfLen) break block13;
                this.pos = start + (int)utfLen;
                throw new UTFDataFormatException();
            }
        }
        sbuf.append(this.utfCharBuf, 0, cpos);
        return this.pos - start;
    }

    @Override
    public void mark(int readLimit) {
        if (this.in != null) {
            this.in.mark(readLimit);
        } else {
            this.mark = this.off;
        }
    }

    @Override
    public boolean markSupported() {
        return this.in == null || this.in.markSupported();
    }

    @Override
    public int available() throws IOException {
        if (this.in != null) {
            return this.in.available();
        }
        return Math.max(this.buf.length - this.off, 0);
    }

    public <T> T materializeFromNextBytes(int bytesCount, IgniteDataInput.Materializer<? extends T> materializer) throws IOException {
        this.fromStream(bytesCount);
        int prevOffset = this.advanceOffset(bytesCount);
        return (T)materializer.materialize(this.buf, prevOffset, bytesCount);
    }

    public String toString() {
        return IgniteToStringBuilder.toString(GridUnsafeDataInput.class, (Object)this);
    }
}

