/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.metrics;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.gridgain.dr.configuration.DrReceiverServerView;
import org.gridgain.internal.dr.metrics.DrBatchEventListener;
import org.gridgain.internal.dr.metrics.DrReceiverMxBean;

public class DrReceiverMxBeanImpl
implements DrReceiverMxBean,
DrBatchEventListener {
    private final AtomicInteger totalBatchesReceived = new AtomicInteger();
    private final AtomicLong totalEntriesReceived = new AtomicLong();
    private final AtomicLong totalBytesReceived = new AtomicLong();
    private final AtomicLong totalMessageQueueSizeBytes = new AtomicLong();
    private final AtomicInteger totalMessageQueueLength = new AtomicInteger();
    private final DrReceiverServerView cfg;

    DrReceiverMxBeanImpl(DrReceiverServerView cfg) {
        this.cfg = cfg;
    }

    @Override
    public int getTotalBatchesReceived() {
        return this.totalBatchesReceived.get();
    }

    @Override
    public long getTotalEntriesReceived() {
        return this.totalEntriesReceived.get();
    }

    @Override
    public long getTotalBytesReceived() {
        return this.totalBytesReceived.get();
    }

    @Override
    public long getTotalMessageQueueLength() {
        return this.totalMessageQueueLength.get();
    }

    @Override
    public long getTotalMessageQueueSizeBytes() {
        return this.totalMessageQueueSizeBytes.get();
    }

    @Override
    public String getLocalInboundHost() {
        return this.cfg.inboundHost();
    }

    @Override
    public int getLocalInboundPort() {
        return this.cfg.inboundPort();
    }

    @Override
    public int getSelectorCount() {
        return this.cfg.selectorCnt();
    }

    @Override
    public int getWorkerThreads() {
        return this.cfg.workerThreads();
    }

    @Override
    public long getWriteTimeout() {
        return this.cfg.writeTimeout();
    }

    @Override
    public int getSocketSendBufferSize() {
        return this.cfg.socketSendBufferSize();
    }

    @Override
    public int getSocketReceiveBufferSize() {
        return this.cfg.socketReceiveBufferSize();
    }

    @Override
    public boolean isTcpNodelay() {
        return this.cfg.tcpNodelay();
    }

    @Override
    public int getIdleTimeout() {
        return this.cfg.idleTimeout();
    }

    @Override
    public long getTombstoneTtl() {
        return this.cfg.tombstoneTtl();
    }

    @Override
    public void onReceived(int entriesCnt, int bytesCnt) {
        this.totalBatchesReceived.incrementAndGet();
        this.totalEntriesReceived.addAndGet(entriesCnt);
        this.totalBytesReceived.addAndGet(bytesCnt);
        this.totalMessageQueueLength.incrementAndGet();
        this.totalMessageQueueSizeBytes.addAndGet(bytesCnt);
    }

    @Override
    public void onProcessed(long messageSize) {
        this.totalMessageQueueLength.decrementAndGet();
        this.totalMessageQueueSizeBytes.addAndGet(-messageSize);
    }
}

