/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.metrics;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.internal.dr.metrics.MxBeanDescription;
import org.jetbrains.annotations.Nullable;

public class AnnotationAwareStandardMxBean
extends StandardMBean {
    private static final Map<String, Class<?>> primCls = new HashMap();

    <T> AnnotationAwareStandardMxBean(T implementation, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(implementation, mbeanInterface);
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String str = super.getDescription(info);
        String methodName = (info.isIs() ? "is" : "get") + info.getName();
        try {
            MxBeanDescription desc;
            Method mtd = AnnotationAwareStandardMxBean.findMethod(this.getMBeanInterface(), methodName, new Class[0]);
            if (mtd != null && (desc = mtd.getAnnotation(MxBeanDescription.class)) != null) {
                str = desc.value();
                if (IgniteUtils.assertionsEnabled()) {
                    AnnotationAwareStandardMxBean.validateDescription(str, mtd.getName());
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return str;
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        String str = super.getDescription(info);
        MxBeanDescription desc = this.getMBeanInterface().getAnnotation(MxBeanDescription.class);
        if (desc != null) {
            str = desc.value();
            if (IgniteUtils.assertionsEnabled()) {
                AnnotationAwareStandardMxBean.validateDescription(str, this.getMBeanInterface().getSimpleName());
            }
        }
        return str;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String str = super.getDescription(info);
        try {
            MxBeanDescription desc;
            Method mtd = this.getMethod(info);
            if (mtd != null && (desc = mtd.getAnnotation(MxBeanDescription.class)) != null) {
                str = desc.value();
                if (IgniteUtils.assertionsEnabled()) {
                    AnnotationAwareStandardMxBean.validateDescription(str, mtd.getName());
                }
            }
        }
        catch (ClassNotFoundException | SecurityException exception) {
            // empty catch block
        }
        return str;
    }

    @Nullable
    private Method getMethod(MBeanOperationInfo op) throws ClassNotFoundException, SecurityException {
        String mtdName = op.getName();
        MBeanParameterInfo[] signature = op.getSignature();
        Class[] params = new Class[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            Class<?> type = primCls.get(signature[i].getType().toLowerCase());
            if (type == null) {
                type = Class.forName(signature[i].getType());
            }
            params[i] = type;
        }
        return AnnotationAwareStandardMxBean.findMethod(this.getMBeanInterface(), mtdName, params);
    }

    @Nullable
    private static Method findMethod(Class<?> itf, String methodName, Class<?>[] params) {
        assert (itf.isInterface()) : String.valueOf(itf) + " must represent the interface";
        Method res = null;
        try {
            return itf.getDeclaredMethod(methodName, params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class<?>[] superItfs;
            for (Class<?> superItf : superItfs = itf.getInterfaces()) {
                res = AnnotationAwareStandardMxBean.findMethod(superItf, methodName, params);
            }
            return res;
        }
    }

    private static void validateDescription(String str, String name) {
        assert (str != null) : name;
        assert (!str.isBlank());
        assert (Character.isUpperCase(str.charAt(0))) : "Description must start with upper case: " + str;
        assert (str.charAt(str.length() - 1) == '.') : "Description must end with period: " + str;
    }

    static {
        primCls.put(Boolean.TYPE.toString().toLowerCase(), Boolean.TYPE);
        primCls.put(Character.TYPE.toString().toLowerCase(), Character.TYPE);
        primCls.put(Byte.TYPE.toString().toLowerCase(), Byte.TYPE);
        primCls.put(Short.TYPE.toString().toLowerCase(), Short.TYPE);
        primCls.put(Integer.TYPE.toString().toLowerCase(), Integer.TYPE);
        primCls.put(Long.TYPE.toString().toLowerCase(), Long.TYPE);
        primCls.put(Float.TYPE.toString().toLowerCase(), Float.TYPE);
        primCls.put(Double.TYPE.toString().toLowerCase(), Double.TYPE);
    }
}

