/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.privileges;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.ObjectTree;
import org.gridgain.internal.rbac.privileges.ObjectType;
import org.gridgain.internal.rbac.privileges.Selector;
import org.gridgain.internal.rbac.privileges.exception.IllegalPrivilegeException;

public class Privilege {
    private final Action action;
    private final Selector selector;

    private Privilege(Action action, Selector selector) {
        this.action = action;
        this.selector = selector;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(Privilege privilege) {
        return Privilege.builder().action(privilege.action).selector(privilege.selector);
    }

    public static Privilege fromAction(Action action) {
        return Privilege.builder().action(action).build();
    }

    public Action action() {
        return this.action;
    }

    public Selector selector() {
        return this.selector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Privilege privilege = (Privilege)o;
        return this.action == privilege.action && Objects.equals(this.selector, privilege.selector);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.selector});
    }

    public String toString() {
        return "Privilege{action=" + this.action + ", selector=" + this.selector + "}";
    }

    public String format() {
        String selectorRawString = this.selector.toRawString();
        return this.action.name() + (String)(selectorRawString == null ? "" : " on " + selectorRawString);
    }

    public static class Builder {
        private Action action;
        private Selector selector;
        private String rawSelector;

        public Builder action(Action type) {
            this.action = type;
            return this;
        }

        public Builder selector(Selector selector) {
            this.selector = selector;
            return this;
        }

        public Builder selector(String rawSelector) {
            this.rawSelector = rawSelector;
            return this;
        }

        public Privilege build() {
            this.validate();
            return new Privilege(this.action, this.selector);
        }

        private void validate() {
            if (this.action == null) {
                throw new IllegalPrivilegeException("Action is required");
            }
            if (this.rawSelector != null && this.selector != null) {
                throw new IllegalPrivilegeException("Cannot specify both raw selector and selector");
            }
            this.inferSelector();
            Set<ObjectType> ancestors = ObjectTree.findAncestors(this.action.applicableObjectType());
            if (this.action.applicableObjectType() == this.selector.objectType()) {
                return;
            }
            if (ancestors.contains((Object)this.selector.objectType())) {
                return;
            }
            if (this.action.allowSelfAction() && this.selector.objectType() == ObjectType.USER) {
                return;
            }
            throw new IllegalPrivilegeException(this.action, this.selector);
        }

        private void inferSelector() {
            if (this.selector == null && this.rawSelector == null) {
                this.selector = Selector.cluster();
            }
            if (this.rawSelector != null) {
                List<String> parsedName = IgniteNameUtils.parseName(this.rawSelector);
                if (parsedName.size() > 2) {
                    throw new IllegalPrivilegeException("Malformed object identifier for " + this.action.applicableObjectType() + " [object=" + this.rawSelector + "]");
                }
                String schemaName = parsedName.get(0);
                String tableName = parsedName.size() == 1 ? null : parsedName.get(1);
                switch (this.action.applicableObjectType()) {
                    case CLUSTER: {
                        throw new IllegalPrivilegeException("Cluster-wide action " + this.action.name() + " should not have a selector to object " + this.rawSelector);
                    }
                    case SCHEMA: {
                        if (tableName != null) {
                            throw new IllegalPrivilegeException("Malformed object identifier for SCHEMA [schema=" + schemaName + ", object=" + tableName + "]");
                        }
                        this.selector = Selector.schema(schemaName);
                        break;
                    }
                    case TABLE: {
                        if (tableName == null) {
                            this.selector = Selector.schema(schemaName);
                            break;
                        }
                        this.selector = Selector.table(schemaName, tableName);
                        break;
                    }
                    case VIEW: {
                        if (tableName == null) {
                            this.selector = Selector.schema(schemaName);
                            break;
                        }
                        this.selector = Selector.view(schemaName, tableName);
                        break;
                    }
                    case SEQUENCE: {
                        if (tableName == null) {
                            this.selector = Selector.schema(schemaName);
                            break;
                        }
                        this.selector = Selector.sequence(schemaName, tableName);
                        break;
                    }
                    case DEPLOYMENT_UNIT: {
                        this.selector = Selector.deploymentUnit(this.rawSelector);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + this.action.applicableObjectType());
                    }
                }
            }
        }
    }
}

