/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.nio;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.util.io.IgniteUnsafeDataOutput;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.gridgain.internal.dr.DrUtils;
import org.gridgain.internal.dr.binary.BinaryFieldMetadata;
import org.gridgain.internal.dr.binary.BinaryMetadata;
import org.gridgain.internal.dr.binary.BinarySchema;
import org.gridgain.internal.dr.binary.TypeMetadata;
import org.gridgain.internal.dr.binary.Versioned;
import org.gridgain.internal.dr.common.IgniteUuid;
import org.gridgain.internal.dr.messages.DrExternalBatchRequest;
import org.gridgain.internal.dr.messages.DrExternalBatchResponse;
import org.gridgain.internal.dr.messages.DrExternalHandshakeRequest;
import org.gridgain.internal.dr.messages.DrExternalHandshakeResponse;
import org.gridgain.internal.dr.messages.DrExternalMetadataRequest;
import org.gridgain.internal.dr.messages.DrExternalMetadataResponse;
import org.gridgain.internal.dr.messages.DrExternalPingRequest;
import org.gridgain.internal.dr.messages.DrExternalPingResponse;
import org.gridgain.internal.dr.nio.DrMessageMarshaller;
import org.jetbrains.annotations.Nullable;

public class DrNioMessageMarshaller
implements DrMessageMarshaller<ByteBuffer> {
    @Override
    public Object unmarshal(ByteBuffer in) {
        int length = in.remaining();
        byte msgType = in.get();
        switch (msgType) {
            case 0: {
                byte dcId = in.get();
                String protoVer = DrNioMessageMarshaller.readString(in);
                String marshClsName = DrNioMessageMarshaller.readString(in);
                boolean awaitAck = DrNioMessageMarshaller.readBoolean(in);
                long tombstoneTtl = in.remaining() == 0 ? 0L : in.getLong();
                return new DrExternalHandshakeRequest(dcId, protoVer, marshClsName, awaitAck, tombstoneTtl).size(length);
            }
            case 1: {
                String errMsg = DrNioMessageMarshaller.readString(in);
                return new DrExternalHandshakeResponse(errMsg).size(length);
            }
            case 2: {
                return DrExternalPingRequest.INSTANCE;
            }
            case 3: {
                return DrExternalPingResponse.INSTANCE;
            }
            case 4: {
                IgniteUuid reqId = DrNioMessageMarshaller.readGridUuid(in);
                String cacheName = DrNioMessageMarshaller.readString(in);
                int entries = in.getInt();
                int dataSize = in.getInt();
                byte dcId = in.get();
                byte[] data = DrNioMessageMarshaller.readBytes(in);
                return new DrExternalBatchRequest(reqId, cacheName, dcId, entries, data, dataSize).size(length);
            }
            case 5: {
                IgniteUuid uuid = DrNioMessageMarshaller.readGridUuid(in);
                String err = DrNioMessageMarshaller.readString(in);
                return new DrExternalBatchResponse(uuid, err).size(length);
            }
            case 6: {
                long ver = in.getLong();
                HashMap<String, Versioned<TypeMetadata>> meta = new HashMap<String, Versioned<TypeMetadata>>();
                while (DrNioMessageMarshaller.readBoolean(in)) {
                    String cls = DrNioMessageMarshaller.readUtf(in);
                    byte platformId = in.get();
                    int typeId = in.getInt();
                    meta.put(cls, new Versioned<TypeMetadata>(0L, new TypeMetadata(platformId, typeId)));
                }
                ArrayList<Versioned<BinaryMetadata>> binaryMeta = new ArrayList<Versioned<BinaryMetadata>>();
                while (DrNioMessageMarshaller.readBoolean(in)) {
                    BinaryMetadata binaryMetadataEntry = DrNioMessageMarshaller.readBinaryMetadata(in);
                    binaryMeta.add(new Versioned<BinaryMetadata>(0L, binaryMetadataEntry));
                }
                return new DrExternalMetadataRequest(ver, meta, binaryMeta).size(length);
            }
            case 7: {
                return new DrExternalMetadataResponse(in.getLong(), DrNioMessageMarshaller.readString(in)).size(length);
            }
        }
        throw new IllegalArgumentException("Unsupported message type: type=" + msgType);
    }

    @Override
    public ByteBuffer marshal(Object msg) {
        if (msg instanceof DrExternalPingRequest) {
            return ByteBuffer.wrap(DrUtils.PING_REQ_BYTES);
        }
        if (msg instanceof DrExternalPingResponse) {
            return ByteBuffer.wrap(DrUtils.PING_RESP_BYTES);
        }
        if (msg instanceof DrExternalBatchRequest) {
            return DrNioMessageMarshaller.marshal((DrExternalBatchRequest)msg);
        }
        if (msg instanceof DrExternalBatchResponse) {
            return DrNioMessageMarshaller.marshal((DrExternalBatchResponse)msg);
        }
        if (msg instanceof DrExternalMetadataRequest) {
            return DrNioMessageMarshaller.marshal((DrExternalMetadataRequest)msg);
        }
        if (msg instanceof DrExternalMetadataResponse) {
            return DrNioMessageMarshaller.marshal((DrExternalMetadataResponse)msg);
        }
        if (msg instanceof DrExternalHandshakeRequest) {
            return DrNioMessageMarshaller.marshal((DrExternalHandshakeRequest)msg);
        }
        if (msg instanceof DrExternalHandshakeResponse) {
            return DrNioMessageMarshaller.marshal((DrExternalHandshakeResponse)msg);
        }
        throw new IllegalArgumentException("Message type is not supported.");
    }

    private static ByteBuffer marshal(DrExternalHandshakeResponse resp) {
        int size = 6;
        String errMsg = resp.errorMessage();
        if (errMsg != null) {
            size += 4 + DrNioMessageMarshaller.utfLength(errMsg);
        }
        IgniteUnsafeDataOutput out = new IgniteUnsafeDataOutput(size);
        try {
            out.writeInt(0);
            out.writeByte(1);
            DrNioMessageMarshaller.writeString(out, resp.errorMessage());
            return DrNioMessageMarshaller.completeMessage(out.internalArray(), out.offset());
        }
        catch (IOException e) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Failed to marshal DR handshake response.", (Throwable)e);
        }
    }

    private static ByteBuffer marshal(DrExternalMetadataResponse resp) {
        int size = 14;
        String errMsg = resp.errorMessage();
        if (errMsg != null) {
            size += 4 + DrNioMessageMarshaller.utfLength(errMsg);
        }
        IgniteUnsafeDataOutput out = new IgniteUnsafeDataOutput(size);
        try {
            out.writeInt(0);
            out.writeByte(7);
            out.writeLong(resp.version());
            DrNioMessageMarshaller.writeString(out, resp.errorMessage());
            return DrNioMessageMarshaller.completeMessage(out.internalArray(), out.offset());
        }
        catch (IOException e) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Failed to marshal DR metadata response.", (Throwable)e);
        }
    }

    private static ByteBuffer marshal(DrExternalBatchResponse resp) {
        int size = 31;
        String errMsg = resp.errorMessage();
        if (errMsg != null) {
            size += 4 + DrNioMessageMarshaller.utfLength(errMsg);
        }
        IgniteUnsafeDataOutput out = new IgniteUnsafeDataOutput(size);
        try {
            out.writeInt(0);
            out.writeByte(5);
            DrNioMessageMarshaller.writeGridUuid(out, resp.requestId());
            DrNioMessageMarshaller.writeString(out, resp.errorMessage());
            return DrNioMessageMarshaller.completeMessage(out.internalArray(), out.offset());
        }
        catch (IOException e) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Failed to marshal DR batch response.", (Throwable)e);
        }
    }

    private static ByteBuffer marshal(DrExternalBatchRequest req) {
        assert (req.dataBytes() != null) : "DR batch request is not prepared: " + String.valueOf(req);
        assert (req.dataSize() == req.dataBytes().length);
        int size = 44 + req.dataSize();
        String cacheName = req.cacheName();
        if (cacheName != null) {
            size += 4 + DrNioMessageMarshaller.utfLength(cacheName);
        }
        IgniteUnsafeDataOutput out = new IgniteUnsafeDataOutput(size);
        try {
            out.writeInt(0);
            out.writeByte(4);
            DrNioMessageMarshaller.writeGridUuid(out, req.requestId());
            DrNioMessageMarshaller.writeString(out, cacheName);
            out.writeInt(req.entryCount());
            out.writeInt(req.dataSize());
            out.writeByte(req.dataCenterId());
            DrNioMessageMarshaller.writeByteArray(out, req.dataBytes(), req.dataSize());
            return DrNioMessageMarshaller.completeMessage(out.internalArray(), out.offset());
        }
        catch (IOException e) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Failed to marshal DR batch request.", (Throwable)e);
        }
    }

    private static ByteBuffer marshal(DrExternalHandshakeRequest req) {
        int size = 25 + req.protocolVersion().length() + req.marshallerClassName().length();
        IgniteUnsafeDataOutput out = new IgniteUnsafeDataOutput(size);
        try {
            out.writeInt(0);
            out.writeByte(0);
            out.writeByte(req.dataCenterId());
            DrNioMessageMarshaller.writeString(out, req.protocolVersion());
            DrNioMessageMarshaller.writeString(out, req.marshallerClassName());
            out.writeBoolean(req.awaitAcknowledge());
            out.writeLong(req.getTombstoneTtl());
            return DrNioMessageMarshaller.completeMessage(out.internalArray(), out.offset());
        }
        catch (IOException e) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Failed to marshal DR handshake request.", (Throwable)e);
        }
    }

    public static ByteBuffer marshal(DrExternalMetadataRequest req) {
        IgniteUnsafeDataOutput out = new IgniteUnsafeDataOutput(1024);
        try {
            out.writeInt(0);
            out.writeByte(6);
            out.writeLong(req.version());
            for (Map.Entry<String, Versioned<TypeMetadata>> entry : req.metadata().entrySet()) {
                out.writeBoolean(true);
                DrNioMessageMarshaller.writeUtf(out, entry.getKey());
                TypeMetadata tup = entry.getValue().value();
                out.writeByte(tup.platformId());
                out.writeInt(tup.typeId());
            }
            out.writeBoolean(false);
            for (Versioned versioned : req.binaryMetadata()) {
                out.writeBoolean(true);
                DrNioMessageMarshaller.writeBinaryMetadata(out, (BinaryMetadata)versioned.value());
            }
            out.writeBoolean(false);
            return DrNioMessageMarshaller.completeMessage(out.internalArray(), out.offset());
        }
        catch (IOException e) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Failed to marshal DR metadata request.", (Throwable)e);
        }
    }

    public static int utfLength(String str) {
        int len = str.length();
        int utfLen = 0;
        for (int pos = 0; pos < len; ++pos) {
            char c = str.charAt(pos);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utfLen;
                continue;
            }
            utfLen += c > '\u07ff' ? 3 : 2;
        }
        return utfLen;
    }

    private static boolean readBoolean(ByteBuffer in) {
        return in.get() != 0;
    }

    @Nullable
    private static String readString(ByteBuffer in) {
        if (DrNioMessageMarshaller.readBoolean(in)) {
            return null;
        }
        assert (in.remaining() >= 4);
        return DrNioMessageMarshaller.readUtf(in);
    }

    @Nullable
    private static String readUtf(ByteBuffer in) {
        int length = in.getInt();
        int remaining = in.remaining();
        if (remaining < length) {
            throw new IllegalStateException(IgniteStringFormatter.format("Failed to read string: expectedLength={}, availableLength={}", length, in.remaining()));
        }
        CharBuffer charBuf = CharBuffer.allocate(length);
        try {
            int off;
            int pos = off = in.position();
            block7: while (pos < off + length) {
                int b1 = in.get() & 0xFF;
                ++pos;
                switch (b1 >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        charBuf.append((char)b1);
                        continue block7;
                    }
                    case 12: 
                    case 13: {
                        byte b2 = in.get();
                        ++pos;
                        if ((b2 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        charBuf.append((char)((b1 & 0x1F) << 6 | b2 & 0x3F));
                        continue block7;
                    }
                    case 14: {
                        byte b2 = in.get();
                        byte b3 = in.get();
                        pos += 2;
                        if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        charBuf.append((char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F));
                        continue block7;
                    }
                }
                throw new UTFDataFormatException();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to unmarshal string.", ex);
        }
        return charBuf.flip().toString();
    }

    private static void writeString(IgniteUnsafeDataOutput out, @Nullable String str) throws IOException {
        out.writeBoolean(str == null);
        if (str == null) {
            return;
        }
        DrNioMessageMarshaller.writeUtf(out, str);
    }

    public static void writeUtf(DataOutput out, String s) throws IOException {
        int len = s.length();
        out.writeInt(DrNioMessageMarshaller.utfLength(s));
        for (int pos = 0; pos < len; ++pos) {
            char c = s.charAt(pos);
            if (c <= '\u007f' && c != '\u0000') {
                out.write(c);
                continue;
            }
            if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c & 0x3F);
                continue;
            }
            out.write(0xC0 | c >> 6 & 0x1F);
            out.write(0x80 | c & 0x3F);
        }
    }

    private static byte @Nullable [] readBytes(ByteBuffer in) {
        int length = in.getInt();
        if (length < 0) {
            return null;
        }
        byte[] data = new byte[length];
        in.get(data);
        return data;
    }

    private static void writeByteArray(IgniteUnsafeDataOutput out, byte @Nullable [] bytes, int size) throws IOException {
        if (bytes == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(size);
        out.write(bytes, 0, size);
    }

    @Nullable
    private static IgniteUuid readGridUuid(ByteBuffer in) {
        if (DrNioMessageMarshaller.readBoolean(in)) {
            return null;
        }
        long most = in.getLong();
        long least = in.getLong();
        long locId = in.getLong();
        return IgniteUuid.create(most, least, locId);
    }

    private static void writeGridUuid(IgniteUnsafeDataOutput out, @Nullable IgniteUuid message) throws IOException {
        out.writeBoolean(message == null);
        if (message == null) {
            return;
        }
        UUID uuid = message.globalId();
        out.writeLong(uuid.getMostSignificantBits());
        out.writeLong(uuid.getLeastSignificantBits());
        out.writeLong(message.localId());
    }

    private static BinaryMetadata readBinaryMetadata(ByteBuffer in) {
        Int2ObjectMap<BinarySchema> schemas;
        Map<String, BinaryFieldMetadata> fields;
        in.get();
        int typeId = in.getInt();
        String typeName = DrNioMessageMarshaller.readString(in);
        assert (typeName != null);
        int fieldsSize = in.getInt();
        if (fieldsSize == -1) {
            fields = Map.of();
        } else {
            fields = new HashMap();
            for (int i = 0; i < fieldsSize; ++i) {
                String fieldName = DrNioMessageMarshaller.readString(in);
                BinaryFieldMetadata fieldMetadata = DrNioMessageMarshaller.readBinaryFieldMetadata(in);
                fields.put(fieldName, fieldMetadata);
            }
        }
        DrNioMessageMarshaller.readString(in);
        int schemasSize = in.getInt();
        if (schemasSize == -1) {
            schemas = Int2ObjectMaps.emptyMap();
        } else {
            schemas = new Int2ObjectOpenHashMap(schemasSize);
            for (int i = 0; i < schemasSize; ++i) {
                BinarySchema schema = DrNioMessageMarshaller.readBinarySchema(in);
                schemas.put(schema.schemaId(), schema);
            }
        }
        boolean isEnum = DrNioMessageMarshaller.readBoolean(in);
        if (isEnum) {
            int size = in.getInt();
            for (int idx = 0; idx < size; ++idx) {
                DrNioMessageMarshaller.readString(in);
                in.getInt();
            }
        }
        return new BinaryMetadata(typeId, typeName, fields, schemas);
    }

    private static BinarySchema readBinarySchema(ByteBuffer in) {
        int schemaId = in.getInt();
        int idsCnt = in.getInt();
        IntArrayList fieldIds = new IntArrayList(idsCnt);
        for (int i = 0; i < idsCnt; ++i) {
            fieldIds.add(in.getInt());
        }
        return new BinarySchema(schemaId, fieldIds);
    }

    private static BinaryFieldMetadata readBinaryFieldMetadata(ByteBuffer in) {
        int typeId = in.getInt();
        int fieldId = in.getInt();
        return new BinaryFieldMetadata(fieldId, typeId);
    }

    private static void writeBinaryMetadata(IgniteUnsafeDataOutput out, BinaryMetadata meta) throws IOException {
        out.writeByte(1);
        out.writeInt(meta.typeId());
        DrNioMessageMarshaller.writeString(out, meta.typeName());
        if (meta.fieldsMap() == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(meta.fieldsMap().size());
            for (Map.Entry<String, BinaryFieldMetadata> fieldEntry : meta.fieldsMap().entrySet()) {
                DrNioMessageMarshaller.writeString(out, fieldEntry.getKey());
                DrNioMessageMarshaller.writeBinaryFieldMetadata(out, fieldEntry.getValue());
            }
        }
        DrNioMessageMarshaller.writeString(out, null);
        if (meta.schemas() == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(meta.schemas().size());
            for (BinarySchema schema : meta.schemas()) {
                DrNioMessageMarshaller.writeBinarySchema(out, schema);
            }
        }
        out.writeBoolean(false);
    }

    private static void writeBinaryFieldMetadata(DataOutput out, BinaryFieldMetadata meta) throws IOException {
        out.writeInt(meta.typeId());
        out.writeInt(meta.fieldId());
    }

    private static void writeBinarySchema(DataOutput out, BinarySchema schema) throws IOException {
        out.writeInt(schema.schemaId());
        out.writeInt(schema.fieldIds().length);
        int[] nArray = schema.fieldIds();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer id = nArray[i];
            out.writeInt(id);
        }
    }

    private static ByteBuffer completeMessage(byte[] bytes, int length) {
        ByteBuffer buf = ByteBuffer.wrap(bytes, 0, length);
        buf.putInt(0, length - 4);
        return buf;
    }
}

