/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.gridgain.internal.dr.optimized.OptimizedMarshaller;
import org.jetbrains.annotations.TestOnly;

public final class IgniteUuid
implements Externalizable {
    private UUID gid;
    private long locId;

    public static IgniteUuid create(long most, long least, long locId) {
        UUID gid = new UUID(most, least);
        return new IgniteUuid(gid, locId);
    }

    @TestOnly
    public static IgniteUuid create(UUID globalId, long localId) {
        return new IgniteUuid(globalId, localId);
    }

    @TestOnly
    public static IgniteUuid random() {
        return new IgniteUuid(UUID.randomUUID(), ThreadLocalRandom.current().nextLong());
    }

    IgniteUuid() {
    }

    public IgniteUuid(UUID gid, long locId) {
        assert (gid != null);
        this.gid = gid;
        this.locId = locId;
    }

    public String shortString() {
        return new StringBuilder(Long.toHexString(this.locId)).reverse().toString();
    }

    public UUID globalId() {
        return this.gid;
    }

    public long localId() {
        return this.locId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IgniteUuid)) {
            return false;
        }
        IgniteUuid that = (IgniteUuid)obj;
        return that.locId == this.locId && that.gid.equals(this.gid);
    }

    public int hashCode() {
        return 31 * this.gid.hashCode() + (int)(this.locId ^ this.locId >>> 32);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        OptimizedMarshaller.writeUuid(out, this.gid);
        out.writeLong(this.locId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.gid = OptimizedMarshaller.readUuid(in);
        this.locId = in.readLong();
    }

    public String toString() {
        return this.shortString() + "-" + String.valueOf(this.gid);
    }
}

