/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.common;

import org.gridgain.internal.dr.binary.BinaryMarshallerV8;
import org.gridgain.internal.dr.common.ByteArrayCacheObjectImpl;
import org.gridgain.internal.dr.common.CacheObject;
import org.gridgain.internal.dr.common.CacheObjectAdapter;
import org.gridgain.internal.dr.common.GridCacheVersion;
import org.jetbrains.annotations.Nullable;

public class GridCacheRawVersionedEntry {
    private final byte[] keyBytes;
    private final byte[] valBytes;
    private CacheObject key;
    @Nullable
    private CacheObject val;
    private final GridCacheVersion ver;

    public GridCacheRawVersionedEntry(byte[] keyBytes, byte[] valBytes, GridCacheVersion ver) {
        this.keyBytes = keyBytes;
        this.valBytes = valBytes;
        this.ver = ver;
    }

    public Object key() {
        assert (this.key != null);
        if (this.key instanceof CacheObjectAdapter) {
            return ((CacheObjectAdapter)this.key).value();
        }
        return this.key;
    }

    public byte[] keyBytes() {
        return this.keyBytes;
    }

    @Nullable
    public Object value() {
        if (this.val instanceof CacheObjectAdapter) {
            return ((CacheObjectAdapter)this.val).value();
        }
        if (this.val instanceof ByteArrayCacheObjectImpl) {
            return ((ByteArrayCacheObjectImpl)this.val).value();
        }
        return this.val;
    }

    public byte[] valueBytes() {
        return this.valBytes;
    }

    public GridCacheVersion version() {
        return this.ver;
    }

    public void unmarshal(BinaryMarshallerV8 marsh) {
        this.unmarshalKey(marsh);
        if (this.val == null && this.valBytes != null) {
            this.val = (CacheObject)marsh.unmarshal(this.valBytes);
            if (this.val instanceof CacheObjectAdapter) {
                ((CacheObjectAdapter)this.val).finishUnmarshal(marsh);
            }
        }
    }

    private void unmarshalKey(BinaryMarshallerV8 marsh) {
        if (this.key == null) {
            assert (this.keyBytes != null);
            CacheObject key0 = (CacheObject)marsh.unmarshal(this.keyBytes);
            assert (key0 != null);
            this.key = key0;
            if (this.key instanceof CacheObjectAdapter) {
                ((CacheObjectAdapter)this.key).finishUnmarshal(marsh);
            }
        }
    }
}

