/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rocksdb;

import java.util.NoSuchElementException;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.lang.ErrorGroups;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public abstract class RocksIteratorAdapter<T>
implements Cursor<T> {
    protected final RocksIterator it;

    protected RocksIteratorAdapter(RocksIterator it) {
        this.it = it;
    }

    @Override
    public void close() {
        this.it.close();
    }

    @Override
    public boolean hasNext() {
        boolean isValid = this.it.isValid();
        if (!isValid) {
            try {
                this.it.status();
            }
            catch (RocksDBException e) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
            }
        }
        return isValid;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.decodeEntry(this.it.key(), this.it.value());
        this.it.next();
        return result;
    }

    protected abstract T decodeEntry(byte[] var1, byte[] var2);
}

