/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.ru;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteUuid;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.direct.state.DirectMessageState;
import org.apache.ignite.internal.network.direct.state.DirectMessageStateItem;
import org.apache.ignite.internal.network.direct.stream.DirectByteBufferStream;
import org.apache.ignite.internal.network.direct.stream.DirectByteBufferStreamImplV1;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite.internal.network.serialization.MessageTypeInfo;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

class RollingUpgradeMessageWriter
implements MessageWriter {
    private final DirectMessageState<StateItem> state = new DirectMessageState<StateItem>(StateItem.class, () -> new StateItem(RollingUpgradeMessageWriter.createStream(serializationRegistry, protoVer)));

    public RollingUpgradeMessageWriter(MessageSerializationRegistry serializationRegistry, byte protoVer) {
    }

    private static DirectByteBufferStream createStream(MessageSerializationRegistry serializationRegistry, byte protoVer) {
        switch (protoVer) {
            case 1: {
                return new DirectByteBufferStreamImplV1(serializationRegistry);
            }
        }
        throw new IllegalStateException("Invalid protocol version: " + protoVer);
    }

    @Override
    public void setBuffer(ByteBuffer buf) {
        this.state.item().stream.setBuffer(buf);
    }

    @Override
    public void setCurrentWriteClass(Class<? extends NetworkMessage> msgCls) {
        this.state.item().writeMsgCls = msgCls;
    }

    @Override
    public void setMessageTypeInfo(MessageTypeInfo messageTypeInfo) {
        this.state.item().messageTypeInfo = messageTypeInfo;
    }

    @Override
    public boolean writeHeader(short groupType, short messageType, byte fieldCnt) {
        StateItem stateItem = this.state.item();
        DirectByteBufferStream stream = stateItem.stream;
        if (!stateItem.hdrGroupTypeWritten) {
            stream.writeShort(groupType);
            if (stream.lastFinished()) {
                stateItem.hdrGroupTypeWritten = true;
            } else {
                return false;
            }
        }
        if (!stateItem.hdrMessageTypeWritten) {
            stream.writeShort(messageType);
            if (stream.lastFinished()) {
                stateItem.hdrMessageTypeWritten = true;
            } else {
                return false;
            }
        }
        stream.writeByte(fieldCnt);
        return stream.lastFinished();
    }

    private boolean triggerOnFieldWrittenIfLastFinished(DirectByteBufferStream stream) {
        boolean lastFinished = stream.lastFinished();
        if (lastFinished) {
            this.onFieldWritten();
        }
        return lastFinished;
    }

    @Override
    public boolean writeByte(String name, byte val) {
        if (!this.writeFieldHeader((byte)1)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeByte(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    private void onFieldWritten() {
        ++this.state.item().writtenFieldCnt;
    }

    @Override
    public boolean writeBoxedByte(String name, @Nullable Byte val) {
        if (!this.writeFieldHeader((byte)9)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBoxedByte(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeShort(String name, short val) {
        if (!this.writeFieldHeader((byte)2)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeShort(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeBoxedShort(String name, @Nullable Short val) {
        if (!this.writeFieldHeader((byte)10)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBoxedShort(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeInt(String name, int val) {
        if (!this.writeFieldHeader((byte)3)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeInt(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeBoxedInt(String name, @Nullable Integer val) {
        if (!this.writeFieldHeader((byte)11)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBoxedInt(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeLong(String name, long val) {
        if (!this.writeFieldHeader((byte)4)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeLong(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeBoxedLong(String name, @Nullable Long val) {
        if (!this.writeFieldHeader((byte)12)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBoxedLong(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeFloat(String name, float val) {
        if (!this.writeFieldHeader((byte)5)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeFloat(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeBoxedFloat(String name, @Nullable Float val) {
        if (!this.writeFieldHeader((byte)13)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBoxedFloat(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeDouble(String name, double val) {
        if (!this.writeFieldHeader((byte)6)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeDouble(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeBoxedDouble(String name, @Nullable Double val) {
        if (!this.writeFieldHeader((byte)14)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBoxedDouble(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeChar(String name, char val) {
        if (!this.writeFieldHeader((byte)7)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeChar(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeBoxedChar(String name, @Nullable Character val) {
        if (!this.writeFieldHeader((byte)15)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBoxedChar(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeBoolean(String name, boolean val) {
        if (!this.writeFieldHeader((byte)8)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBoolean(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeBoxedBoolean(String name, @Nullable Boolean val) {
        if (!this.writeFieldHeader((byte)16)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBoxedBoolean(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeByteArray(String name, byte[] val) {
        return this.writeByteArray(name, val, 0L, val != null ? val.length : 0);
    }

    @Override
    public boolean writeByteArray(String name, byte[] val, long off, int len) {
        if (!this.writeFieldHeader((byte)17)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeByteArray(val, off, len);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeShortArray(String name, short[] val) {
        if (!this.writeFieldHeader((byte)18)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeShortArray(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeIntArray(String name, int[] val) {
        if (!this.writeFieldHeader((byte)19)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeIntArray(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeLongArray(String name, long[] val) {
        if (!this.writeFieldHeader((byte)20)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeLongArray(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeLongArray(String name, long[] val, int len) {
        if (!this.writeFieldHeader((byte)20)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeLongArray(val, len);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeFloatArray(String name, float[] val) {
        if (!this.writeFieldHeader((byte)21)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeFloatArray(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeDoubleArray(String name, double[] val) {
        if (!this.writeFieldHeader((byte)22)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeDoubleArray(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeCharArray(String name, char[] val) {
        if (!this.writeFieldHeader((byte)23)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeCharArray(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeBooleanArray(String name, boolean[] val) {
        if (!this.writeFieldHeader((byte)24)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBooleanArray(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeString(String name, String val) {
        if (!this.writeFieldHeader((byte)25)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeString(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeBitSet(String name, BitSet val) {
        if (!this.writeFieldHeader((byte)26)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBitSet(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeByteBuffer(String name, ByteBuffer val) {
        if (!this.writeFieldHeader((byte)27)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeByteBuffer(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeUuid(String name, UUID val) {
        if (!this.writeFieldHeader((byte)28)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeUuid(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeIgniteUuid(String name, IgniteUuid val) {
        if (!this.writeFieldHeader((byte)29)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeIgniteUuid(val);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean writeHybridTimestamp(String name, @Nullable HybridTimestamp val) {
        return this.writeLong(name, HybridTimestamp.hybridTimestampToLong(val));
    }

    @Override
    public boolean writeMessage(String name, NetworkMessage val) {
        if (!this.writeFieldHeader((byte)30)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeMessage(val, this);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public <T> boolean writeObjectArray(String name, T[] arr, MessageCollectionItemType itemType) {
        if (!this.writeCollectionFieldHeader((byte)31, itemType)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeObjectArray(arr, itemType, this);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public <T> boolean writeCollection(String name, Collection<T> col, MessageCollectionItemType itemType) {
        if (!this.writeCollectionFieldHeader((byte)32, itemType)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeCollection(col, itemType, this);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public <T> boolean writeList(String name, List<T> col, MessageCollectionItemType itemType) {
        if (!this.writeCollectionFieldHeader((byte)34, itemType)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeCollection(col, itemType, this);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public <T> boolean writeSet(String name, Set<T> col, MessageCollectionItemType itemType) {
        if (!this.writeCollectionFieldHeader((byte)35, itemType)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeSet(col, itemType, this);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public <K, V> boolean writeMap(String name, Map<K, V> map, MessageCollectionItemType keyType, MessageCollectionItemType valType) {
        if (!this.writeMapFieldHeader(keyType, valType)) {
            return false;
        }
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeMap(map, keyType, valType, this);
        return this.triggerOnFieldWrittenIfLastFinished(stream);
    }

    @Override
    public boolean isHeaderWritten() {
        return this.state.item().hdrWritten;
    }

    @Override
    public void onHeaderWritten() {
        this.state.item().hdrWritten = true;
    }

    @Override
    public int state() {
        return this.state.item().state;
    }

    @Override
    public void incrementState() {
        StateItem item = this.state.item();
        ++item.state;
        item.fieldTypeWritten = false;
        item.colItemTypeWritten = false;
        item.mapKeyTypeWritten = false;
        item.mapValTypeWritten = false;
    }

    @Override
    public void beforeInnerMessageWrite() {
        this.state.forward();
    }

    @Override
    public void afterInnerMessageWrite(boolean finished) {
        this.state.backward(finished);
    }

    @Override
    public void reset() {
        this.state.reset();
    }

    private boolean writeFieldHeader(byte type) {
        StateItem item = this.state.item();
        DirectByteBufferStream stream = item.stream;
        if (item.notVersionZero() && !item.fieldTypeWritten) {
            stream.writeByte(type);
            if (!stream.lastFinished()) {
                return false;
            }
            item.fieldTypeWritten = true;
        }
        return true;
    }

    private boolean writeCollectionFieldHeader(byte colType, MessageCollectionItemType itemType) {
        if (!this.writeFieldHeader(colType)) {
            return false;
        }
        StateItem item = this.state.item();
        DirectByteBufferStream stream = item.stream;
        if (item.notVersionZero() && !item.colItemTypeWritten) {
            stream.writeByte(itemType.code());
            if (!stream.lastFinished()) {
                return false;
            }
            item.colItemTypeWritten = true;
        }
        return true;
    }

    private boolean writeMapFieldHeader(MessageCollectionItemType keyType, MessageCollectionItemType valType) {
        if (!this.writeFieldHeader((byte)33)) {
            return false;
        }
        StateItem item = this.state.item();
        DirectByteBufferStream stream = item.stream;
        if (item.notVersionZero()) {
            if (!item.mapKeyTypeWritten) {
                stream.writeByte(keyType.code());
                if (!stream.lastFinished()) {
                    return false;
                }
                item.mapKeyTypeWritten = true;
            }
            if (!item.mapValTypeWritten) {
                stream.writeByte(valType.code());
                if (!stream.lastFinished()) {
                    return false;
                }
                item.mapValTypeWritten = true;
            }
        }
        return true;
    }

    public String toString() {
        return S.toString(RollingUpgradeMessageWriter.class, this);
    }

    private static class StateItem
    implements DirectMessageStateItem {
        private final DirectByteBufferStream stream;
        private int state;
        private boolean hdrGroupTypeWritten;
        private boolean hdrMessageTypeWritten;
        private boolean hdrWritten;
        private boolean fieldTypeWritten;
        private boolean colItemTypeWritten;
        private boolean mapKeyTypeWritten;
        private boolean mapValTypeWritten;
        private Class<? extends NetworkMessage> writeMsgCls;
        private MessageTypeInfo messageTypeInfo;
        private int writtenFieldCnt;

        private StateItem(DirectByteBufferStream stream) {
            this.stream = stream;
        }

        @Override
        public void reset() {
            this.state = 0;
            this.hdrGroupTypeWritten = false;
            this.hdrMessageTypeWritten = false;
            this.hdrWritten = false;
            this.fieldTypeWritten = false;
            this.colItemTypeWritten = false;
            this.mapKeyTypeWritten = false;
            this.mapValTypeWritten = false;
            this.writeMsgCls = null;
            this.writtenFieldCnt = 0;
        }

        boolean notVersionZero() {
            return this.writtenFieldCnt >= this.messageTypeInfo.version0FieldCount();
        }

        public String toString() {
            return S.toString(StateItem.class, this);
        }
    }
}

