/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.lang;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public final class IgniteSystemProperties {
    public static final String THREAD_ASSERTIONS_ENABLED = "IGNITE_THREAD_ASSERTIONS_ENABLED";
    public static final String LONG_HANDLING_LOGGING_ENABLED = "IGNITE_LONG_HANDLING_LOGGING_ENABLED";
    public static final String THREAD_ASSERTIONS_LOG_BEFORE_THROWING = "THREAD_ASSERTIONS_LOG_BEFORE_THROWING";
    public static final String IGNITE_SKIP_REPLICATION_IN_BENCHMARK = "IGNITE_SKIP_REPLICATION_IN_BENCHMARK";
    public static final String IGNITE_SKIP_STORAGE_UPDATE_IN_BENCHMARK = "IGNITE_SKIP_STORAGE_UPDATE_IN_BENCHMARK";
    public static final String COLOCATION_FEATURE_FLAG = "IGNITE_ZONE_BASED_REPLICATION";
    public static final String GG_LICENSE_OVERRIDE = "GG_LICENSE_OVERRIDE";
    public static final String GG_AWS_MAPPING_FILE_PATH = "GG_AWS_MAPPING_FILE_PATH";
    public static final String GG_GCP_MAPPING_FILE_PATH = "GG_GCP_MAPPING_FILE_PATH";

    private IgniteSystemProperties() {
    }

    @Deprecated
    public static boolean colocationEnabled() {
        return IgniteSystemProperties.getBoolean(COLOCATION_FEATURE_FLAG, true);
    }

    public static <E extends Enum<E>> E getEnum(Class<E> enumCls, String name) {
        return IgniteSystemProperties.getEnum(enumCls, name, null);
    }

    public static <E extends Enum<E>> E getEnum(String name, E dflt) {
        return IgniteSystemProperties.getEnum(dflt.getDeclaringClass(), name, dflt);
    }

    private static <E extends Enum<E>> E getEnum(Class<E> enumCls, String name, E dflt) {
        assert (enumCls != null);
        String val = IgniteSystemProperties.getString(name);
        if (val == null) {
            return dflt;
        }
        try {
            return Enum.valueOf(enumCls, val);
        }
        catch (IllegalArgumentException ignore) {
            return dflt;
        }
    }

    @Nullable
    public static String getString(String name) {
        assert (name != null);
        String v = System.getProperty(name);
        if (v == null) {
            v = System.getenv(name);
        }
        return v;
    }

    public static String getString(String name, String dflt) {
        String val = IgniteSystemProperties.getString(name);
        return val == null ? dflt : val;
    }

    public static boolean getBoolean(String name) {
        return IgniteSystemProperties.getBoolean(name, false);
    }

    public static boolean getBoolean(String name, boolean dflt) {
        String val = IgniteSystemProperties.getString(name);
        return val == null ? dflt : Boolean.parseBoolean(val);
    }

    public static int getInteger(String name, int dflt) {
        int res;
        String s = IgniteSystemProperties.getString(name);
        if (s == null) {
            return dflt;
        }
        try {
            res = Integer.parseInt(s);
        }
        catch (NumberFormatException ignore) {
            res = dflt;
        }
        return res;
    }

    public static float getFloat(String name, float dflt) {
        float res;
        String s = IgniteSystemProperties.getString(name);
        if (s == null) {
            return dflt;
        }
        try {
            res = Float.parseFloat(s);
        }
        catch (NumberFormatException ignore) {
            res = dflt;
        }
        return res;
    }

    public static long getLong(String name, long dflt) {
        long res;
        String s = IgniteSystemProperties.getString(name);
        if (s == null) {
            return dflt;
        }
        try {
            res = Long.parseLong(s);
        }
        catch (NumberFormatException ignore) {
            res = dflt;
        }
        return res;
    }

    public static double getDouble(String name, double dflt) {
        double res;
        String s = IgniteSystemProperties.getString(name);
        if (s == null) {
            return dflt;
        }
        try {
            res = Double.parseDouble(s);
        }
        catch (NumberFormatException ignore) {
            res = dflt;
        }
        return res;
    }

    public static Properties snapshot() {
        Properties sysProps = (Properties)System.getProperties().clone();
        Iterator<Map.Entry<Object, Object>> iter = sysProps.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            if (entry.getValue() instanceof String && entry.getKey() instanceof String) continue;
            iter.remove();
        }
        return sysProps;
    }
}

