/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.proto;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.binarytuple.inlineschema.TupleWithSchemaMarshalling;
import org.apache.ignite.internal.client.proto.ClientBinaryTupleUtils;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.ColumnTypeConverter;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.MarshallerException;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.table.DataStreamerReceiver;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

public class StreamerReceiverSerializer {
    public static <T, A> void serializeReceiverInfoOnClient(ClientMessagePacker w, String receiverClassName, @Nullable A receiverArg, @Nullable Marshaller<T, byte[]> itemsMarshaller, @Nullable Marshaller<A, byte[]> receiverArgMarshaller, Collection<T> items) {
        int binaryTupleSize = 6 + items.size();
        BinaryTupleBuilder builder = new BinaryTupleBuilder(binaryTupleSize);
        builder.appendString(receiverClassName);
        StreamerReceiverSerializer.appendArg(builder, receiverArg, receiverArgMarshaller);
        StreamerReceiverSerializer.appendCollectionToBinaryTuple(builder, items, itemsMarshaller);
        w.packInt(binaryTupleSize);
        w.packBinaryTuple(builder);
    }

    public static <T, A, R> byte[] serializeReceiverInfoWithElementCount(DataStreamerReceiverDescriptor<T, A, R> receiver, @Nullable A receiverArg, @Nullable Marshaller<T, byte[]> itemsMarshaller, @Nullable Marshaller<A, byte[]> receiverArgMarshaller, Collection<T> items) {
        int binaryTupleSize = 6 + items.size();
        BinaryTupleBuilder builder = new BinaryTupleBuilder(binaryTupleSize);
        builder.appendString(receiver.receiverClassName());
        StreamerReceiverSerializer.appendArg(builder, receiverArg, receiverArgMarshaller);
        StreamerReceiverSerializer.appendCollectionToBinaryTuple(builder, items, itemsMarshaller);
        ByteBuffer buf = builder.build();
        int bufSize = buf.limit() - buf.position();
        byte[] res = new byte[bufSize + 4];
        ByteBuffer.wrap(res).order(ByteOrder.LITTLE_ENDIAN).putInt(binaryTupleSize);
        buf.get(res, 4, bufSize);
        return res;
    }

    public static SteamerReceiverInfo deserializeReceiverInfo(ByteBuffer bytes, int elementCount, Function<String, DataStreamerReceiver<Object, Object, Object>> receiverFactory) {
        String receiverClassName;
        BinaryTupleReader reader = new BinaryTupleReader(elementCount, bytes);
        int readerIndex = 0;
        if ((receiverClassName = reader.stringValue(readerIndex++)) == null) {
            throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Receiver class name is null");
        }
        DataStreamerReceiver<Object, Object, Object> receiver = receiverFactory.apply(receiverClassName);
        Object receiverArg = StreamerReceiverSerializer.readArg(reader, readerIndex, receiver.argumentMarshaller());
        List<Object> items = StreamerReceiverSerializer.readCollectionFromBinaryTuple(reader, readerIndex += 3, receiver.payloadMarshaller());
        return new SteamerReceiverInfo(receiver, receiverArg, items);
    }

    public static <T> byte @Nullable [] serializeReceiverJobResults(@Nullable List<T> receiverResults, @Nullable Marshaller<T, byte[]> resultsMarshaller) {
        if (receiverResults == null || receiverResults.isEmpty()) {
            return null;
        }
        int numElements = 2 + receiverResults.size();
        BinaryTupleBuilder builder = new BinaryTupleBuilder(numElements);
        StreamerReceiverSerializer.appendCollectionToBinaryTuple(builder, receiverResults, resultsMarshaller);
        ByteBuffer res = builder.build();
        int numElementsSize = 4;
        byte[] resBytes = new byte[res.limit() - res.position() + numElementsSize];
        ByteBuffer.wrap(resBytes).order(ByteOrder.LITTLE_ENDIAN).putInt(numElements);
        res.get(resBytes, numElementsSize, resBytes.length - numElementsSize);
        return resBytes;
    }

    public static <R> List<R> deserializeReceiverJobResults(byte[] results, @Nullable Marshaller<R, byte[]> resultsMarshaller) {
        if (results == null || results.length == 0) {
            return List.of();
        }
        ByteBuffer buf = ByteBuffer.wrap(results).order(ByteOrder.LITTLE_ENDIAN);
        int numElements = buf.getInt();
        BinaryTupleReader reader = new BinaryTupleReader(numElements, buf.slice().order(ByteOrder.LITTLE_ENDIAN));
        return StreamerReceiverSerializer.readCollectionFromBinaryTuple(reader, 0, resultsMarshaller);
    }

    public static void serializeReceiverResultsForClient(ClientMessagePacker w, byte @Nullable [] receiverJobResults) {
        if (receiverJobResults == null || receiverJobResults.length == 0) {
            w.packNil();
            return;
        }
        int numElementsSize = 4;
        int binaryTupleSize = receiverJobResults.length - numElementsSize;
        int numElements = ByteBuffer.wrap(receiverJobResults).order(ByteOrder.LITTLE_ENDIAN).getInt();
        w.packInt(numElements);
        w.packBinaryHeader(binaryTupleSize);
        w.writePayload(receiverJobResults, numElementsSize, binaryTupleSize);
    }

    @Nullable
    public static <R> List<R> deserializeReceiverResultsOnClient(ClientMessageUnpacker r, @Nullable Marshaller<R, byte[]> resultsMarshaller) {
        if (r.tryUnpackNil()) {
            return null;
        }
        int numElements = r.unpackInt();
        byte[] bytes = r.readBinary();
        BinaryTupleReader reader = new BinaryTupleReader(numElements, bytes);
        return StreamerReceiverSerializer.readCollectionFromBinaryTuple(reader, 0, resultsMarshaller);
    }

    private static <T> void appendCollectionToBinaryTuple(BinaryTupleBuilder builder, Collection<T> items, @Nullable Marshaller<T, byte[]> itemsMarshaller) {
        assert (items != null) : "items can't be null";
        assert (!items.isEmpty()) : "items can't be empty";
        assert (builder != null) : "builder can't be null";
        if (itemsMarshaller != null) {
            builder.appendInt(ColumnType.BYTE_ARRAY.id());
            builder.appendInt(items.size());
            for (T item : items) {
                byte[] bytes = itemsMarshaller.marshal(item);
                builder.appendBytes(bytes);
            }
            return;
        }
        T firstItem = items.iterator().next();
        Objects.requireNonNull(firstItem);
        Class<?> type = firstItem.getClass();
        Consumer<T> appender = StreamerReceiverSerializer.appendTypeAndGetAppender(builder, firstItem);
        builder.appendInt(items.size());
        for (T item : items) {
            Objects.requireNonNull(item);
            if (!type.equals(item.getClass())) {
                throw new IllegalArgumentException("All items must have the same type. First item: " + String.valueOf(type) + ", current item: " + String.valueOf(item.getClass()));
            }
            appender.accept(item);
        }
    }

    private static <R> List<R> readCollectionFromBinaryTuple(BinaryTupleReader reader, int readerIndex, @Nullable Marshaller<R, byte[]> itemsMarshaller) {
        int typeId = reader.intValue(readerIndex++);
        Function<Integer, Object> itemReader = StreamerReceiverSerializer.readerForType(reader, typeId);
        int itemsCount = reader.intValue(readerIndex++);
        ArrayList<Object> items = new ArrayList<Object>(itemsCount);
        for (int i = 0; i < itemsCount; ++i) {
            Object itemRaw = itemReader.apply(readerIndex++);
            Object item = itemsMarshaller == null ? itemRaw : StreamerReceiverSerializer.unmarshalBytes(itemsMarshaller, itemRaw);
            items.add(item);
        }
        return items;
    }

    private static <T> Consumer<T> appendTypeAndGetAppender(BinaryTupleBuilder builder, Object obj) {
        assert (obj != null) : "Object is null";
        if (obj instanceof Boolean) {
            builder.appendInt(ColumnType.BOOLEAN.id());
            return v -> builder.appendBoolean((Boolean)v);
        }
        if (obj instanceof Byte) {
            builder.appendInt(ColumnType.INT8.id());
            return v -> builder.appendByte((Byte)v);
        }
        if (obj instanceof Short) {
            builder.appendInt(ColumnType.INT16.id());
            return v -> builder.appendShort((Short)v);
        }
        if (obj instanceof Integer) {
            builder.appendInt(ColumnType.INT32.id());
            return v -> builder.appendInt((Integer)v);
        }
        if (obj instanceof Long) {
            builder.appendInt(ColumnType.INT64.id());
            return v -> builder.appendLong((Long)v);
        }
        if (obj instanceof Float) {
            builder.appendInt(ColumnType.FLOAT.id());
            return v -> builder.appendFloat((Float)v);
        }
        if (obj instanceof Double) {
            builder.appendInt(ColumnType.DOUBLE.id());
            return v -> builder.appendDouble((Double)v);
        }
        if (obj instanceof BigDecimal) {
            builder.appendInt(ColumnType.DECIMAL.id());
            return v -> builder.appendDecimal((BigDecimal)v, ((BigDecimal)v).scale());
        }
        if (obj instanceof UUID) {
            builder.appendInt(ColumnType.UUID.id());
            return v -> builder.appendUuid((UUID)v);
        }
        if (obj instanceof String) {
            builder.appendInt(ColumnType.STRING.id());
            return v -> builder.appendString((String)v);
        }
        if (obj instanceof byte[]) {
            builder.appendInt(ColumnType.BYTE_ARRAY.id());
            return v -> builder.appendBytes((byte[])v);
        }
        if (obj instanceof LocalDate) {
            builder.appendInt(ColumnType.DATE.id());
            return v -> builder.appendDate((LocalDate)v);
        }
        if (obj instanceof LocalTime) {
            builder.appendInt(ColumnType.TIME.id());
            return v -> builder.appendTime((LocalTime)v);
        }
        if (obj instanceof LocalDateTime) {
            builder.appendInt(ColumnType.DATETIME.id());
            return v -> builder.appendDateTime((LocalDateTime)v);
        }
        if (obj instanceof Instant) {
            builder.appendInt(ColumnType.TIMESTAMP.id());
            return v -> builder.appendTimestamp((Instant)v);
        }
        if (obj instanceof Duration) {
            builder.appendInt(ColumnType.DURATION.id());
            return v -> builder.appendDuration((Duration)v);
        }
        if (obj instanceof Period) {
            builder.appendInt(ColumnType.PERIOD.id());
            return v -> builder.appendPeriod((Period)v);
        }
        if (obj instanceof Tuple) {
            builder.appendInt(-1);
            return v -> StreamerReceiverSerializer.appendTuple(builder, (Tuple)v);
        }
        throw ClientBinaryTupleUtils.unsupportedTypeException(obj.getClass());
    }

    private static Function<Integer, Object> readerForType(BinaryTupleReader binTuple, int typeId) {
        if (typeId == -1) {
            return idx -> StreamerReceiverSerializer.readTuple(binTuple, idx);
        }
        ColumnType type = ColumnTypeConverter.fromIdOrThrow(typeId);
        switch (type) {
            case INT8: {
                return binTuple::byteValue;
            }
            case INT16: {
                return binTuple::shortValue;
            }
            case INT32: {
                return binTuple::intValue;
            }
            case INT64: {
                return binTuple::longValue;
            }
            case FLOAT: {
                return binTuple::floatValue;
            }
            case DOUBLE: {
                return binTuple::doubleValue;
            }
            case DECIMAL: {
                return idx -> binTuple.decimalValue((int)idx, -1);
            }
            case UUID: {
                return binTuple::uuidValue;
            }
            case STRING: {
                return binTuple::stringValue;
            }
            case BYTE_ARRAY: {
                return binTuple::bytesValue;
            }
            case DATE: {
                return binTuple::dateValue;
            }
            case TIME: {
                return binTuple::timeValue;
            }
            case DATETIME: {
                return binTuple::dateTimeValue;
            }
            case TIMESTAMP: {
                return binTuple::timestampValue;
            }
            case BOOLEAN: {
                return idx -> binTuple.byteValue((int)idx) != 0;
            }
            case DURATION: {
                return binTuple::durationValue;
            }
            case PERIOD: {
                return binTuple::periodValue;
            }
        }
        throw ClientBinaryTupleUtils.unsupportedTypeException(type.id());
    }

    private static <T> void appendArg(BinaryTupleBuilder builder, @Nullable T arg, @Nullable Marshaller<T, byte[]> receiverArgMarshaller) {
        if (receiverArgMarshaller != null) {
            byte[] bytes = receiverArgMarshaller.marshal(arg);
            ClientBinaryTupleUtils.appendObject(builder, bytes);
            return;
        }
        if (arg instanceof Tuple) {
            builder.appendInt(-1);
            builder.appendInt(0);
            StreamerReceiverSerializer.appendTuple(builder, (Tuple)arg);
            return;
        }
        ClientBinaryTupleUtils.appendObject(builder, arg);
    }

    @Nullable
    private static Object readArg(BinaryTupleReader reader, int index, @Nullable Marshaller<Object, byte[]> receiverArgMarshaller) {
        if (reader.hasNullValue(index)) {
            return receiverArgMarshaller == null ? null : receiverArgMarshaller.unmarshal(null);
        }
        if (reader.intValue(index) == -1) {
            return StreamerReceiverSerializer.readTuple(reader, index + 2);
        }
        Object obj = ClientBinaryTupleUtils.readObject(reader, index);
        return receiverArgMarshaller == null ? obj : StreamerReceiverSerializer.unmarshalBytes(receiverArgMarshaller, obj);
    }

    @Nullable
    private static <T> T unmarshalBytes(Marshaller<T, byte[]> marshaller, @Nullable Object input) {
        try {
            if (input instanceof byte[]) {
                return marshaller.unmarshal((byte[])input);
            }
            if (input == null) {
                return marshaller.unmarshal(null);
            }
        }
        catch (Exception ex) {
            throw new MarshallerException(UUID.randomUUID(), ErrorGroups.Compute.MARSHALLING_TYPE_MISMATCH_ERR, "Exception in user-defined marshaller: " + ex.getMessage(), ex);
        }
        throw new MarshallerException(UUID.randomUUID(), ErrorGroups.Compute.MARSHALLING_TYPE_MISMATCH_ERR, "Marshaller is defined in the DataStreamerReceiver implementation, expected argument type: `byte[]`, actual: `" + String.valueOf(input.getClass()) + "`. Ensure that DataStreamerReceiverDescriptor marshallers match DataStreamerReceiver marshallers.", null);
    }

    private static <T> void appendTuple(BinaryTupleBuilder builder, Tuple arg) {
        builder.appendBytes(TupleWithSchemaMarshalling.marshal(arg));
    }

    @Nullable
    private static Object readTuple(BinaryTupleReader binTuple, int idx) {
        byte[] bytes = binTuple.bytesValue(idx);
        return bytes == null ? null : TupleWithSchemaMarshalling.unmarshal(bytes);
    }

    public static class SteamerReceiverInfo {
        private final DataStreamerReceiver<Object, Object, Object> receiver;
        @Nullable
        private final Object arg;
        private final List<Object> items;

        private SteamerReceiverInfo(DataStreamerReceiver<Object, Object, Object> receiver, @Nullable Object arg, List<Object> items) {
            this.receiver = receiver;
            this.arg = arg;
            this.items = items;
        }

        public DataStreamerReceiver<Object, Object, Object> receiver() {
            return this.receiver;
        }

        @Nullable
        public Object arg() {
            return this.arg;
        }

        public List<Object> items() {
            return this.items;
        }
    }
}

