/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.control;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.BytecodeVisitor;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.control.CaseStatement;
import com.facebook.presto.bytecode.control.FlowControl;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.instruction.LabelNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class SwitchStatement
implements FlowControl {
    private final LabelNode endLabel = new LabelNode("switchEnd");
    private final LabelNode defaultLabel = new LabelNode("switchDefault");
    private final String comment;
    private final BytecodeExpression expression;
    private final SortedSet<CaseStatement> cases;
    private final BytecodeNode defaultBody;

    public static SwitchBuilder switchBuilder() {
        return new SwitchBuilder();
    }

    private SwitchStatement(String comment, BytecodeExpression expression, Collection<CaseStatement> cases, BytecodeNode defaultBody) {
        this.comment = comment;
        this.expression = Objects.requireNonNull(expression, "expression is null");
        TreeSet<CaseStatement> sorted = new TreeSet<CaseStatement>(Comparator.comparing(CaseStatement::getKey));
        sorted.addAll(cases);
        this.cases = Collections.unmodifiableSortedSet(sorted);
        this.defaultBody = defaultBody;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public BytecodeExpression expression() {
        return this.expression;
    }

    public SortedSet<CaseStatement> cases() {
        return this.cases;
    }

    public LabelNode getDefaultLabel() {
        return this.defaultLabel;
    }

    public BytecodeNode getDefaultBody() {
        return this.defaultBody;
    }

    public LabelNode getEndLabel() {
        return this.endLabel;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        int[] keys = new int[this.cases.size()];
        Label[] labels = new Label[this.cases.size()];
        int index = 0;
        for (CaseStatement caseStatement : this.cases) {
            keys[index] = caseStatement.getKey();
            labels[index] = caseStatement.getLabel().getLabel();
            ++index;
        }
        BytecodeBlock block = new BytecodeBlock();
        for (CaseStatement caseStatement : this.cases) {
            block.visitLabel(caseStatement.getLabel()).append(caseStatement.getBody()).gotoLabel(this.endLabel);
        }
        block.visitLabel(this.defaultLabel);
        if (this.defaultBody != null) {
            block.append(this.defaultBody);
        }
        block.visitLabel(this.endLabel);
        this.expression.accept(visitor, generationContext);
        visitor.visitLookupSwitchInsn(this.defaultLabel.getLabel(), keys, labels);
        block.accept(visitor, generationContext);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of();
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitSwitch(parent, this);
    }

    public static class SwitchBuilder {
        private final Set<CaseStatement> cases = new HashSet<CaseStatement>();
        private String comment;
        private BytecodeExpression expression;
        private LabelNode defaultLabel;
        private BytecodeNode defaultBody;

        public SwitchBuilder comment(String format, Object ... args) {
            this.comment = String.format(format, args);
            return this;
        }

        public SwitchBuilder expression(BytecodeExpression expression) {
            this.expression = expression;
            return this;
        }

        public SwitchBuilder addCase(int key, BytecodeNode body) {
            LabelNode label = new LabelNode("switchCase:" + key);
            CaseStatement statement = new CaseStatement(key, body, label);
            BytecodeUtils.checkState(this.cases.add(statement), "case already exists for value [%s]", key);
            return this;
        }

        public SwitchBuilder defaultCase(BytecodeNode body) {
            BytecodeUtils.checkState(this.defaultBody == null, "default case already set");
            this.defaultBody = Objects.requireNonNull(body, "body is null");
            return this;
        }

        public SwitchStatement build() {
            BytecodeUtils.checkState(this.expression != null, "expression is not set");
            return new SwitchStatement(this.comment, this.expression, this.cases, this.defaultBody);
        }
    }
}

