/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gridgain.internal.dcr.AuthConfig;
import org.gridgain.internal.dcr.ReplicationStatus;
import org.gridgain.internal.dcr.SslConfig;
import org.gridgain.internal.dcr.exception.ReplicationException;
import org.jetbrains.annotations.Nullable;

public class ReplicationInfo {
    private final String name;
    private final Set<String> sourceClusterAddresses;
    @Nullable
    private final AuthConfig authConfig;
    @Nullable
    private final SslConfig sslConfig;
    private final String sourceClusterName;
    private final String targetClusterName;
    private final String workerNodeName;
    @Nullable
    private final String schemaName;
    private final ReplicationStatus status;
    @Nullable
    private final ReplicationException exception;
    private final int fstProgress;
    private final Map<String, ReplicationStatus> tableStatuses;

    public ReplicationInfo(String name, Set<String> sourceClusterAddresses, @Nullable AuthConfig authConfig, @Nullable SslConfig sslConfig, String sourceClusterName, String targetClusterName, String workerNodeName, @Nullable String schemaName, ReplicationStatus status, int fstProgress, @Nullable ReplicationException exception, Map<String, ReplicationStatus> tableStatuses) {
        this.name = name;
        this.sourceClusterAddresses = sourceClusterAddresses;
        this.authConfig = authConfig;
        this.sslConfig = sslConfig;
        this.sourceClusterName = sourceClusterName;
        this.targetClusterName = targetClusterName;
        this.workerNodeName = workerNodeName;
        this.schemaName = schemaName;
        this.status = status;
        this.fstProgress = fstProgress;
        this.exception = exception;
        this.tableStatuses = tableStatuses;
    }

    public String name() {
        return this.name;
    }

    public Set<String> sourceClusterAddresses() {
        return this.sourceClusterAddresses;
    }

    @Nullable
    public AuthConfig authConfig() {
        return this.authConfig;
    }

    @Nullable
    public SslConfig sslConfig() {
        return this.sslConfig;
    }

    public String sourceClusterName() {
        return this.sourceClusterName;
    }

    public String targetClusterName() {
        return this.targetClusterName;
    }

    public String workerNodeName() {
        return this.workerNodeName;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public ReplicationStatus status() {
        return this.status;
    }

    public int fstProgress() {
        return this.fstProgress;
    }

    @Nullable
    public ReplicationException exception() {
        return this.exception;
    }

    public Map<String, ReplicationStatus> tableStatuses() {
        return this.tableStatuses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationInfo that = (ReplicationInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.sourceClusterAddresses, that.sourceClusterAddresses) && Objects.equals(this.authConfig, that.authConfig) && Objects.equals(this.sslConfig, that.sslConfig) && Objects.equals(this.sourceClusterName, that.sourceClusterName) && Objects.equals(this.targetClusterName, that.targetClusterName) && Objects.equals(this.schemaName, that.schemaName) && this.status == that.status && Objects.equals(this.workerNodeName, that.workerNodeName) && Objects.equals(this.fstProgress, that.fstProgress) && Objects.equals(this.tableStatuses, that.tableStatuses);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.sourceClusterAddresses, this.authConfig, this.sslConfig, this.sourceClusterName, this.targetClusterName, this.workerNodeName, this.schemaName, this.status, this.fstProgress, this.tableStatuses});
    }

    public static ReplicationInfoBuilder builder() {
        return new ReplicationInfoBuilder();
    }

    public static final class ReplicationInfoBuilder {
        private String name;
        private Set<String> sourceClusterAddresses;
        @Nullable
        private AuthConfig authConfig;
        @Nullable
        private SslConfig sslConfig;
        private String sourceClusterName;
        private String targetClusterName;
        private String workerNodeName;
        private String schemaName;
        private ReplicationStatus status;
        private int fstProgress;
        @Nullable
        private ReplicationException exception;
        private Map<String, ReplicationStatus> tableStatuses;

        private ReplicationInfoBuilder() {
        }

        public ReplicationInfoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ReplicationInfoBuilder sourceClusterAddresses(Set<String> sourceClusterAddresses) {
            this.sourceClusterAddresses = sourceClusterAddresses;
            return this;
        }

        public ReplicationInfoBuilder authConfig(@Nullable AuthConfig authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public ReplicationInfoBuilder sslConfig(@Nullable SslConfig sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public ReplicationInfoBuilder sourceClusterName(String sourceClusterName) {
            this.sourceClusterName = sourceClusterName;
            return this;
        }

        public ReplicationInfoBuilder targetClusterName(String targetClusterName) {
            this.targetClusterName = targetClusterName;
            return this;
        }

        public ReplicationInfoBuilder workerNodeName(String workerNodeName) {
            this.workerNodeName = workerNodeName;
            return this;
        }

        public ReplicationInfoBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public ReplicationInfoBuilder status(ReplicationStatus status) {
            this.status = status;
            return this;
        }

        public ReplicationInfoBuilder fstProgress(int fstProgress) {
            this.fstProgress = fstProgress;
            return this;
        }

        public ReplicationInfoBuilder exception(@Nullable ReplicationException e) {
            this.exception = e;
            return this;
        }

        public ReplicationInfoBuilder tableStatuses(Map<String, ReplicationStatus> tableStatuses) {
            this.tableStatuses = tableStatuses;
            return this;
        }

        public ReplicationInfo build() {
            Objects.requireNonNull(this.name);
            Objects.requireNonNull(this.sourceClusterAddresses);
            Objects.requireNonNull(this.sourceClusterName);
            Objects.requireNonNull(this.targetClusterName);
            Objects.requireNonNull(this.workerNodeName);
            Objects.requireNonNull(this.status);
            return new ReplicationInfo(this.name, this.sourceClusterAddresses, this.authConfig, this.sslConfig, this.sourceClusterName, this.targetClusterName, this.workerNodeName, this.schemaName, this.status, this.fstProgress, this.exception, this.tableStatuses);
        }
    }
}

