/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr;

import java.util.Map;
import org.gridgain.internal.dcr.ReplicationStatus;
import org.gridgain.internal.dcr.metastorage.DcrStorage;
import org.gridgain.internal.dcr.metastorage.ExceptionEntry;
import org.gridgain.internal.dcr.metastorage.ReplicationEntry;

public class DcrErrorHandler {
    public static void handleFail(DcrStorage store, String nodeName, String name, Throwable throwable) {
        store.update(name, entry -> DcrErrorHandler.updateEntryWithFailedState(entry, nodeName, throwable), true);
    }

    private static ReplicationEntry updateEntryWithFailedState(ReplicationEntry entry, String nodeName, Throwable throwable) {
        Map<String, ReplicationStatus> statuses = entry.tableStatuses();
        statuses.replaceAll((k, v) -> ReplicationStatus.FAILED);
        return entry.toBuilder().status(ReplicationStatus.FAILED).tableStatuses(statuses).exception(ExceptionEntry.fromException(nodeName, throwable)).build();
    }
}

