/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr.table.schema;

import java.util.Map;
import java.util.Objects;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.table.Tuple;
import org.gridgain.internal.dcr.exception.ReplicationSchemaSyncException;
import org.gridgain.internal.dcr.table.TableManager;
import org.gridgain.internal.dcr.table.schema.SchemaSyncPolicy;

public class ManualSyncPolicy
implements SchemaSyncPolicy<Map.Entry<Tuple, Tuple>> {
    private final String nodeName;
    private final TableManager tableManager;

    public ManualSyncPolicy(String nodeName, TableManager tableManager) {
        this.nodeName = nodeName;
        this.tableManager = tableManager;
    }

    @Override
    public void isSchemaSync(Map.Entry<Tuple, Tuple> tupleEntry) throws ReplicationSchemaSyncException {
        SchemaRegistry schemaRegistry = this.tableManager.localSchema();
        SchemaDescriptor schema = schemaRegistry.lastKnownSchema();
        if (tupleEntry == null) {
            throw new ReplicationSchemaSyncException("Failed to parse source schema.", this.nodeName, this.tableManager.tableName());
        }
        if (tupleEntry.getKey() == null) {
            throw new ReplicationSchemaSyncException("Failed to parse source schema. Key tuple is null", this.nodeName, this.tableManager.tableName());
        }
        Tuple keyTuple = tupleEntry.getKey();
        if (!Objects.equals(keyTuple.columnCount(), schema.keyColumns().size())) {
            throw new ReplicationSchemaSyncException("Tables has different key column count. Source: " + keyTuple.columnCount() + ". Target: " + schema.keyColumns().size(), this.nodeName, this.tableManager.tableName());
        }
        Tuple valTuple = tupleEntry.getValue();
        if (valTuple == null) {
            return;
        }
        if (!Objects.equals(valTuple.columnCount(), schema.valueColumns().size())) {
            throw new ReplicationSchemaSyncException("Tables has different value column count. Source: " + valTuple.columnCount() + ". Target: " + schema.valueColumns().size(), this.nodeName, this.tableManager.tableName());
        }
        this.validateColumns(keyTuple, schema);
        this.validateColumns(valTuple, schema);
    }

    private void validateColumns(Tuple tuple, SchemaDescriptor schema) {
        int n = tuple.columnCount();
        for (int i = 0; i < n; ++i) {
            String columnName = tuple.columnName(i);
            Column column = schema.column(columnName);
            if (column == null) {
                throw new ReplicationSchemaSyncException("Target table doesn't have column: " + columnName, this.nodeName, this.tableManager.tableName());
            }
            try {
                column.validate(tuple.value(i));
                continue;
            }
            catch (IllegalArgumentException | InvalidTypeException e) {
                throw new ReplicationSchemaSyncException("Failed to validate schema. " + e.getMessage(), this.nodeName, this.tableManager.tableName());
            }
        }
    }
}

