/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.table.IgniteTables;
import org.gridgain.internal.dcr.Replication;
import org.gridgain.internal.dcr.ReplicationStartOptions;
import org.gridgain.internal.dcr.event.ReplicationEvent;
import org.gridgain.internal.dcr.event.ReplicationEventHandler;

public class LocalReplicationManager {
    private final Map<String, Replication> replications = new ConcurrentHashMap<String, Replication>();
    private final String nodeName;
    private final IgniteTables tables;
    private final MetricManager metricManager;
    private final ClockService clockService;

    public LocalReplicationManager(String nodeName, IgniteTables tables, MetricManager metricManager, ClockService clockService) {
        this.nodeName = nodeName;
        this.tables = tables;
        this.metricManager = metricManager;
        this.clockService = clockService;
    }

    public CompletableFuture<Void> startReplication(String name, ReplicationStartOptions options, ReplicationEventHandler<ReplicationEvent> handler) {
        Replication replication = this.replications.computeIfAbsent(name, unused -> new Replication(this.nodeName, name, this.tables, options, this.metricManager, this.clockService));
        return replication.start(handler, options.tables());
    }

    public void flushReplication(String name, Instant flushPoint) {
        this.replications.computeIfPresent(name, (replicationName, replication) -> {
            replication.flush(flushPoint);
            return replication;
        });
    }

    public void stopReplication(String name, List<String> tableToStop) {
        Replication replication = this.replications.get(name);
        if (replication != null) {
            replication.stop(tableToStop);
        }
    }

    public void stopReplication(String name) {
        Replication replication = this.replications.remove(name);
        if (replication != null) {
            replication.stopAll();
        }
    }

    public void stop() {
        this.replications.forEach((name, replication) -> replication.stopAll());
        this.replications.clear();
    }

    public Replication replication(String name) {
        return this.replications.get(name);
    }
}

