/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.internal.dcr.DcrManager;
import org.gridgain.internal.dcr.ReplicationInfo;
import org.gridgain.internal.dcr.ReplicationOptions;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.jetbrains.annotations.Nullable;

public class LicensedDcrManager
implements DcrManager {
    private final DcrManager dcrManager;
    private final LicenseFeatureChecker licenseChecker;

    public LicensedDcrManager(DcrManager dcrManager, LicenseFeatureChecker licenseChecker) {
        this.dcrManager = dcrManager;
        this.licenseChecker = licenseChecker;
    }

    private CompletableFuture<Void> checkLicense() {
        try {
            this.licenseChecker.checkFeature(LicenseFeature.DATA_CENTER_REPLICATION);
            return CompletableFutures.nullCompletedFuture();
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public CompletableFuture<ReplicationInfo> createReplication(ReplicationOptions options, boolean instantStart) {
        return this.checkLicense().thenCompose(unused -> this.dcrManager.createReplication(options, instantStart));
    }

    @Override
    public CompletableFuture<Boolean> startReplication(String name, String schema, @Nullable List<String> tables, boolean allTables) {
        return this.checkLicense().thenCompose(unused -> this.dcrManager.startReplication(name, schema, tables, allTables));
    }

    @Override
    public CompletableFuture<Boolean> stopReplication(String name, String schema, @Nullable List<String> tables, boolean allTables) {
        return this.checkLicense().thenCompose(unused -> this.dcrManager.stopReplication(name, schema, tables, allTables));
    }

    @Override
    public CompletableFuture<Boolean> removeReplication(String name) {
        return this.checkLicense().thenCompose(unused -> this.dcrManager.removeReplication(name));
    }

    @Override
    public CompletableFuture<ReplicationInfo> showReplication(String name) {
        return this.checkLicense().thenCompose(unused -> this.dcrManager.showReplication(name));
    }

    @Override
    public CompletableFuture<Collection<ReplicationInfo>> listReplications() {
        return this.checkLicense().thenCompose(unused -> this.dcrManager.listReplications());
    }

    @Override
    public CompletableFuture<Boolean> flushReplication(String name, Instant timestamp) {
        return this.checkLicense().thenCompose(unused -> this.dcrManager.flushReplication(name, timestamp));
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return this.dcrManager.startAsync(componentContext);
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return this.dcrManager.stopAsync(componentContext);
    }
}

