/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr.table;

import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.internal.client.TcpIgniteClient;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.table.TableImpl;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionOptions;
import org.gridgain.internal.dcr.exception.ReplicationSchemaSyncException;

public class TableManager {
    private final String nodeName;
    private final String tableName;
    private final IgniteClient client;
    private final IgniteTables tables;

    public TableManager(String nodeName, String tableName, IgniteClient client, IgniteTables tables) {
        this.nodeName = nodeName;
        this.tableName = tableName;
        this.client = client;
        this.tables = tables;
    }

    public KeyValueView<Tuple, Tuple> localTable() {
        Table table = this.tables.table(this.tableName);
        if (table == null) {
            throw new ReplicationSchemaSyncException("Table " + this.tableName + " doesn't exist on target side.", this.nodeName, this.tableName);
        }
        return table.keyValueView();
    }

    public SchemaRegistry localSchema() {
        Table table = this.tables.table(this.tableName);
        if (table instanceof TableImpl) {
            TableImpl internalTable = (TableImpl)table;
            return internalTable.schemaView();
        }
        throw new IllegalStateException();
    }

    public KeyValueView<Tuple, Tuple> remoteTable() {
        Table table = this.client.tables().table(this.tableName);
        if (table == null) {
            throw new ReplicationSchemaSyncException("Table " + this.tableName + " doesn't exist on source side.", this.nodeName, this.tableName);
        }
        return table.keyValueView();
    }

    public Transaction startLocalTransaction(boolean readOnly) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Transaction startRemoteTransaction(TransactionOptions transactionOptions) {
        return this.client.transactions().begin(transactionOptions);
    }

    public String tableName() {
        return this.tableName;
    }

    public IgniteClient client() {
        return this.client;
    }

    public long observableTimestamp() {
        return ((TcpIgniteClient)this.client).observableTimestamp();
    }
}

