/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr;

import java.util.Objects;
import org.apache.ignite.client.BasicAuthenticator;
import org.apache.ignite.client.IgniteClientAuthenticator;
import org.gridgain.internal.dcr.metastorage.AuthConfigEntry;
import org.jetbrains.annotations.Nullable;

public class AuthConfig {
    private final String username;
    private final String password;

    private AuthConfig(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthConfig that = (AuthConfig)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password);
    }

    public String toString() {
        return "AuthConfig{username='" + this.username + "', password='********'}";
    }

    @Nullable
    static IgniteClientAuthenticator createAuthenticator(@Nullable AuthConfig authConfig) {
        if (authConfig == null) {
            return null;
        }
        return BasicAuthenticator.builder().username(authConfig.username()).password(authConfig.password()).build();
    }

    @Nullable
    static AuthConfig fromEntry(@Nullable AuthConfigEntry authConfigEntry) {
        if (authConfigEntry == null) {
            return null;
        }
        return AuthConfig.builder().username(authConfigEntry.username()).password(authConfigEntry.password()).build();
    }

    public static final class Builder {
        private String username;
        private String password;

        private Builder() {
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public AuthConfig build() {
            Objects.requireNonNull(this.username, "Username must not be null.");
            Objects.requireNonNull(this.password, "Password must not be null.");
            return new AuthConfig(this.username, this.password);
        }
    }
}

