/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr.metastorage;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.EntryEvent;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.subscription.MapAccumulator;
import org.gridgain.internal.dcr.exception.ReplicationNotFoundException;
import org.gridgain.internal.dcr.metastorage.DcrKey;
import org.gridgain.internal.dcr.metastorage.DcrStorageListener;
import org.gridgain.internal.dcr.metastorage.ReplicationEntry;
import org.gridgain.internal.lang.Disposable;
import org.jetbrains.annotations.Nullable;

public class DcrStorage {
    private final MetaStorageManager manager;

    public DcrStorage(MetaStorageManager manager) {
        this.manager = manager;
    }

    public Disposable registerStoreListener(DcrStorageListener listener) {
        WatchListener watchListener = DcrStorage.toWatchListener(listener);
        this.manager.registerPrefixWatch(DcrKey.prefix(), watchListener);
        return () -> this.manager.unregisterWatch(watchListener);
    }

    private static WatchListener toWatchListener(DcrStorageListener listener) {
        return event -> {
            ArrayList<CompletableFuture<Void>> result = new ArrayList<CompletableFuture<Void>>();
            for (EntryEvent e : event.entryEvents()) {
                String name = DcrStorage.extractName(e);
                ReplicationEntry oldValue = DcrStorage.extractValue(e.oldEntry());
                ReplicationEntry newValue = DcrStorage.extractValue(e.newEntry());
                if (name == null) continue;
                if (oldValue == null) {
                    if (newValue == null) continue;
                    result.add(listener.onAdd(name, newValue));
                    continue;
                }
                if (newValue != null) {
                    result.add(listener.onUpdate(name, oldValue, newValue));
                    continue;
                }
                result.add(listener.onRemove(name, oldValue));
            }
            return CompletableFuture.allOf((CompletableFuture[])result.toArray(CompletableFuture[]::new));
        };
    }

    public CompletableFuture<Boolean> put(String name, ReplicationEntry entry) {
        ByteArray key = DcrKey.toKey(name);
        return this.manager.invoke((Condition)Conditions.notExists((ByteArray)key), Operations.put((ByteArray)key, (byte[])entry.toByteArray()), Operations.noop());
    }

    public CompletableFuture<Map<String, ReplicationEntry>> findByNode(String nodeName) {
        CompletableFuture<Map<String, ReplicationEntry>> result = new CompletableFuture<Map<String, ReplicationEntry>>();
        this.manager.prefix(DcrKey.prefix()).subscribe(new MapAccumulator(entry -> DcrKey.fromByteArr(entry.key()), entry -> DcrStorage.extractFilterValue(entry, replicationEntry -> Objects.equals(replicationEntry.workerNode(), nodeName))).toSubscriber(result));
        return result;
    }

    public CompletableFuture<ReplicationEntry> get(String name) {
        ByteArray key = DcrKey.toKey(name);
        return this.manager.get(key).thenApply(DcrStorage::extractValue);
    }

    public CompletableFuture<Map<String, ReplicationEntry>> getAll() {
        CompletableFuture<Map<String, ReplicationEntry>> result = new CompletableFuture<Map<String, ReplicationEntry>>();
        this.manager.prefix(DcrKey.prefix()).subscribe(new MapAccumulator(entry -> DcrKey.fromByteArr(entry.key()), DcrStorage::extractValue).toSubscriber(result));
        return result;
    }

    public CompletableFuture<Boolean> remove(String name) {
        return this.remove(name, entry -> true);
    }

    public CompletableFuture<Boolean> remove(String name, Predicate<ReplicationEntry> checker) {
        ByteArray key = DcrKey.toKey(name);
        return this.manager.get(key).thenCompose(entry -> {
            ReplicationEntry current = DcrStorage.extractValue(entry);
            if (current == null) {
                throw new ReplicationNotFoundException(name);
            }
            if (!checker.test(current)) {
                return CompletableFutures.falseCompletedFuture();
            }
            return this.manager.invoke((Condition)Conditions.revision((ByteArray)key).le(entry.revision()), Operations.remove((ByteArray)key), Operations.noop());
        });
    }

    public CompletableFuture<Boolean> update(String name, Function<ReplicationEntry, ReplicationEntry> func, boolean withRetry) {
        ByteArray key = DcrKey.toKey(name);
        return this.manager.get(key).thenCompose(entry -> {
            ReplicationEntry current = DcrStorage.extractValue(entry);
            if (current == null) {
                throw new ReplicationNotFoundException(name);
            }
            ReplicationEntry newEntry = (ReplicationEntry)func.apply(current);
            if (newEntry == null || newEntry.equals(current)) {
                return CompletableFutures.falseCompletedFuture();
            }
            return this.manager.invoke((Condition)Conditions.revision((ByteArray)key).le(entry.revision()), Operations.put((ByteArray)key, (byte[])newEntry.toByteArray()), Operations.noop()).thenCompose(finished -> {
                if (!finished.booleanValue() && withRetry) {
                    return this.update(name, func, withRetry);
                }
                return CompletableFutures.trueCompletedFuture();
            });
        });
    }

    @Nullable
    private static ReplicationEntry extractValue(@Nullable Entry entry) {
        if (entry == null || entry.tombstone() || entry.empty()) {
            return null;
        }
        return ReplicationEntry.fromByteArray(entry.value());
    }

    @Nullable
    private static ReplicationEntry extractFilterValue(@Nullable Entry entry, Predicate<ReplicationEntry> filter) {
        ReplicationEntry replicationEntry = DcrStorage.extractValue(entry);
        if (replicationEntry != null && filter.test(replicationEntry)) {
            return replicationEntry;
        }
        return null;
    }

    @Nullable
    private static String extractName(EntryEvent e) {
        Entry oldEntry = e.oldEntry();
        Entry newEntry = e.newEntry();
        if (oldEntry != null) {
            return DcrKey.fromByteArr(oldEntry.key());
        }
        if (newEntry != null) {
            return DcrKey.fromByteArr(newEntry.key());
        }
        return null;
    }
}

