/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr.metrics;

import java.util.List;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.AtomicLongMetric;
import org.apache.ignite.internal.metrics.Metric;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DcrMetricSource
extends AbstractMetricSource<Holder> {
    public DcrMetricSource(String replicationName, String table) {
        super(String.format("dcr.replications.%s.%s", replicationName, table));
    }

    public void entriesObservedIncrement() {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.entriesObserved.increment();
        }
    }

    public void entriesSentIncrement() {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.entriesSent.increment();
        }
    }

    public void lag(long lag) {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.lagEstimation.value(lag);
        }
    }

    @TestOnly
    @Nullable
    public AtomicLongMetric entriesObserved() {
        Holder holder = (Holder)this.holder();
        return holder != null ? holder.entriesObserved : null;
    }

    @TestOnly
    @Nullable
    public AtomicLongMetric entriesSent() {
        Holder holder = (Holder)this.holder();
        return holder != null ? holder.entriesSent : null;
    }

    @TestOnly
    @Nullable
    public AtomicLongMetric lagEstimation() {
        Holder holder = (Holder)this.holder();
        return holder != null ? holder.lagEstimation : null;
    }

    protected Holder createHolder() {
        return new Holder();
    }

    protected static class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final AtomicLongMetric entriesObserved = new AtomicLongMetric("EntriesObserved", "Observed entries count.");
        private final AtomicLongMetric entriesSent = new AtomicLongMetric("EntriesSent", "Sent entries count.");
        private final AtomicLongMetric lagEstimation = new AtomicLongMetric("ReplicationLag", "Lag estimation.");
        private final List<Metric> metrics = List.of(this.entriesObserved, this.entriesSent, this.lagEstimation);

        protected Holder() {
        }

        public Iterable<Metric> metrics() {
            return this.metrics;
        }
    }
}

