/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr.metastorage;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gridgain.internal.dcr.metastorage.MetaStoreByteArrayBuilder;
import org.gridgain.internal.dcr.metastorage.MetaStoreByteArrayReader;
import org.jetbrains.annotations.Nullable;

public class SslConfigEntry {
    @Nullable
    private final Set<String> ciphers;
    @Nullable
    private final String keyStorePath;
    @Nullable
    private final String keyStorePassword;
    @Nullable
    private final String trustStorePath;
    @Nullable
    private final String trustStorePassword;

    private SslConfigEntry(@Nullable Set<String> ciphers, @Nullable String keyStorePath, @Nullable String keyStorePassword, @Nullable String trustStorePath, @Nullable String trustStorePassword) {
        this.ciphers = ciphers;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
    }

    @Nullable
    public Set<String> ciphers() {
        return this.ciphers;
    }

    @Nullable
    public String keyStorePath() {
        return this.keyStorePath;
    }

    @Nullable
    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    @Nullable
    public String trustStorePath() {
        return this.trustStorePath;
    }

    @Nullable
    public String trustStorePassword() {
        return this.trustStorePassword;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SslConfigEntry.builder().ciphers(this.ciphers).keyStorePath(this.keyStorePath).keyStorePassword(this.keyStorePassword).trustStorePath(this.trustStorePath).trustStorePassword(this.trustStorePassword);
    }

    byte[] toByteArray() {
        MetaStoreByteArrayBuilder byteArrayBuilder = new MetaStoreByteArrayBuilder();
        return byteArrayBuilder.appendNullableCollection(this.ciphers).appendNullableString(this.keyStorePath).appendNullableString(this.keyStorePassword).appendNullableString(this.trustStorePath).appendNullableString(this.trustStorePassword).build();
    }

    static SslConfigEntry fromByteArray(byte[] array) {
        MetaStoreByteArrayReader reader = new MetaStoreByteArrayReader(array);
        SslConfigEntry entry = SslConfigEntry.builder().ciphers(reader.readNullableCollection(Collectors.toSet())).keyStorePath(reader.readNullableString()).keyStorePassword(reader.readNullableString()).trustStorePath(reader.readNullableString()).trustStorePassword(reader.readNullableString()).build();
        assert (!reader.hasNext());
        return entry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslConfigEntry sslConfig = (SslConfigEntry)o;
        return Objects.equals(this.ciphers, sslConfig.ciphers) && Objects.equals(this.keyStorePath, sslConfig.keyStorePath) && Objects.equals(this.keyStorePassword, sslConfig.keyStorePassword) && Objects.equals(this.trustStorePath, sslConfig.trustStorePath) && Objects.equals(this.trustStorePassword, sslConfig.trustStorePassword);
    }

    public int hashCode() {
        return Objects.hash(this.ciphers, this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword);
    }

    public String toString() {
        return "SslConfigEntry{ciphers=" + String.valueOf(this.ciphers) + ", keyStorePath='" + this.keyStorePath + "', keyStorePassword='********', trustStorePath='" + this.trustStorePath + "', trustStorePassword='********'}";
    }

    public static final class Builder {
        @Nullable
        private Set<String> ciphers;
        @Nullable
        private String keyStorePath;
        @Nullable
        private String keyStorePassword;
        @Nullable
        private String trustStorePath;
        @Nullable
        private String trustStorePassword;

        private Builder() {
        }

        public Builder ciphers(@Nullable Set<String> ciphers) {
            this.ciphers = ciphers;
            return this;
        }

        public Builder keyStorePath(@Nullable String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public Builder keyStorePassword(@Nullable String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder trustStorePath(@Nullable String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public Builder trustStorePassword(@Nullable String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public SslConfigEntry build() {
            return new SslConfigEntry(this.ciphers, this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword);
        }
    }
}

