/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr;

import java.util.Objects;
import java.util.Set;
import org.apache.ignite.client.SslConfiguration;
import org.gridgain.internal.dcr.metastorage.SslConfigEntry;
import org.jetbrains.annotations.Nullable;

public class SslConfig {
    @Nullable
    private final Set<String> ciphers;
    @Nullable
    private final String keyStorePath;
    @Nullable
    private final String keyStorePassword;
    @Nullable
    private final String trustStorePath;
    @Nullable
    private final String trustStorePassword;

    private SslConfig(@Nullable Set<String> ciphers, @Nullable String keyStorePath, @Nullable String keyStorePassword, @Nullable String trustStorePath, @Nullable String trustStorePassword) {
        this.ciphers = ciphers;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
    }

    @Nullable
    public Set<String> ciphers() {
        return this.ciphers;
    }

    @Nullable
    public String keyStorePath() {
        return this.keyStorePath;
    }

    @Nullable
    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    @Nullable
    public String trustStorePath() {
        return this.trustStorePath;
    }

    @Nullable
    public String trustStorePassword() {
        return this.trustStorePassword;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslConfig sslConfig = (SslConfig)o;
        return Objects.equals(this.ciphers, sslConfig.ciphers) && Objects.equals(this.keyStorePath, sslConfig.keyStorePath) && Objects.equals(this.keyStorePassword, sslConfig.keyStorePassword) && Objects.equals(this.trustStorePath, sslConfig.trustStorePath) && Objects.equals(this.trustStorePassword, sslConfig.trustStorePassword);
    }

    public int hashCode() {
        return Objects.hash(this.ciphers, this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword);
    }

    public String toString() {
        return "SslConfig{ciphers=" + String.valueOf(this.ciphers) + ", keyStorePath='" + this.keyStorePath + "', keyStorePassword='********', trustStorePath='" + this.trustStorePath + "', trustStorePassword='********'}";
    }

    @Nullable
    static SslConfiguration createSslConfiguration(@Nullable SslConfig sslConfig) {
        if (sslConfig == null) {
            return null;
        }
        return SslConfiguration.builder().ciphers(sslConfig.ciphers()).keyStorePath(sslConfig.keyStorePath()).keyStorePassword(sslConfig.keyStorePassword()).trustStorePath(sslConfig.trustStorePath()).trustStorePassword(sslConfig.trustStorePassword()).enabled(true).build();
    }

    @Nullable
    static SslConfig fromEntry(@Nullable SslConfigEntry sslConfigEntry) {
        if (sslConfigEntry == null) {
            return null;
        }
        return SslConfig.builder().ciphers(sslConfigEntry.ciphers()).keyStorePath(sslConfigEntry.keyStorePath()).keyStorePassword(sslConfigEntry.keyStorePassword()).trustStorePath(sslConfigEntry.trustStorePath()).trustStorePassword(sslConfigEntry.trustStorePassword()).build();
    }

    public static final class Builder {
        @Nullable
        private Set<String> ciphers;
        @Nullable
        private String keyStorePath;
        @Nullable
        private String keyStorePassword;
        @Nullable
        private String trustStorePath;
        @Nullable
        private String trustStorePassword;

        private Builder() {
        }

        public Builder ciphers(@Nullable Set<String> ciphers) {
            this.ciphers = ciphers;
            return this;
        }

        public Builder keyStorePath(@Nullable String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public Builder keyStorePassword(@Nullable String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder trustStorePath(@Nullable String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public Builder trustStorePassword(@Nullable String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public SslConfig build() {
            return new SslConfig(this.ciphers, this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword);
        }
    }
}

