/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.gridgain.internal.dcr.AuthConfig;
import org.gridgain.internal.dcr.SslConfig;
import org.gridgain.internal.dcr.metastorage.ReplicationEntry;
import org.jetbrains.annotations.Nullable;

public class ReplicationOptions {
    private final String name;
    private final Set<String> sourceClusterAddresses;
    @Nullable
    private final AuthConfig authConfig;
    @Nullable
    private final SslConfig sslConfig;
    private final Set<String> replicationNodes;

    private ReplicationOptions(String name, Set<String> sourceClusterAddresses, @Nullable AuthConfig authConfig, @Nullable SslConfig sslConfig, Set<String> replicationNodes) {
        this.name = name;
        this.sourceClusterAddresses = sourceClusterAddresses;
        this.authConfig = authConfig;
        this.sslConfig = sslConfig;
        this.replicationNodes = replicationNodes;
    }

    public String name() {
        return this.name;
    }

    public Set<String> sourceClusterAddresses() {
        return this.sourceClusterAddresses;
    }

    @Nullable
    public AuthConfig authConfig() {
        return this.authConfig;
    }

    @Nullable
    public SslConfig sslConfig() {
        return this.sslConfig;
    }

    public Set<String> replicationNodes() {
        return this.replicationNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationOptions that = (ReplicationOptions)o;
        return Objects.equals(this.sourceClusterAddresses, that.sourceClusterAddresses) && Objects.equals(this.authConfig, that.authConfig) && Objects.equals(this.sslConfig, that.sslConfig) && Objects.equals(this.replicationNodes, that.replicationNodes);
    }

    public int hashCode() {
        return Objects.hash(this.sourceClusterAddresses, this.authConfig, this.sslConfig, this.replicationNodes);
    }

    public static ReplicationOptions fromEntry(ReplicationEntry entry) {
        return ReplicationOptions.builder().sourceClusterAddresses(entry.sourceClusterAddresses()).authConfig(AuthConfig.fromEntry(entry.authConfig())).sslConfig(SslConfig.fromEntry(entry.sslConfig())).build();
    }

    public static ReplicationOptionsBuilder builder() {
        return new ReplicationOptionsBuilder();
    }

    public static class ReplicationOptionsBuilder {
        private String name;
        private Set<String> sourceClusterAddresses;
        @Nullable
        private AuthConfig authConfig;
        @Nullable
        private SslConfig sslConfig;
        private final Set<String> replicationNodes = new HashSet<String>();

        public ReplicationOptionsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ReplicationOptionsBuilder sourceClusterAddresses(Set<String> sourceClusterAddresses) {
            this.sourceClusterAddresses = sourceClusterAddresses;
            return this;
        }

        public ReplicationOptionsBuilder authConfig(@Nullable AuthConfig authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public ReplicationOptionsBuilder sslConfig(@Nullable SslConfig sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public ReplicationOptionsBuilder replicationNodes(@Nullable Set<String> replicationNodes) {
            this.replicationNodes.clear();
            if (replicationNodes != null) {
                this.replicationNodes.addAll(replicationNodes);
            }
            return this;
        }

        public ReplicationOptions build() {
            Objects.requireNonNull(this.sourceClusterAddresses, "Source cluster addresses must not be null.");
            return new ReplicationOptions(this.name, this.sourceClusterAddresses, this.authConfig, this.sslConfig, this.replicationNodes);
        }
    }
}

