/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.gridgain.grid.cache.compress.DictionaryCompressionMetrics;

class DictionarySampler {
    private static final byte[] TOMBSTONE = new byte[0];
    private final int bufSz;
    private final int skipToGeneration;
    private final DictionaryCompressionMetrics metrics;
    private int generation = 0;
    private int progress = 0;
    private int collected = 0;
    private ArrayList<byte[]> samples = new ArrayList();
    private final Lock lock = new ReentrantLock();

    public DictionarySampler(int bufSz, int generation, DictionaryCompressionMetrics metrics) {
        assert ((long)bufSz > 0L);
        this.bufSz = bufSz;
        this.skipToGeneration = generation;
        this.metrics = metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(byte[] sample) {
        int len = sample.length;
        boolean locked = false;
        try {
            if (len == 0 || !(locked = this.lock.tryLock()) || this.ready()) {
                boolean bl = false;
                return bl;
            }
            int pos = this.progress++;
            if (this.generation > 0) {
                int samplesSize;
                long seed = (long)(pos * pos) % Integer.MAX_VALUE;
                int n = samplesSize = this.collected > this.bufSz ? this.samples.size() : 1 + this.samples.size() * this.bufSz / this.collected;
                if (seed >= 0L && seed % (long)((this.generation + 1) * (this.generation + 1)) == 0L) {
                    pos = (int)(seed % (long)samplesSize);
                } else {
                    boolean bl = this.ready();
                    return bl;
                }
            }
            byte[] copy = Arrays.copyOf(sample, len);
            if (pos >= this.samples.size()) {
                this.collected += len;
                this.samples.add(copy);
                if (this.metrics != null) {
                    this.metrics.onSampleCollected(len);
                }
            } else {
                int existingLen = this.samples.get(pos).length;
                this.collected -= existingLen;
                if (this.metrics != null) {
                    this.metrics.onSampleDiscarded(existingLen);
                }
                if (existingLen < len && this.collected > this.bufSz) {
                    this.samples.set(pos, TOMBSTONE);
                } else {
                    this.collected += len;
                    this.samples.set(pos, copy);
                    if (this.metrics != null) {
                        this.metrics.onSampleCollected(len);
                    }
                }
            }
            boolean bl = this.ready();
            return bl;
        }
        finally {
            if (locked) {
                this.lock.unlock();
            }
        }
    }

    private boolean ready() {
        if (this.generation == 0) {
            return this.collected > this.bufSz;
        }
        return this.progress > this.samples.size() * (this.generation + 1) * (this.generation + 1);
    }

    public void withSamples(IgniteBiInClosure<Integer, Collection<byte[]>> closure) {
        this.lock.lock();
        try {
            closure.apply((Object)this.collected, this.samples);
        }
        finally {
            this.generation = Math.max(this.generation + 1, this.skipToGeneration);
            this.progress = 0;
            this.lock.unlock();
        }
    }
}

