/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import java.util.Base64;
import java.util.Random;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.spi.metric.IntMetric;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.cache.compress.ZstdDictionaryCompressionConfiguration;
import org.gridgain.grid.cache.compress.values.TestLargeValue;
import org.gridgain.grid.cache.compress.values.TestObject;
import org.gridgain.internal.h2.util.StringUtils;
import org.junit.Test;

@WithSystemProperty(key="IGNITE_DISABLE_WAL_DURING_REBALANCING", value="false")
public class ZstdCompressionPersistentDictionaryWithRestartsTest
extends GridCommonAbstractTest {
    private static final int CYCLE = 10000;
    private static final int MAX_ITEMS = 30000;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setMetricsEnabled(true).setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMetricsEnabled(true).setPersistenceEnabled(true).setMaxSize(0x4000000L)));
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(boolean compressKeys) {
        return new CacheConfiguration("default").setEntryCompressionConfiguration((EntryCompressionConfiguration)new ZstdDictionaryCompressionConfiguration().setSamplesBufferSize(131072).setCompressKeys(compressKeys)).setBackups(1);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
        this.startGrids(3);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testPrimitiveKey() throws Exception {
        IgniteEx ignite1 = this.grid(0);
        IgniteEx ignite2 = this.grid(1);
        ignite1.createCache(this.cacheConfiguration(false));
        IgniteCache c = ignite2.cache("default");
        for (int i = 0; i < 30000; ++i) {
            long seed = i * i % Integer.MAX_VALUE;
            c.put((Object)seed, (Object)new TestObject(seed));
            if (i > 10000) {
                int idToRmv = i - 10000;
                c.remove((Object)(idToRmv * idToRmv % Integer.MAX_VALUE));
            }
            if (i % 10000 != 0) continue;
            ignite1.close();
            ignite1 = this.startGrid(0);
        }
    }

    @Test
    public void testCompositeKey() throws Exception {
        IgniteEx ignite1 = this.grid(0);
        IgniteEx ignite2 = this.grid(1);
        ignite2.createCache(this.cacheConfiguration(true));
        IgniteCache c = ignite1.cache("default");
        int activeDicts = 0;
        for (int i = 0; i < 30000; ++i) {
            long seed = i * i % Integer.MAX_VALUE;
            c.put((Object)new TestKey(seed), (Object)new TestObject(seed));
            if (i > 10000) {
                int idToRmv = i - 10000;
                c.remove((Object)new TestKey(idToRmv * idToRmv % Integer.MAX_VALUE));
            }
            if (i % 10000 != 0) continue;
            activeDicts = this.countDictionaries(ignite1, c, true);
            this.stopGrid(0, false);
            ignite1 = this.startGrid(0);
            c = ignite1.cache("default");
            ZstdCompressionPersistentDictionaryWithRestartsTest.assertEquals((int)0, (int)this.countDictionaries(ignite1, c, false));
            ZstdCompressionPersistentDictionaryWithRestartsTest.assertEquals((int)activeDicts, (int)this.countDictionaries(ignite1, c, true));
        }
        ZstdCompressionPersistentDictionaryWithRestartsTest.assertTrue((activeDicts > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testObjectiveKey() throws Exception {
        IgniteEx ignite = this.grid(0);
        IgniteCache c = ignite.createCache(this.cacheConfiguration(true));
        for (int i = 0; i < 30000; ++i) {
            c.put((Object)new TestObject(i), (Object)i);
            if (i > 10000) {
                int idToRmv = i - 10000;
                ZstdCompressionPersistentDictionaryWithRestartsTest.assertTrue((boolean)c.remove((Object)new TestObject(idToRmv)));
            }
            if (i % 10000 != 0) continue;
            ignite.close();
            ignite = this.startGrid(0);
            c = ignite.cache("default");
        }
    }

    @Test
    public void testLargeValue() throws Exception {
        IgniteEx ignite = this.grid(0);
        IgniteCache c = ignite.createCache(this.cacheConfiguration(true));
        Random r = new Random();
        for (int i = 0; i < 3000; ++i) {
            byte[] randomPart = new byte[4096];
            r.nextBytes(randomPart);
            String compressablePart = StringUtils.pad((String)"", (int)8192, (String)Integer.toString(i), (boolean)true);
            c.put((Object)i, (Object)new TestLargeValue(Base64.getEncoder().encodeToString(randomPart), compressablePart));
            if (i > 10000) {
                int idToRmv = i - 10000;
                ZstdCompressionPersistentDictionaryWithRestartsTest.assertTrue((boolean)c.remove((Object)idToRmv));
            }
            if (i % 1000 != 0) continue;
            ignite.close();
            ignite = this.startGrid(0);
            c = ignite.cache("default");
        }
    }

    private int countDictionaries(IgniteEx grid, IgniteCache c, boolean active) {
        MetricRegistry mreg = grid.context().metric().registry("cacheGroups." + c.getName() + ".compression");
        return ((IntMetric)mreg.findMetric(active ? "ActiveDictionaries" : "TrainedDictionaries")).value();
    }

    private static class TestKey {
        private String key;
        @AffinityKeyMapped
        private int affKey;

        private TestKey(long seed) {
            this.key = Long.toHexString(seed);
            this.affKey = 0xFFF & (int)seed;
        }
    }
}

