/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.spi.metric.DoubleMetric;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.cache.compress.GzipCompressionConfiguration;
import org.junit.Test;

public class GzipCompressionPersistenceTest
extends GridCommonAbstractTest {
    private static final int CYCLE = 10000;
    private static final String STRING = "Lorem ipsum dolor sit amet, consectetur adipiscing elit";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setMetricsEnabled(true).setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMetricsEnabled(true).setPersistenceEnabled(true).setMaxSize(0x4000000L)));
        return cfg;
    }

    private CacheConfiguration cacheConfiguration() {
        return new CacheConfiguration("default").setEntryCompressionConfiguration((EntryCompressionConfiguration)new GzipCompressionConfiguration());
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void test() throws Exception {
        this.startGrids(2);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        IgniteCache c = this.grid(1).createCache(this.cacheConfiguration());
        for (int i = 0; i < 10000; ++i) {
            c.put((Object)i, (Object)new TestObject(i, STRING.substring(i % 50) + STRING.substring(i * 2 % 50) + STRING.substring(i * 3 % 50)));
        }
        GzipCompressionPersistenceTest.assertEquals((int)10000, (int)c.size(new CachePeekMode[0]));
        for (Cache.Entry entry : c) {
        }
        this.checkMetrics(true);
    }

    private void checkMetrics(boolean decompress) {
        MetricRegistry mreg = this.grid(0).context().metric().registry("cacheGroups.default.compression");
        double acceptance = ((DoubleMetric)mreg.findMetric("Acceptance")).value();
        GzipCompressionPersistenceTest.assertTrue((String)("Acceptance: " + acceptance), (acceptance > 0.7 && acceptance <= 1.0 ? 1 : 0) != 0);
        double ratio = ((DoubleMetric)mreg.findMetric("Ratio")).value();
        GzipCompressionPersistenceTest.assertTrue((String)("Ratio: " + ratio), (ratio > 0.5 && ratio < 0.9 ? 1 : 0) != 0);
        long totalCompNum = ((LongMetric)mreg.findMetric("RecordsCompressed")).value();
        GzipCompressionPersistenceTest.assertTrue((String)("RecordsCompressed: " + totalCompNum), (totalCompNum > 3333L && totalCompNum < 30000L ? 1 : 0) != 0);
        long totalCompBytes = ((LongMetric)mreg.findMetric("BytesCompressed")).value();
        GzipCompressionPersistenceTest.assertTrue((String)("BytesCompressed: " + totalCompBytes), (totalCompBytes > 500000L && totalCompBytes < 3000000L ? 1 : 0) != 0);
        if (decompress) {
            long totalDecompNum = ((LongMetric)mreg.findMetric("RecordsDecompressed")).value();
            GzipCompressionPersistenceTest.assertTrue((String)("RecordsDecompressed: " + totalDecompNum), (totalDecompNum > 1666L && totalDecompNum < 20000L ? 1 : 0) != 0);
            long totalDecompBytes = ((LongMetric)mreg.findMetric("BytesDecompressed")).value();
            GzipCompressionPersistenceTest.assertTrue((String)("BytesDecompressed: " + totalDecompBytes), (totalDecompBytes > 100000L && totalDecompBytes < 1000000L ? 1 : 0) != 0);
        }
    }

    private static class TestObject {
        private long lVal;
        private String strVal;

        private TestObject(long lVal, String strVal) {
            this.lVal = lVal;
            this.strVal = strVal;
        }
    }
}

