/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import java.io.IOException;
import java.time.Instant;
import java.util.Iterator;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.cache.compress.ZstdDictionaryCompressionConfiguration;
import org.gridgain.grid.cache.compress.values.TestObject;
import org.gridgain.grid.cache.compress.values.TestTable;
import org.junit.Test;

public class EntryCompressionComplexityTest
extends GridCommonAbstractTest {
    private static final int MAX_ITEMS = 50000;

    protected CacheConfiguration<Object, Object> cacheConfiguration() {
        return new CacheConfiguration("default").setEntryCompressionConfiguration((EntryCompressionConfiguration)new ZstdDictionaryCompressionConfiguration().setSamplesBufferSize(131072).setCompressKeys(true));
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrid(0);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testDataStreamer() throws Exception {
        IgniteEx ignite = this.grid(0);
        IgniteCache c = ignite.createCache(this.cacheConfiguration());
        TimeTook tt = new TimeTook((Ignite)ignite);
        this.populateDataStreamer((Ignite)ignite, c.getName(), false);
        tt.checkAndReport("dsIsolated1", 50000, 1, 0);
        tt = new TimeTook((Ignite)ignite);
        this.populateDataStreamer((Ignite)ignite, c.getName(), true);
        tt.checkAndReport("dsIndividual2", 50000, 1, 1);
        tt = new TimeTook((Ignite)ignite);
        c.removeAll();
        tt.checkAndReport("dsRmvAll", 50000, 0, 2);
        tt = new TimeTook((Ignite)ignite);
        this.populateDataStreamer((Ignite)ignite, c.getName(), true);
        tt.checkAndReport("dsIndividual1", 50000, 1, 0);
        tt = new TimeTook((Ignite)ignite);
        this.populateDataStreamer((Ignite)ignite, c.getName(), false);
        tt.checkAndReport("dsIsolated2", 50000, 1, 1);
        tt = new TimeTook((Ignite)ignite);
        c.clear();
        tt.checkAndReport("dsClear", 50000, 0, 2);
    }

    @Test
    public void testPrimitiveKey() throws Exception {
        IgniteEx ignite = this.grid(0);
        IgniteCache c = ignite.createCache(this.cacheConfiguration());
        TimeTook tt = new TimeTook((Ignite)ignite);
        this.populatePrimitive(c);
        tt.checkAndReport("popPrimKey", 50000, 1, 0);
        tt = new TimeTook((Ignite)ignite);
        this.iterate(c);
        tt.checkAndReport("iterPrimKey", 250000, 0, 1);
        tt = new TimeTook((Ignite)ignite);
        this.randomGetPrimitive(c);
        tt.checkAndReport("getPrimKey", 100000, 0, 1);
        tt = new TimeTook((Ignite)ignite);
        this.randomPutPrimitive(c);
        tt.checkAndReport("putPrimKey", 25000, 1, 1);
        tt = new TimeTook((Ignite)ignite);
        c.clear();
        tt.checkAndReport("clearAllPrimKey", 50000, 0, 2);
    }

    @Test
    public void testCompositeKey() throws Exception {
        IgniteEx ignite = this.grid(0);
        IgniteCache c = ignite.createCache(this.cacheConfiguration());
        TimeTook tt = new TimeTook((Ignite)ignite);
        this.populateComposite(c);
        tt.checkAndReport("popCompKey", 50000, 1, 0);
        tt = new TimeTook((Ignite)ignite);
        this.iterate(c);
        tt.checkAndReport("iterCompKey", 250000, 0, 1);
        tt = new TimeTook((Ignite)ignite);
        this.randomGetComposite(c);
        tt.checkAndReport("getCompKey", 100000, 0, 1);
        tt = new TimeTook((Ignite)ignite);
        this.randomPutComposite(c);
        tt.checkAndReport("putCompKey", 25000, 1, 2);
        tt = new TimeTook((Ignite)ignite);
        c.removeAll();
        tt.checkAndReport("rmvAllCompKey", 50000, 1, 3);
    }

    @Test
    public void testIndexed() throws Exception {
        IgniteEx ignite = this.grid(0);
        IgniteCache c = ignite.createCache(this.cacheConfiguration().setIndexedTypes(new Class[]{Long.class, TestTable.class}));
        TimeTook tt = new TimeTook((Ignite)ignite);
        this.populateIndexed(c);
        tt.checkAndReport("popIndexed", 50000, 1, 0);
        tt = new TimeTook((Ignite)ignite);
        this.iterate(c);
        tt.checkAndReport("iterIndexed", 250000, 0, 1);
        tt = new TimeTook((Ignite)ignite);
        this.randomGetPrimitive(c);
        tt.checkAndReport("getIndexed", 100000, 0, 1);
        tt = new TimeTook((Ignite)ignite);
        this.randomPutIndexed(c);
        tt.checkAndReport("putIndexed", 25000, 1, 1);
        tt = new TimeTook((Ignite)ignite);
        this.randomSelect(c);
        tt.checkAndReport("selectOneIndexed", 50000, 0, 1);
        tt = new TimeTook((Ignite)ignite);
        this.randomRangeSelect(c);
        tt.checkAndReport("selectRangeIndexed", 25000, 0, 2);
        tt = new TimeTook((Ignite)ignite);
        this.randomUpdateIndexed(c);
        tt.checkAndReport("updateIndexed", 25000, 1, 2);
        tt = new TimeTook((Ignite)ignite);
        this.removeAllFromIterator(c);
        tt.checkAndReport("rmvIterIndexed", 50000, 0, 2);
    }

    private void populateDataStreamer(Ignite ignite, String cacheName, boolean allowOverwrite) {
        try (IgniteDataStreamer ds = ignite.dataStreamer(cacheName);){
            ds.allowOverwrite(allowOverwrite);
            for (long i = 0L; i < 50000L; ++i) {
                long seed = i * i % Integer.MAX_VALUE;
                ds.addData((Object)seed, (Object)new TestObject(seed));
            }
        }
    }

    private void iterate(IgniteCache c) {
        for (int j = 0; j < 5; ++j) {
            for (Object e : c) {
            }
        }
    }

    private void populateComposite(IgniteCache c) {
        for (long i = 0L; i < 50000L; ++i) {
            long seed = i * i % Integer.MAX_VALUE;
            c.put((Object)new TestObject(seed), (Object)seed);
        }
    }

    private void populatePrimitive(IgniteCache c) {
        for (long i = 0L; i < 50000L; ++i) {
            long seed = i * i % Integer.MAX_VALUE;
            c.put((Object)seed, (Object)new TestObject(seed));
        }
    }

    private void populateIndexed(IgniteCache c) {
        for (long i = 0L; i < 50000L; ++i) {
            long seed = i * i % Integer.MAX_VALUE;
            c.put((Object)seed, (Object)new TestTable(seed));
        }
    }

    private void randomPutComposite(IgniteCache c) {
        for (long i = 0L; i < 50000L; i += 2L) {
            long seed = i * i % Integer.MAX_VALUE;
            c.put((Object)new TestObject(seed), (Object)seed);
        }
    }

    private void randomPutPrimitive(IgniteCache c) {
        for (long i = 0L; i < 50000L; i += 2L) {
            long seed = i * i % Integer.MAX_VALUE;
            c.put((Object)seed, (Object)new TestObject(seed));
        }
    }

    private void randomPutIndexed(IgniteCache c) {
        for (long i = 0L; i < 50000L; i += 2L) {
            long seed = i * i % Integer.MAX_VALUE;
            c.put((Object)seed, (Object)new TestTable(seed));
        }
    }

    private void randomUpdateIndexed(IgniteCache c) {
        for (long i = 0L; i < 50000L; i += 2L) {
            long seed = i * i % Integer.MAX_VALUE;
            c.query(new SqlFieldsQuery("UPDATE TestTable SET dVal = dVal + 1 WHERE lVal = ?").setArgs(new Object[]{seed}));
        }
    }

    private void randomGetComposite(IgniteCache c) {
        for (int j = 0; j < 2; ++j) {
            for (long i = 0L; i < 50000L; ++i) {
                long seed = i * i % Integer.MAX_VALUE;
                c.get((Object)new TestObject(seed)).hashCode();
            }
        }
    }

    private void randomGetPrimitive(IgniteCache c) {
        for (int j = 0; j < 2; ++j) {
            for (long i = 0L; i < 50000L; ++i) {
                long seed = i * i % Integer.MAX_VALUE;
                c.get((Object)seed).hashCode();
            }
        }
    }

    private void randomSelect(IgniteCache c) {
        for (long i = 0L; i < 50000L; ++i) {
            long seed = i * i % Integer.MAX_VALUE;
            c.query(new SqlFieldsQuery("SELECT _val FROM TestTable WHERE lVal = ?").setArgs(new Object[]{seed})).getAll().iterator().next();
        }
    }

    private void randomRangeSelect(IgniteCache c) {
        for (long i = 0L; i < 25000L; ++i) {
            long min = i * i % Integer.MAX_VALUE;
            long next = (i + 1L) * (i + 1L) % Integer.MAX_VALUE;
            long max = Math.max(min, next);
            min = Math.min(min, next);
            for (Object row : c.query(new SqlFieldsQuery("SELECT _val FROM TestTable WHERE dateVal BETWEEN ? AND ? LIMIT 10").setArgs(new Object[]{TestTable.DATE_FMT.format(Instant.ofEpochMilli(min)), TestTable.DATE_FMT.format(Instant.ofEpochMilli(max))})).getAll()) {
                row.hashCode();
            }
        }
    }

    private void removeAllFromIterator(IgniteCache c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    private static long currentCpuTicks() throws IOException {
        return IgniteUtils.isLinux() ? Long.parseLong(U.readFileToString((String)"/proc/self/stat", (String)"UTF-8").split(" ")[13]) : 0L;
    }

    public class TimeTook {
        private final long started = System.currentTimeMillis();
        private final long ticks = EntryCompressionComplexityTest.access$000();
        private final Ignite ignite;
        private final MetricRegistry mreg;
        private final long compressions;
        private final long decompressions;
        private volatile boolean reported = false;

        public TimeTook(Ignite ignite) throws IOException {
            this.ignite = ignite;
            this.mreg = ((IgniteEx)ignite).context().metric().registry("cacheGroups.default.compression");
            this.compressions = ((LongMetric)this.mreg.findMetric("RecordsCompressed")).value();
            this.decompressions = ((LongMetric)this.mreg.findMetric("RecordsDecompressed")).value();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkAndReport(String op, int iterations, int compressesPerOp, int decompressesPerOp) throws IOException {
            try {
                if (this.reported) {
                    throw new IllegalStateException("Called twice!");
                }
                long dCompressions = ((LongMetric)this.mreg.findMetric("RecordsCompressed")).value() - this.compressions;
                long dDecompressions = ((LongMetric)this.mreg.findMetric("RecordsDecompressed")).value() - this.decompressions;
                log.info("Time took: [op=" + op + ", " + "wallClock=" + (double)(System.currentTimeMillis() - this.started) / 1000.0 + "s, cpuTime=" + (double)(EntryCompressionComplexityTest.currentCpuTicks() - this.ticks) / 1000.0 + "s, totalAllocatedSize=" + this.ignite.dataRegionMetrics("default").getTotalAllocatedSize() + ", compressions=" + dCompressions + ", decompressions=" + dDecompressions + "]");
                EntryCompressionComplexityTest.assertEquals((double)compressesPerOp, (double)Math.round((double)dCompressions / (double)iterations));
                EntryCompressionComplexityTest.assertEquals((double)decompressesPerOp, (double)Math.round((double)dDecompressions / (double)iterations));
            }
            finally {
                this.reported = true;
            }
        }
    }
}

