/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import java.net.URLEncoder;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.cache.compress.ZstdDictionaryCompressionConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridPluginUtils;
import org.junit.Test;

@WithSystemProperty(key="licenseUrl", value="")
public class GridLicenseProcessorCompressionTest
extends GridCommonAbstractTest {
    public static final String COMPRESSED_CACHE = "compressed";
    public String licenseFileName;
    public AtomicBoolean createCache = new AtomicBoolean(false);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        String licFolder = GridPluginUtils.homePath((String)"modules/core/src/test/config/license");
        String licUrl = "file:///" + URLEncoder.encode(licFolder + "/" + this.licenseFileName, "UTF-8");
        cfg.setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration()});
        cfg.setUserAttributes(F.asMap((Object)"attrKey", (Object)"attrVal"));
        GridPluginUtils.setGridGainLicenseUrl((IgniteConfiguration)cfg, (String)licUrl);
        if (this.createCache.compareAndSet(true, false)) {
            cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheCfg()});
        }
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testCompressionFeatureAbsenceStaticCache() throws Exception {
        this.licenseFileName = "license.xml";
        this.startGrid(1);
        try {
            this.createCache.set(true);
            this.startGrid(2);
        }
        catch (Exception ex) {
            GridLicenseProcessorCompressionTest.assertTrue((boolean)X.hasCause((Throwable)ex, (String)"Entry compression is not allowed by the licence", (Class[])new Class[]{IgniteException.class}));
            GridLicenseProcessorCompressionTest.assertEquals((int)1, (int)this.grid(1).cluster().nodes().size());
            GridLicenseProcessorCompressionTest.assertNull((Object)this.grid(1).cache(COMPRESSED_CACHE));
            GridLicenseProcessorCompressionTest.assertFalse((boolean)this.createCache.get());
            this.startGrid(2);
            this.checkClusterWorks();
            return;
        }
        GridLicenseProcessorCompressionTest.fail((String)"Expected exception not thrown");
    }

    @Test
    public void testCompressionFeatureAbsenceDynamicCache() throws Exception {
        this.licenseFileName = "license.xml";
        this.startGrid(1);
        this.startGrid(2);
        try {
            this.grid(1).createCache(this.cacheCfg());
        }
        catch (Exception ex) {
            GridLicenseProcessorCompressionTest.assertTrue((boolean)X.hasCause((Throwable)ex, (String)"Entry compression is not allowed by the licence", (Class[])new Class[]{IgniteException.class}));
            GridLicenseProcessorCompressionTest.assertNull((Object)this.grid(1).cache(COMPRESSED_CACHE));
            this.checkClusterWorks();
            return;
        }
        GridLicenseProcessorCompressionTest.fail((String)"Expected exception not thrown");
    }

    @Test
    public void testCompressionFeaturePresentStaticCache() throws Exception {
        this.featurePresentStaticCache("license-compression.xml");
    }

    @Test
    public void testCompressionFeaturePresentDynamicCache() throws Exception {
        this.featurePresentDynamicCache("license-compression.xml");
    }

    @Test
    public void testUltimateFeaturePresentStaticCache() throws Exception {
        this.featurePresentStaticCache("license-features.xml");
    }

    @Test
    public void testUltimateFeaturePresentDynamicCache() throws Exception {
        this.featurePresentDynamicCache("license-features.xml");
    }

    private void featurePresentStaticCache(String license) throws Exception {
        this.licenseFileName = license;
        this.startGrid(1);
        this.createCache.set(true);
        this.startGrid(2);
        this.checkClusterWorks();
    }

    private void featurePresentDynamicCache(String license) throws Exception {
        this.licenseFileName = license;
        this.startGrid(1);
        this.startGrid(2).createCache(this.cacheCfg());
        this.checkClusterWorks();
    }

    private void checkClusterWorks() throws Exception {
        IgniteEx ignite = this.grid(1);
        GridLicenseProcessorCompressionTest.assertEquals((int)2, (int)this.grid(1).cluster().nodes().size());
        IgniteCache c = ignite.createCache(new CacheConfiguration("default").setCacheMode(CacheMode.REPLICATED));
        c.put((Object)1, (Object)"foo");
        c.put((Object)2, (Object)"baz");
        this.grid(2).close();
        this.startGrid(2);
        this.awaitPartitionMapExchange();
        GridLicenseProcessorCompressionTest.assertEquals((int)2, (int)c.size(new CachePeekMode[0]));
        GridLicenseProcessorCompressionTest.assertEquals((Object)"baz", (Object)this.grid(2).cache("default").get((Object)2));
    }

    private CacheConfiguration<Object, Object> cacheCfg() {
        return new CacheConfiguration(COMPRESSED_CACHE).setEntryCompressionConfiguration((EntryCompressionConfiguration)new ZstdDictionaryCompressionConfiguration());
    }
}

