/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.ZstdDictTrainer;
import com.github.luben.zstd.ZstdInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.compress.EntryCompressionStrategy;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.spi.IgniteSpiException;
import org.gridgain.grid.cache.compress.DictionaryCompressionMetrics;
import org.gridgain.grid.cache.compress.DictionarySampler;
import org.gridgain.grid.cache.compress.ZstdDictionaryCompressionConfiguration;
import org.jetbrains.annotations.Nullable;

class ZstdDictionaryCompressionStrategy
implements EntryCompressionStrategy {
    private static final float MIN_DICTIONARY_ROTATION_BENEFIT = 0.02f;
    private static final int MIN_DELTA_BYTES = 6;
    private static final String DICTIONARY_FILE_PREFIX = "zstdict-";
    private final NumberFormat RATIO = new DecimalFormat("#0.###", new DecimalFormatSymbols(Locale.US));
    private final int compressionLevel;
    private final int dictionarySize;
    private final boolean requireDictionary;
    private final int samplesBufSz;
    private final boolean compressKeys;
    private GridKernalContext ctx;
    private String cacheName;
    private DictionaryCompressionMetrics metrics;
    private DictionarySampler sampler;
    private File persistenceDir;
    private volatile IgniteBiTuple<Integer, ZstdDictCompress> compressor;
    private volatile AtomicReferenceArray<ZstdDictDecompress> decompressors;
    private static final byte DICT_MASK = 127;

    private byte @Nullable [] appraiseAndAddHeader(byte[] input, byte[] compressed, int dict) {
        int inputLen = input.length;
        if (compressed != null) {
            assert ((dict & 0x7F) == dict);
            compressed[0] = (byte)dict;
        }
        if (compressed != null && inputLen - compressed.length >= 6) {
            if (this.metrics != null) {
                this.metrics.onTryCompress(true, inputLen, compressed.length);
            }
            return compressed;
        }
        if (this.metrics != null) {
            this.metrics.onTryCompress(false, inputLen, 0);
        }
        return null;
    }

    public byte[] decompress(byte[] bytes) {
        if (this.metrics != null) {
            this.metrics.onDecompress(bytes == null ? 0 : bytes.length);
        }
        if (bytes == null) {
            throw new IgniteException("Argument is null");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        byte header = (byte)in.read();
        if (header <= 0) {
            throw new IgniteException("Unknown compression header value: " + header);
        }
        byte dict = (byte)(header & 0x7F);
        return ZstdDictionaryCompressionStrategy.decompress(in, dict == 127 ? null : this.dictionary(dict));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] decompress(ByteArrayInputStream in, ZstdDictDecompress dict) {
        byte[] dst = new byte[in.available() * 3];
        try (ZstdInputStream zin = new ZstdInputStream((InputStream)in);){
            int len;
            if (dict != null) {
                zin.setDict(dict);
            }
            if ((len = zin.read(dst)) < dst.length) {
                byte[] byArray = Arrays.copyOf(dst, len);
                return byArray;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            do {
                out.write(dst, 0, len);
            } while ((len = zin.read(dst)) > 0);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new IgniteException((Throwable)ex);
        }
    }

    public byte @Nullable [] tryCompress(byte[] input) {
        DictionarySampler sampler0 = this.sampler;
        if (input != null && input.length > 0) {
            IgniteBiTuple<Integer, ZstdDictCompress> compressor0;
            if (sampler0 != null && sampler0.add(input)) {
                this.ctx.closure().runLocalSafe(() -> this.trainDictionary(sampler0));
            }
            if ((compressor0 = this.compressor) != null) {
                byte[] compressed = ZstdDictionaryCompressionStrategy.compress(input, (ZstdDictCompress)compressor0.get2());
                return this.appraiseAndAddHeader(input, compressed, (Integer)compressor0.get1());
            }
            if (!this.requireDictionary) {
                byte[] compressed = ZstdDictionaryCompressionStrategy.compressWithoutDictionary(input, this.compressionLevel);
                return this.appraiseAndAddHeader(input, compressed, 127);
            }
        }
        if (this.metrics != null) {
            this.metrics.onTryCompress(false, input == null ? 0 : input.length, 0);
        }
        return null;
    }

    private void trainDictionary(DictionarySampler sampler) {
        sampler.withSamples((IgniteBiInClosure<Integer, Collection<byte[]>>)(IgniteBiInClosure & Serializable)(bufSz, samples) -> {
            boolean replace;
            ZstdDictDecompress newDecompressor;
            ZstdDictCompress newCompressor;
            byte[] newDictionary;
            Object sample2;
            IgniteInternalCache cache = this.ctx.cache().cache(this.cacheName);
            IgniteLogger log = cache != null ? cache.context().logger(ZstdDictionaryCompressionConfiguration.class) : this.ctx.log(ZstdDictionaryCompressionConfiguration.class);
            int index = 0;
            for (int i = 1; i <= this.decompressors.length(); ++i) {
                if (this.decompressors.get(i - 1) != null) continue;
                index = i;
                break;
            }
            if (index == 0) {
                if (log != null) {
                    log.warning("Cannot train new dictionary since limit is reached");
                }
                return;
            }
            try {
                ZstdDictTrainer trainer = new ZstdDictTrainer(bufSz.intValue(), this.dictionarySize);
                Iterator iterator = samples.iterator();
                while (iterator.hasNext()) {
                    sample2 = (byte[])iterator.next();
                    if (((byte[])sample2).length <= 0) continue;
                    trainer.addSample(sample2);
                }
                newDictionary = trainer.trainSamples();
                newCompressor = new ZstdDictCompress(newDictionary, this.compressionLevel);
                newDecompressor = new ZstdDictDecompress(newDictionary);
                if (this.metrics != null) {
                    this.metrics.onDictionaryTrained();
                }
            }
            catch (Exception e) {
                log.warning("Failed to train dictionary. Possible reasons are: " + U.nl() + "  ^-- Too many or too few samples (by number or total length)." + U.nl() + "  ^-- Dictionary size too small or too large (use defaults for reference)." + U.nl() + "  ^-- Mismatch between samples length and dictionary size." + U.nl() + "  ^-- Samples did not produce a dictionary by being too random or uniform.", (Throwable)e);
                return;
            }
            int newCompressedSz = 0;
            for (Object sample2 : samples) {
                newCompressedSz += ZstdDictionaryCompressionStrategy.compress(sample2, newCompressor).length;
            }
            int oldCompressedSz = 0;
            if (this.compressor != null) {
                sample2 = samples.iterator();
                while (sample2.hasNext()) {
                    byte[] sample3 = (byte[])sample2.next();
                    oldCompressedSz += ZstdDictionaryCompressionStrategy.compress(sample3, (ZstdDictCompress)this.compressor.get2()).length;
                }
            }
            float newRatio = (float)newCompressedSz / (float)bufSz.intValue();
            float oldRatio = oldCompressedSz == 0 ? 0.0f : (float)oldCompressedSz / (float)bufSz.intValue();
            boolean bl = replace = oldRatio == 0.0f || oldRatio - newRatio > 0.02f;
            if (log != null && log.isInfoEnabled()) {
                if (oldRatio == 0.0f) {
                    log.info("Trained initial dictionary [idx=" + index + ", bufSz=" + bufSz + ", samples=" + samples.size() + ", ratio=" + this.RATIO.format(newRatio) + "]");
                } else {
                    log.info("Trained " + (replace ? "rotation" : "discarded") + " dictionary [idx=" + index + ", bufSz=" + bufSz + ", samples=" + samples.size() + ", newRatio=" + this.RATIO.format(newRatio) + ", oldRatio=" + this.RATIO.format(oldRatio) + "]");
                }
            }
            if (replace) {
                try {
                    if (cache != null ? cache.context().group().persistenceEnabled() : this.persistenceDir != null) {
                        this.saveDictionary(index, newDictionary);
                    }
                }
                catch (Exception e) {
                    log.warning("Failed to store dictionary to file system, it will be discarded", (Throwable)e);
                    throw new IgniteException((Throwable)e);
                }
                if (this.metrics != null) {
                    this.metrics.onDictionaryActivated();
                }
                this.decompressors.set(index - 1, newDecompressor);
                this.compressor = new IgniteBiTuple((Object)index, (Object)newCompressor);
            }
        });
    }

    private static byte[] compress(byte[] src, ZstdDictCompress dict) {
        long maxDstSize = Zstd.compressBound((long)src.length);
        if (maxDstSize > Integer.MAX_VALUE) {
            throw new IgniteException("Max output size is greater than MAX_INT");
        }
        byte[] dst = new byte[(int)maxDstSize + 1];
        long size = Zstd.compressFastDict((byte[])dst, (int)1, (byte[])src, (int)0, (int)src.length, (ZstdDictCompress)dict);
        if (Zstd.isError((long)size)) {
            throw new IgniteException(Zstd.getErrorName((long)size));
        }
        return Arrays.copyOfRange(dst, 0, (int)size + 1);
    }

    private static byte[] compressWithoutDictionary(byte[] src, int level) {
        long maxDstSize = Zstd.compressBound((long)src.length);
        if (maxDstSize > Integer.MAX_VALUE) {
            throw new IgniteException("Max output size is greater than MAX_INT");
        }
        byte[] dst = new byte[(int)maxDstSize + 1];
        long size = Zstd.compressByteArray((byte[])dst, (int)1, (int)(dst.length - 1), (byte[])src, (int)0, (int)src.length, (int)level);
        if (Zstd.isError((long)size)) {
            throw new IgniteException(Zstd.getErrorName((long)size));
        }
        return Arrays.copyOfRange(dst, 0, (int)size + 1);
    }

    private ZstdDictDecompress dictionary(byte dict) {
        assert (dict > 0 && dict < 127) : "Incorrect dictionary index: " + dict;
        assert (this.decompressors != null) : "Decompressors array is null";
        ZstdDictDecompress decompressor = this.decompressors.get(dict - 1);
        assert (decompressor != null) : "Decompressor is not ready: " + dict;
        return decompressor;
    }

    ZstdDictionaryCompressionStrategy(ZstdDictionaryCompressionConfiguration cfg) {
        this.compressionLevel = cfg.getCompressionLevel();
        this.dictionarySize = cfg.getDictionarySize();
        this.requireDictionary = cfg.isRequireDictionary();
        this.samplesBufSz = cfg.getSamplesBufferSize();
        this.compressKeys = cfg.isCompressKeys();
        if (this.dictionarySize < 0) {
            throw new IgniteSpiException("Dictionary size should be non-negative");
        }
        if (this.stateless() && this.requireDictionary) {
            throw new IgniteSpiException("Dictionary is required but dictionary size is zero");
        }
        if ((long)this.samplesBufSz < 0L) {
            throw new IgniteSpiException("Samples buffer size should be non-negative");
        }
        if (!this.stateless() && (long)this.samplesBufSz == 0L) {
            throw new IgniteSpiException("Dictionary is required but samples buffer size is zero");
        }
    }

    public synchronized void start(GridKernalContext ctx, CacheConfiguration ccfg) {
        this.ctx = ctx;
        this.cacheName = ccfg.getName();
        this.metrics = new DictionaryCompressionMetrics(ctx, ZstdDictionaryCompressionConfiguration.class.getName(), this.stateless(), ccfg.getName());
        if (!this.stateless()) {
            this.decompressors = new AtomicReferenceArray(126);
            IgnitePageStoreManager pageStoreMgr = ctx.cache().context().pageStore();
            int loadedDictionaries = 0;
            if (pageStoreMgr instanceof FilePageStoreManager) {
                this.persistenceDir = ((FilePageStoreManager)pageStoreMgr).cacheWorkDir(ccfg);
                try {
                    loadedDictionaries = this.loadDictionaries();
                }
                catch (IOException ioe) {
                    throw new IgniteSpiException("Failed to load dictionaries: " + ioe);
                }
            }
            this.sampler = new DictionarySampler(this.samplesBufSz, loadedDictionaries, this.metrics);
        }
    }

    public void close() {
        try {
            if (this.compressor != null) {
                ((ZstdDictCompress)this.compressor.get2()).close();
            }
            this.compressor = null;
            if (this.decompressors != null) {
                for (int i = 0; i < this.decompressors.length(); ++i) {
                    ZstdDictDecompress decompressor = this.decompressors.get(i);
                    if (decompressor == null) continue;
                    decompressor.close();
                }
                this.decompressors = new AtomicReferenceArray(126);
            }
        }
        finally {
            this.metrics.close();
        }
    }

    public boolean compressKeys() {
        return this.compressKeys;
    }

    public boolean stateless() {
        return (long)this.dictionarySize == 0L;
    }

    private void saveDictionary(int index, byte[] dictionary) throws IOException {
        assert (this.persistenceDir != null) : "persistenceDir should not be null";
        File tmp = new File(this.persistenceDir, DICTIONARY_FILE_PREFIX + index + ".tmp");
        try (FileOutputStream os = new FileOutputStream(tmp);){
            os.write(dictionary);
            os.flush();
            os.getFD().sync();
        }
        File file = new File(this.persistenceDir, DICTIONARY_FILE_PREFIX + index + ".bin");
        if (file.exists() || !tmp.renameTo(file)) {
            throw new IOException("Dictionary file already exists or cannot be created: " + file);
        }
    }

    private int loadDictionaries() throws IOException {
        assert (this.persistenceDir != null) : "persistenceDir should not be null";
        if (!this.persistenceDir.exists()) {
            return 0;
        }
        int index = 0;
        byte[] dictionary = null;
        for (int i = 1; i <= this.decompressors.length(); ++i) {
            File file = new File(this.persistenceDir, DICTIONARY_FILE_PREFIX + i + ".bin");
            if (!file.exists()) continue;
            long len = file.length();
            if (!file.exists() || len <= 0L || len > Integer.MAX_VALUE) continue;
            ByteBuffer buf = ByteBuffer.allocate((int)len);
            try (FileInputStream is = new FileInputStream(file);){
                int b;
                while ((b = is.read()) != -1) {
                    buf.put((byte)b);
                }
            }
            assert (len == (long)buf.position());
            buf.position(0);
            dictionary = new byte[buf.remaining()];
            buf.get(dictionary);
            index = i;
            this.decompressors.set(index - 1, new ZstdDictDecompress(dictionary));
            if (this.metrics == null) continue;
            this.metrics.onDictionaryActivated();
        }
        if (index > 0) {
            this.compressor = new IgniteBiTuple((Object)index, (Object)new ZstdDictCompress(dictionary, this.compressionLevel));
        }
        return index;
    }
}

