/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import java.io.Closeable;
import java.io.Serializable;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.DoubleMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.IntMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteExperimental;
import org.gridgain.grid.cache.compress.CompressionMetrics;
import org.gridgain.grid.cache.compress.DictionaryMetrics;

@IgniteExperimental
class DictionaryCompressionMetrics
implements CompressionMetrics,
DictionaryMetrics,
Closeable {
    private static final int BATCH_SIZE = 1000;
    public static final String COMPRESSION_METRICS = "compression";
    private final GridKernalContext ctx;
    private final String name;
    private final LongAdderMetric bytesCompressed;
    private final LongAdderMetric recordsCompressed;
    private final LongAdderMetric bytesDecompressed;
    private final LongAdderMetric recordsDecompressed;
    private final IntMetricImpl acceptanceDivisor;
    private final IntMetricImpl acceptanceDividend;
    private final DoubleMetricImpl acceptance;
    private final LongAdderMetric ratioDivisor;
    private final LongAdderMetric ratioDividend;
    private final DoubleMetricImpl ratio;
    private final IntMetricImpl trainedDictionaries;
    private final IntMetricImpl activeDictionaries;
    private final IntMetricImpl collectedSamples;
    private final IntMetricImpl collectedBytes;

    public DictionaryCompressionMetrics(GridKernalContext ctx, String implName, boolean stateless, String cacheName) {
        this.ctx = ctx;
        this.name = MetricUtils.metricName((String[])new String[]{MetricUtils.cacheGroupMetricsRegistryName((String)cacheName), COMPRESSION_METRICS});
        MetricRegistry mreg = ctx.metric().registry(this.name);
        mreg.objectMetric("Implementation", String.class, "Name of compression implementation.").value((Object)implName);
        this.bytesCompressed = mreg.longAdderMetric("BytesCompressed", "Total compression input bytes.");
        this.recordsCompressed = mreg.longAdderMetric("RecordsCompressed", "Total compression number of records.");
        this.bytesDecompressed = mreg.longAdderMetric("BytesDecompressed", "Total decompression input bytes.");
        this.recordsDecompressed = mreg.longAdderMetric("RecordsDecompressed", "Total decompression number of records.");
        this.acceptanceDivisor = new IntMetricImpl("acceptanceDivisor", "");
        this.acceptanceDividend = new IntMetricImpl("acceptanceDividend", "");
        this.acceptance = mreg.doubleMetric("Acceptance", "Fraction of records which were actually compressed.");
        this.ratioDivisor = new LongAdderMetric("ratioDivisor", "");
        this.ratioDividend = new LongAdderMetric("ratioDividend", "");
        this.ratio = mreg.doubleMetric("Ratio", "Ratio of compressed data size to uncompressed.");
        IgniteBiClosure & Serializable constructor = stateless ? IntMetricImpl::new : (arg_0, arg_1) -> ((MetricRegistry)mreg).intMetric(arg_0, arg_1);
        this.trainedDictionaries = (IntMetricImpl)constructor.apply((Object)"TrainedDictionaries", (Object)"Number of trained dictionaries.");
        this.activeDictionaries = (IntMetricImpl)constructor.apply((Object)"ActiveDictionaries", (Object)"Number of active dictionaries.");
        this.collectedSamples = (IntMetricImpl)constructor.apply((Object)"CollectedSamples", (Object)"Number of samples collected currently.");
        this.collectedBytes = (IntMetricImpl)constructor.apply((Object)"CollectedSampleBytes", (Object)"Total number of bytes of samples collected currently.");
    }

    @Override
    public void close() {
        this.ctx.metric().remove(this.name);
    }

    @Override
    public double acceptance() {
        return this.acceptance.value();
    }

    @Override
    public double ratio() {
        return this.ratio.value();
    }

    @Override
    public long bytesCompressed() {
        return this.bytesCompressed.value();
    }

    @Override
    public long recordsCompressed() {
        return this.recordsCompressed.value();
    }

    @Override
    public long bytesDecompressed() {
        return this.bytesDecompressed.value();
    }

    @Override
    public long recordsDecompressed() {
        return this.recordsDecompressed.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTryCompress(boolean accepted, int uncompressed, int compressed) {
        this.recordsCompressed.increment();
        this.bytesCompressed.add((long)uncompressed);
        this.acceptanceDivisor.increment();
        if (accepted) {
            this.acceptanceDividend.increment();
            this.ratioDivisor.add((long)uncompressed);
            this.ratioDividend.add((long)compressed);
        }
        if (this.acceptanceDivisor.value() >= 1000) {
            DictionaryCompressionMetrics dictionaryCompressionMetrics = this;
            synchronized (dictionaryCompressionMetrics) {
                int acc = this.acceptanceDivisor.value();
                if (acc >= 1000) {
                    double curAcceptance = (double)this.acceptanceDividend.value() / (double)acc;
                    double curRatio = this.ratioDividend.value() == 0L ? 1.0 : (double)this.ratioDividend.value() / (double)this.ratioDivisor.value();
                    this.acceptanceDividend.reset();
                    this.acceptanceDivisor.reset();
                    this.ratioDividend.reset();
                    this.ratioDivisor.reset();
                    this.acceptance.value(curAcceptance);
                    this.ratio.value(curRatio);
                }
            }
        }
    }

    public void onDecompress(int compressed) {
        this.recordsDecompressed.increment();
        this.bytesDecompressed.add((long)compressed);
    }

    @Override
    public int activeDictionaries() {
        return this.activeDictionaries.value();
    }

    @Override
    public int trainedDictionaries() {
        return this.trainedDictionaries.value();
    }

    @Override
    public int collectedSamples() {
        return this.collectedSamples.value();
    }

    @Override
    public int collectedBytes() {
        return this.collectedBytes.value();
    }

    public void onDictionaryTrained() {
        this.trainedDictionaries.increment();
    }

    public void onDictionaryActivated() {
        this.activeDictionaries.increment();
    }

    public void onSampleCollected(int len) {
        this.collectedSamples.increment();
        this.collectedBytes.add(len);
    }

    public void onSampleDiscarded(int len) {
        this.collectedSamples.add(-1);
        this.collectedBytes.add(-len);
    }
}

