/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.spi.metric.DoubleMetric;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.cache.compress.ZstdDictionaryCompressionConfiguration;
import org.gridgain.grid.cache.compress.values.TestLargeValue;
import org.gridgain.grid.cache.compress.values.TestObject;
import org.gridgain.internal.h2.util.StringUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ZstdCompressionParameterVariationsTest
extends GridCommonAbstractTest {
    private static final int MAX_ITER = 1000000;
    @Parameterized.Parameter(value=0)
    public int compressionLevel;
    @Parameterized.Parameter(value=1)
    public int dictionarySz;
    @Parameterized.Parameter(value=2)
    public int sampleBufSz;
    @Parameterized.Parameter(value=3)
    public boolean requireDictionary;
    @Parameterized.Parameter(value=4)
    public boolean compressKeys;

    @Parameterized.Parameters(name="lvl={0}, dictSize={1}, sampleBufSz={2}, reqDict={3}, keys={4}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({-7, 6144, 1024000, true, false}, {5, 2047, 512000, true, true}, {-99, 512, 1024000, false, false}, {100, 272, 102400, false, true}, {8, 272, 256000, true, false}, {0, 0, 0, false, false}, {3, 16384, 32768, false, true});
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTest();
        this.startGrids(2);
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws InterruptedException {
        IgniteCache c = this.grid(0).createCache(new CacheConfiguration("default").setEntryCompressionConfiguration((EntryCompressionConfiguration)new ZstdDictionaryCompressionConfiguration().setSamplesBufferSize(this.sampleBufSz).setCompressionLevel(this.compressionLevel).setDictionarySize(this.dictionarySz).setCompressKeys(this.compressKeys).setRequireDictionary(this.requireDictionary)));
        MetricRegistry mreg = this.grid(1).context().metric().registry("cacheGroups.default.compression");
        try {
            for (int i = 0; i <= 1000000; ++i) {
                c.put((Object)new TestObject(i), (Object)new TestLargeValue(Integer.toString(i), StringUtils.pad((String)"", (int)512, (String)Integer.toString(i), (boolean)true)));
                if (i % 1000 == 0) {
                    double acceptance = ((DoubleMetric)mreg.findMetric("Acceptance")).value();
                    double ratio = ((DoubleMetric)mreg.findMetric("Ratio")).value();
                    if (acceptance > 0.0 && ratio < 1.0) {
                        log.info("After " + i + " items acceptance is " + acceptance + ", ratio is " + ratio);
                        break;
                    }
                }
                ZstdCompressionParameterVariationsTest.assertTrue((String)"Iteration limit reached", (i < 1000000 ? 1 : 0) != 0);
            }
        }
        finally {
            c.destroy();
            this.awaitPartitionMapExchange();
            ZstdCompressionParameterVariationsTest.assertEquals((int)0, (int)this.grid(0).context().metric().registry("cacheGroups.default.compression").metrics().size());
            ZstdCompressionParameterVariationsTest.assertEquals((int)0, (int)this.grid(1).context().metric().registry("cacheGroups.default.compression").metrics().size());
        }
    }
}

