/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.cache.compress.ZstdDictionaryCompressionConfiguration;
import org.gridgain.grid.cache.compress.values.TestObject;
import org.junit.Test;

public class ZstdCompressionMixedBinaryTest
extends GridCommonAbstractTest {
    private static final int CYCLE = 10000;

    private CacheConfiguration cacheConfiguration(int n) {
        return new CacheConfiguration("default" + n).setEntryCompressionConfiguration((EntryCompressionConfiguration)new ZstdDictionaryCompressionConfiguration().setSamplesBufferSize(32768));
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrids(2);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    @Test
    public void test() {
        IgniteCache c1 = this.grid(1).createCache(this.cacheConfiguration(1));
        IgniteCache c2 = this.grid(1).createCache(this.cacheConfiguration(2));
        IgniteCache c3 = this.grid(0).createCache(this.cacheConfiguration(3));
        IgniteCache c4 = this.grid(0).getOrCreateCache(this.cacheConfiguration(2));
        for (int i = 0; i < 10000; ++i) {
            TestObject pojo = new TestObject(i);
            BinaryObject val = (BinaryObject)this.grid(i % 2).binary().toBinary((Object)pojo);
            int n = i % 4;
            if (n == 0) {
                c1.put((Object)i, (Object)val);
            }
            if (n == 0 || n == 1) {
                c2.put((Object)i, (Object)val);
            }
            if (n != 3) {
                c3.put((Object)i, (Object)val);
            }
            c4.put((Object)i, (Object)val);
            if (n != 0) {
                c1.put((Object)i, (Object)val);
            }
            if (n == 2 || n == 3) {
                c2.put((Object)i, (Object)val);
            }
            if (n != 3) continue;
            c3.put((Object)i, (Object)val);
        }
        int j = 0;
        for (Object c : c1) {
            ++j;
        }
        for (Object c : c2) {
            j += 4;
        }
        for (Object c : c3) {
            j -= 2;
        }
        for (Object c : c4) {
            j -= 3;
        }
        ZstdCompressionMixedBinaryTest.assertEquals((String)"Unexpected number of entries in cache", (int)0, (int)j);
    }
}

