/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.function.BiConsumer;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.metric.IntMetric;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.cache.compress.ZstdDictionaryCompressionConfiguration;
import org.junit.Test;

public class ZstdCompressionDictionaryCorruptionTest
extends GridCommonAbstractTest {
    private static final int CYCLE = 20000;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setMetricsEnabled(true).setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMetricsEnabled(true).setPersistenceEnabled(true).setMaxSize(0x4000000L)));
        return cfg;
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testDictionaryEmpty() throws Exception {
        this.dictionaryCorrupted((x, dict) -> {
            try {
                dict.createNewFile();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    @Test
    public void testDictionaryTruncated() throws Exception {
        this.dictionaryCorrupted((old, dict) -> {
            try (FileInputStream is = new FileInputStream((File)old);
                 FileOutputStream os = new FileOutputStream((File)dict);){
                int i = 0;
                while ((long)i < old.length() / 2L) {
                    ((OutputStream)os).write(((InputStream)is).read());
                    ++i;
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    @Test
    public void testDictionaryGarbage() throws Exception {
        this.dictionaryCorrupted((old, dict) -> {
            Random r = new Random();
            try (FileOutputStream os = new FileOutputStream((File)dict);){
                int i = 0;
                while ((long)i < old.length()) {
                    ((OutputStream)os).write((byte)r.nextInt(256));
                    ++i;
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private void dictionaryCorrupted(BiConsumer<File, File> corruptor) throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteCache c = ignite.createCache(this.cacheConfiguration());
        for (int i = 0; i < 20000; ++i) {
            c.put((Object)i, (Object)new TestObject(i, Integer.toString(i)));
        }
        int dict = this.countDictionaries(ignite, c);
        ZstdCompressionDictionaryCorruptionTest.assertTrue((this.countDictionaries(ignite, c) > 0 ? 1 : 0) != 0);
        String consistentId = ignite.localNode().consistentId().toString();
        ignite.close();
        File db = new File(new File(U.defaultWorkDirectory()), "db");
        ZstdCompressionDictionaryCorruptionTest.assertTrue((boolean)db.isDirectory());
        File node = new File(db, "node00-" + consistentId);
        ZstdCompressionDictionaryCorruptionTest.assertTrue((boolean)node.isDirectory());
        File cache = new File(node, "cache-default");
        ZstdCompressionDictionaryCorruptionTest.assertTrue((boolean)cache.exists());
        File existing = new File(cache, "zstdict-" + dict + ".bin");
        ZstdCompressionDictionaryCorruptionTest.assertTrue((boolean)existing.isFile());
        File corrupted = new File(cache, "zstdict-" + (dict + 1) + ".bin");
        ZstdCompressionDictionaryCorruptionTest.assertFalse((boolean)corrupted.isFile());
        corruptor.accept(existing, corrupted);
        ignite = this.startGrid(0);
        ignite.cluster().state(ClusterState.ACTIVE);
        c = ignite.cache("default");
        for (int i = 10000; i < 30000; ++i) {
            c.put((Object)i, (Object)new TestObject(i, ((TestObject)c.get((Object)(i / 2))).strVal));
        }
        int newDict = this.countDictionaries(ignite, c);
        ZstdCompressionDictionaryCorruptionTest.assertTrue((newDict >= dict ? 1 : 0) != 0);
        ignite.close();
    }

    private CacheConfiguration cacheConfiguration() {
        return new CacheConfiguration("default").setEntryCompressionConfiguration((EntryCompressionConfiguration)new ZstdDictionaryCompressionConfiguration().setSamplesBufferSize(196608));
    }

    private int countDictionaries(IgniteEx grid, IgniteCache c) {
        MetricRegistry mreg = grid.context().metric().registry("cacheGroups." + c.getName() + ".compression");
        return ((IntMetric)mreg.findMetric("ActiveDictionaries")).value();
    }

    private static class TestObject {
        private long lVal;
        private String strVal;

        private TestObject(long lVal, String strVal) {
            this.lVal = lVal;
            this.strVal = strVal;
        }
    }
}

