/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.compress;

import java.util.Arrays;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.compress.EntryCompressionStrategy;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.cache.compress.ZstdDictionaryCompressionConfiguration;
import org.junit.Test;

public class ZstdCompressionSelfTest
extends GridCommonAbstractTest {
    @Test
    public void test() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        EntryCompressionStrategy entryCompressionStrategy = ((IgniteCacheProxy)ignite.getOrCreateCache(new CacheConfiguration("foo").setEntryCompressionConfiguration((EntryCompressionConfiguration)new ZstdDictionaryCompressionConfiguration().setRequireDictionary(false).setDictionarySize(0)))).context().cacheObjectContext().compressionStrategy();
        ZstdCompressionSelfTest.assertEquals(null, (Object)entryCompressionStrategy.tryCompress(null));
        ZstdCompressionSelfTest.assertEquals(null, (Object)entryCompressionStrategy.tryCompress(new byte[0]));
        ZstdCompressionSelfTest.assertEquals(null, (Object)entryCompressionStrategy.tryCompress(new byte[8]));
        ZstdCompressionSelfTest.assertEquals((int)18, (int)entryCompressionStrategy.tryCompress(new byte[24]).length);
        byte[] b = (ZstdCompressionSelfTest.class.getName() + ZstdCompressionSelfTest.class.getName()).getBytes();
        ZstdCompressionSelfTest.assertTrue((boolean)Arrays.equals(b, entryCompressionStrategy.decompress(entryCompressionStrategy.tryCompress(b))));
        ZstdCompressionSelfTest.assertEquals((int)0xA00000, (int)entryCompressionStrategy.decompress(entryCompressionStrategy.tryCompress(new byte[0xA00000])).length);
        ignite.close();
    }
}

